/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.query.util.assembler.DatasetAssemblerException;
import com.hp.hpl.jena.query.util.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import java.util.List;

public class DataSourceAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return DatasetAssemblerVocab.tDataset;
    }

    public Object open(Assembler a, Resource root, Mode mode) {
        DataSource ds = DatasetFactory.create();
        Resource dftGraph = GraphUtils.getResourceValue(root, DatasetAssemblerVocab.pDefaultGraph);
        if (dftGraph == null) {
            dftGraph = GraphUtils.getResourceValue(root, DatasetAssemblerVocab.pGraph);
        }
        Model dftModel = a.openModel(dftGraph);
        ds.setDefaultModel(dftModel);
        List nodes = GraphUtils.multiValue(root, DatasetAssemblerVocab.pNamedGraph);
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            RDFNode n = (RDFNode)iter.next();
            if (!(n instanceof Resource)) {
                throw new DatasetAssemblerException(root, "Not a resource: " + FmtUtils.stringForRDFNode(n));
            }
            Resource r = (Resource)n;
            String gName = GraphUtils.getAsStringValue(r, DatasetAssemblerVocab.pGraphName);
            Resource g = GraphUtils.getResourceValue(r, DatasetAssemblerVocab.pGraph);
            Model m = a.openModel(g);
            ds.addNamedModel(gName, m);
        }
        if (ds.getDefaultModel() == null) {
            ds.setDefaultModel(ModelFactory.createDefaultModel());
        }
        return ds;
    }
}

