/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.owl.ui;

import com.sun.research.owl.ui.OntologyBrowser;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;

public class InstanceRenderer
extends JLabel
implements ListCellRenderer {
    private OntologyBrowser browser;

    public InstanceRenderer(OntologyBrowser aBrowser) {
        this.browser = aBrowser;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return this;
        }
        OWLIndividual individual = (OWLIndividual)value;
        String label = null;
        try {
            label = this.browser.getStringFromAnnotation((OWLObject)individual, this.browser.getRdfLabel());
        }
        catch (OWLException e) {
            e.printStackTrace();
        }
        if (label != null) {
            this.setText(label);
        } else {
            this.setText(individual.toString());
        }
        String comment = null;
        try {
            comment = this.browser.getStringFromAnnotation((OWLObject)individual, this.browser.getRdfComment());
        }
        catch (OWLException e1) {
            e1.printStackTrace();
        }
        if (comment != null) {
            this.setToolTipText(comment);
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setOpaque(true);
        return this;
    }
}

