/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.owl.ui;

import com.sun.research.owl.ui.InputPanel;
import com.sun.research.owl.ui.RendererPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.semanticweb.owl.io.Renderer;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLManager;
import org.semanticweb.owl.validation.OWLValidationConstants;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import org.xml.sax.SAXException;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

public class OWLProcessor
extends JPanel
implements OWLValidationConstants {
    private OWLRDFParser rdfParser = null;
    private OWLOntology onto = null;
    private Renderer renderer = null;
    private boolean warnings = false;
    private int validation = 1;
    private InputPanel ontologyInputPanel;
    private RendererPanel ontologyRendererPanel;
    private JTextArea textOutput = new JTextArea(30, 50);
    private JTextArea warningOutput = new JTextArea(5, 50);
    private JCheckBox warningCheckBox = new JCheckBox();
    private JRadioButton liteRadioButton = new JRadioButton();
    private JRadioButton dlRadioButton = new JRadioButton();
    private JRadioButton fullRadioButton = new JRadioButton();

    public OWLProcessor() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.weightx = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        this.ontologyInputPanel = new InputPanel("Ontology");
        this.add((Component)this.ontologyInputPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.5;
        c.anchor = 23;
        this.add((Component)this.getValidationPanel(), c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.5;
        this.ontologyRendererPanel = new RendererPanel();
        this.add((Component)this.ontologyRendererPanel, c);
        JButton processButton = new JButton();
        processButton.setText("Process");
        processButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OWLProcessor.this.processButtonActionPerformed(evt);
            }
        });
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)processButton, c);
        JScrollPane textScrollPane = new JScrollPane();
        this.textOutput.setEditable(false);
        textScrollPane.setViewportView(this.textOutput);
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 1;
        c.gridwidth = 0;
        c.weighty = 1.0;
        this.add((Component)textScrollPane, c);
        c.gridx = 0;
        c.gridy = 4;
        c.weighty = 0.4;
        c.gridheight = 0;
        this.add(this.getWarningPanel(), c);
    }

    private Component getWarningPanel() {
        JPanel warningPanel = new JPanel();
        warningPanel.setLayout(new BorderLayout());
        this.warningCheckBox.setText("Warnings");
        this.warningCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OWLProcessor.this.warningCheckBoxItemChanged(evt);
            }
        });
        warningPanel.add((Component)this.warningCheckBox, "First");
        JScrollPane warningScrollPane = new JScrollPane();
        this.warningOutput.setEditable(false);
        warningScrollPane.setViewportView(this.warningOutput);
        warningPanel.add((Component)warningScrollPane, "Center");
        return warningPanel;
    }

    private JPanel getValidationPanel() {
        JPanel validationPanel = new JPanel();
        validationPanel.setLayout(new BoxLayout(validationPanel, 1));
        validationPanel.setBorder(BorderFactory.createTitledBorder("Validation"));
        ButtonGroup validationButtonGroup = new ButtonGroup();
        ActionListener validationActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                OWLProcessor.this.validationButtonChanged(event);
            }
        };
        this.liteRadioButton.setText("Lite");
        this.liteRadioButton.setSelected(false);
        this.liteRadioButton.addActionListener(validationActionListener);
        validationButtonGroup.add(this.liteRadioButton);
        validationPanel.add(this.liteRadioButton);
        this.dlRadioButton.setText("DL");
        this.dlRadioButton.setSelected(true);
        this.dlRadioButton.addActionListener(validationActionListener);
        validationButtonGroup.add(this.dlRadioButton);
        validationPanel.add(this.dlRadioButton);
        this.fullRadioButton.setText("Full");
        this.fullRadioButton.setSelected(false);
        this.fullRadioButton.addActionListener(validationActionListener);
        validationButtonGroup.add(this.fullRadioButton);
        validationPanel.add(this.fullRadioButton);
        return validationPanel;
    }

    private void validationButtonChanged(ActionEvent event) {
        Object button = event.getSource();
        if (button == this.liteRadioButton) {
            this.validation = 0;
        }
        if (button == this.dlRadioButton) {
            this.validation = 1;
        }
        if (button == this.fullRadioButton) {
            this.validation = 3;
        }
    }

    private void processButtonActionPerformed(ActionEvent evt) {
        this.resetValidateButtons();
        try {
            this.process();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e, "Exception", 0);
        }
    }

    private void resetValidateButtons() {
        this.liteRadioButton.setForeground(Color.BLACK);
        this.dlRadioButton.setForeground(Color.BLACK);
        this.fullRadioButton.setForeground(Color.BLACK);
    }

    private void warningCheckBoxItemChanged(ItemEvent evt) {
        this.warnings = evt.getStateChange() == 1;
    }

    private void process() throws Exception {
        URI uri = null;
        String input = this.ontologyInputPanel.getText();
        if (input.length() == 0) {
            this.warn("No URI Specified");
            throw new Exception("No URI Specified");
        }
        uri = new URI(input);
        this.rdfParser = new OWLRDFParser();
        this.vaildate(uri);
        if (this.warnings) {
            OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

                public void owlFullConstruct(int code, String message) throws SAXException {
                }

                public void error(String message) throws SAXException {
                    throw new SAXException(message.toString());
                }

                public void warning(String message) throws SAXException {
                    OWLProcessor.this.warn("WARNING: " + message);
                }

                public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                }
            };
            this.rdfParser.setOWLRDFErrorHandler(handler);
        }
        this.rdfParser.setConnection(OWLManager.getOWLConnection());
        this.onto = this.rdfParser.parseOntology(uri);
        StringWriter writer = new StringWriter();
        this.renderer = this.ontologyRendererPanel.getRenderer();
        if (this.renderer != null) {
            this.renderer.renderOntology(this.onto, (Writer)writer);
            this.textOutput.setText(((Object)writer).toString());
        } else {
            this.warn("No renderer");
        }
    }

    private void vaildate(URI uri) throws OWLException {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter(new SpeciesValidatorReporter(){

            public void ontology(OWLOntology onto) {
            }

            public void done(String str) {
            }

            public void message(String str) {
                System.out.println(str);
            }

            public void explain(int l, int code, String str) {
            }
        });
        if (this.validation == 0) {
            this.validateButton(this.liteRadioButton, sv.isOWLLite(uri));
        } else if (this.validation == 1) {
            this.validateButton(this.dlRadioButton, sv.isOWLDL(uri));
        } else if (this.validation == 3) {
            this.validateButton(this.fullRadioButton, sv.isOWLFull(uri));
        }
    }

    private void validateButton(JRadioButton aButton, boolean aBoolean) {
        if (aBoolean) {
            aButton.setForeground(Color.GREEN);
        } else {
            aButton.setForeground(Color.red);
        }
    }

    private void warn(String warning) {
        this.warningOutput.append(warning);
    }

    public static void main(String[] args) {
        JFrame window = new JFrame("OWLProcessor");
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        OWLProcessor panel = new OWLProcessor();
        window.getContentPane().add((Component)panel, "Center");
        window.pack();
        window.setSize(window.getPreferredSize());
        window.show();
    }
}

