/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.owl.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.helper.OntologyHelper;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.reasoner.ReasonerException;
import uk.ac.man.cs.img.dig.reasoner.impl.HTTPReasoner;
import uk.ac.man.cs.img.owl.inference.dl.SimpleOWLReasoner;

public class OntologyBrowser {
    protected Reasoner digReasoner = null;
    protected SimpleOWLReasoner reasoner = null;
    protected OWLOntology onto = null;
    protected OWLAnnotationProperty rdfLabel;
    protected OWLAnnotationProperty rdfComment;

    public void setReasonerURL(String reasonerURL) throws ReasonerException, OWLException {
        this.digReasoner = new HTTPReasoner(reasonerURL);
        this.reasoner = new SimpleOWLReasoner(this.digReasoner);
    }

    public void setOntologyURL(String ontologyURI) throws URISyntaxException, OWLException {
        URI uri = new URI(ontologyURI);
        this.onto = OntologyHelper.getOntology((URI)uri);
        this.reasoner.setOntology(this.onto);
        this.setAnnotationProperties();
    }

    protected void setAnnotationProperties() throws OWLException, URISyntaxException {
        this.rdfLabel = this.getAnnotationProperty(new URI(OWLVocabularyAdapter.INSTANCE.getLabel()));
        this.rdfComment = this.getAnnotationProperty(new URI(OWLVocabularyAdapter.INSTANCE.getComment()));
    }

    protected OWLClass getClass(URI classURI) throws OWLException {
        Set closure = this.getClosure();
        Iterator iter = closure.iterator();
        while (iter.hasNext()) {
            OWLOntology element = (OWLOntology)iter.next();
            OWLClass cls = element.getClass(classURI);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    private Set getClosure() throws OWLException {
        Set closure = null;
        closure = OntologyHelper.importClosure((OWLOntology)this.onto);
        return closure;
    }

    protected SimpleOWLReasoner getReasoner() {
        return this.reasoner;
    }

    protected OWLAnnotationProperty getRdfComment() {
        return this.rdfComment;
    }

    protected OWLAnnotationProperty getRdfLabel() {
        return this.rdfLabel;
    }

    public Set instancesOf(OWLClass cls) throws OWLException {
        return this.reasoner.instancesOf((OWLDescription)cls);
    }

    private OWLAnnotationProperty getAnnotationProperty(URI propertyURI) throws OWLException {
        Set closure = this.getClosure();
        Iterator iter = closure.iterator();
        while (iter.hasNext()) {
            OWLOntology element = (OWLOntology)iter.next();
            OWLAnnotationProperty prop = element.getAnnotationProperty(propertyURI);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    protected String getStringFromAnnotation(OWLObject oo, OWLAnnotationProperty oap) throws OWLException {
        Set annos = oo.getAnnotations();
        Iterator annoIt = annos.iterator();
        while (annoIt.hasNext()) {
            OWLAnnotationInstance annInst = (OWLAnnotationInstance)annoIt.next();
            if (!annInst.getProperty().equals(oap)) continue;
            if (annInst.getContent() instanceof OWLDataValue) {
                String lab = (String)((OWLDataValue)annInst.getContent()).getValue();
                return lab;
            }
            String lab = annInst.getContent().toString();
            return lab;
        }
        return null;
    }

    public Set getInstances() throws OWLException {
        HashSet allInstances = new HashSet();
        Set closure = this.getClosure();
        Iterator iter = closure.iterator();
        while (iter.hasNext()) {
            OWLOntology element = (OWLOntology)iter.next();
            Set instances = element.getIndividuals();
            if (instances == null) continue;
            allInstances.addAll(instances);
        }
        return allInstances;
    }

    public Set classesOf(OWLIndividual ind) throws OWLException {
        return ind.getTypes(this.getClosure());
    }

    public Set superClassesOf(OWLDescription d) throws OWLException {
        HashSet superclasses = new HashSet();
        Iterator it = this.reasoner.superClassesOf(d).iterator();
        while (it.hasNext()) {
            superclasses.addAll((Collection)it.next());
        }
        return superclasses;
    }

    public Set subClassesOf(OWLDescription d) throws OWLException {
        HashSet subclasses = new HashSet();
        Iterator it = this.reasoner.subClassesOf(d).iterator();
        while (it.hasNext()) {
            subclasses.addAll((Collection)it.next());
        }
        return subclasses;
    }

    public OWLDescription getOWLNothing() throws OWLException {
        return this.onto.getOWLDataFactory().getOWLNothing();
    }

    public OWLDescription getOWLThing() throws OWLException {
        return this.onto.getOWLDataFactory().getOWLThing();
    }
}

