/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.owl.ui;

import com.sun.research.owl.ui.InputPanel;
import com.sun.research.owl.ui.InstanceRenderer;
import com.sun.research.owl.ui.OntologyBrowser;
import com.sun.research.owl.ui.OntologyBrowserController;
import com.sun.research.owl.ui.OntologyNodeRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import uk.ac.man.cs.img.dig.reasoner.ReasonerException;

public class OntologyBrowserView
extends JPanel {
    private OntologyBrowser browser = new OntologyBrowser();
    private String reasonerURL = "http://localhost:8080/";
    private String urlString = "http://home.btconnect.com/wivenhoe/anteater/devices/Devices.owl";
    private JTree ontologyTree = null;
    private String rootString = "http://home.btconnect.com/wivenhoe/anteater/Notifier.owl#Notifier";
    private OWLClass rootClass = null;
    private JScrollPane treePane;
    private JScrollPane instancePane;
    private JList instanceList;
    private InputPanel digReasonerPanel;
    private InputPanel ontologyInputPanel;
    private InputPanel rootNodePanel;

    public OntologyBrowserView() {
        this.initComponents();
    }

    protected void initTreeModel() throws ReasonerException, URISyntaxException, OWLException {
        this.browser.setReasonerURL(this.digReasonerPanel.getText());
        this.browser.setOntologyURL(this.ontologyInputPanel.getText());
        URI rootURI = new URI(this.rootNodePanel.getText());
        this.rootClass = this.browser.getClass(rootURI);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.rootClass);
        Set subclasses = this.browser.subClassesOf((OWLDescription)this.rootClass);
        this.addChildrenToNode(subclasses, root);
        DefaultTreeModel tModel = new DefaultTreeModel(root);
        this.ontologyTree.setModel(tModel);
        this.ontologyTree.setVisible(true);
    }

    protected void addChildrenToNode(Set classes, DefaultMutableTreeNode node) throws OWLException {
        OWLDescription nothing = this.browser.getOWLNothing();
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            OWLDescription element = (OWLDescription)iter.next();
            if (element == nothing) continue;
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(element);
            node.add(childNode);
            Set subclasses = this.browser.subClassesOf(element);
            this.addChildrenToNode(subclasses, childNode);
        }
    }

    public static void main(String[] args) {
        JFrame window = new JFrame("Ontology Browser");
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        OntologyBrowserView panel = new OntologyBrowserView();
        window.getContentPane().add((Component)panel, "Center");
        window.pack();
        window.setSize(window.getPreferredSize());
        window.show();
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.weightx = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        this.digReasonerPanel = new InputPanel("Reasoner");
        this.digReasonerPanel.setText(this.reasonerURL);
        this.add((Component)this.digReasonerPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 0;
        c.weightx = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        this.ontologyInputPanel = new InputPanel("Ontology");
        this.ontologyInputPanel.setText(this.urlString);
        this.add((Component)this.ontologyInputPanel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 0;
        c.weightx = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        this.rootNodePanel = new InputPanel("Root Node");
        this.rootNodePanel.setText(this.rootString);
        this.add((Component)this.rootNodePanel, c);
        JButton processButton = new JButton();
        processButton.setText("Process");
        processButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OntologyBrowserView.this.processButtonActionPerformed(evt);
            }
        });
        c.gridx = 0;
        c.gridy = 3;
        this.add((Component)processButton, c);
        this.treePane = new JScrollPane();
        this.ontologyTree = new JTree(new DefaultMutableTreeNode());
        this.ontologyTree.setVisible(false);
        this.ontologyTree.setCellRenderer(new OntologyNodeRenderer(this.browser));
        this.ontologyTree.getSelectionModel().setSelectionMode(1);
        this.ontologyTree.addTreeSelectionListener(new OntologyBrowserController(this));
        ToolTipManager.sharedInstance().registerComponent(this.ontologyTree);
        this.treePane.setViewportView(this.ontologyTree);
        this.treePane.setMinimumSize(new Dimension(100, 100));
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 1;
        c.gridwidth = -1;
        c.weighty = 1.0;
        c.weightx = 0.75;
        this.add((Component)this.treePane, c);
        this.instancePane = new JScrollPane();
        this.instanceList = new JList();
        this.instanceList.setCellRenderer(new InstanceRenderer(this.browser));
        ToolTipManager.sharedInstance().registerComponent(this.instanceList);
        this.instancePane.setViewportView(this.instanceList);
        this.instancePane.setMinimumSize(new Dimension(100, 100));
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 0.5;
        c.gridwidth = 0;
        this.add((Component)this.instancePane, c);
    }

    private void processButtonActionPerformed(ActionEvent evt) {
        try {
            this.process();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e, "Exception", 0);
        }
    }

    protected void process() throws ReasonerException, URISyntaxException, OWLException {
        this.initTreeModel();
        this.clearInstanceList();
    }

    protected void clearInstanceList() {
        this.instanceList.setListData(new Object[0]);
    }

    public JTree getOntologyTree() {
        return this.ontologyTree;
    }

    public OntologyBrowser getBrowser() {
        return this.browser;
    }

    public void displayInstancesOf(OWLClass cls) throws OWLException {
        Set instances = this.browser.instancesOf(cls);
        DefaultListModel listModel = new DefaultListModel();
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            listModel.addElement(iter.next());
        }
        this.instanceList.setModel(listModel);
    }
}

