/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.owl.ui;

import com.sun.research.owl.ui.OntologyBrowser;
import java.awt.Component;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObject;

public class OntologyNodeRenderer
extends DefaultTreeCellRenderer {
    private OntologyBrowser browser;

    public OntologyNodeRenderer(OntologyBrowser aBrowser) {
        this.browser = aBrowser;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        OWLClass cls = (OWLClass)node.getUserObject();
        if (cls == null) {
            return this;
        }
        String myLabel = this.getLabel(cls);
        this.setText(myLabel);
        String myComment = this.getComment(cls);
        if (myComment != null) {
            this.setToolTipText(myComment);
        } else {
            this.setToolTipText(null);
        }
        return this;
    }

    private String getLabel(OWLClass cls) {
        URI myURI = null;
        try {
            myURI = cls.getURI();
        }
        catch (OWLException e) {
            e.printStackTrace();
        }
        String rdfLabel = null;
        try {
            rdfLabel = this.browser.getStringFromAnnotation((OWLObject)cls, this.browser.getRdfLabel());
        }
        catch (OWLException e1) {
            e1.printStackTrace();
        }
        StringBuffer buffer = new StringBuffer();
        if (rdfLabel != null) {
            buffer.append(rdfLabel);
        } else {
            buffer.append(myURI.getFragment());
        }
        Set individuals = new HashSet();
        try {
            individuals = this.browser.instancesOf(cls);
        }
        catch (OWLException e2) {
            e2.printStackTrace();
        }
        if (individuals.size() > 0) {
            buffer.append(" (");
            buffer.append(individuals.size());
            buffer.append(")");
        }
        return buffer.toString();
    }

    private String getComment(OWLClass cls) {
        URI myURI = null;
        try {
            myURI = cls.getURI();
        }
        catch (OWLException e) {
            e.printStackTrace();
        }
        StringBuffer rdfComment = new StringBuffer();
        rdfComment.append(myURI);
        rdfComment.append("\n");
        String comment = null;
        try {
            comment = this.browser.getStringFromAnnotation((OWLObject)cls, this.browser.getRdfComment());
        }
        catch (OWLException e1) {
            e1.printStackTrace();
        }
        if (comment != null) {
            rdfComment.append(comment);
        }
        return rdfComment.toString();
    }
}

