/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.owl.ui;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import uk.ac.man.cs.img.owl.io.tptp.Renderer;

public class RendererPanel
extends JPanel {
    private JRadioButton tptpButton = new JRadioButton();
    private JTextField renderingClassField = new JTextField();
    private JRadioButton renderingClassButton = new JRadioButton();
    private JRadioButton abstractSyntaxButton = new JRadioButton();

    public RendererPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder("Renderer"));
        ButtonGroup rendererButtonGroup = new ButtonGroup();
        this.abstractSyntaxButton.setText("Abstract Syntax");
        this.abstractSyntaxButton.setSelected(true);
        rendererButtonGroup.add(this.abstractSyntaxButton);
        this.add(this.abstractSyntaxButton);
        this.tptpButton.setText("TPTP");
        this.tptpButton.setSelected(false);
        rendererButtonGroup.add(this.tptpButton);
        this.add(this.tptpButton);
        this.renderingClassButton.setText("Renderer Class");
        this.renderingClassButton.setSelected(false);
        rendererButtonGroup.add(this.renderingClassButton);
        this.add(this.renderingClassButton);
        this.renderingClassField.setText("org.semanticweb.owl.io.owl_rdf.Renderer");
        this.add(this.renderingClassField);
    }

    public org.semanticweb.owl.io.Renderer getRenderer() {
        if (this.abstractSyntaxButton.isSelected()) {
            return new org.semanticweb.owl.io.abstract_syntax.Renderer();
        }
        if (this.tptpButton.isSelected()) {
            return new Renderer();
        }
        if (this.renderingClassButton.isSelected()) {
            String renderingClass = this.renderingClassField.getText();
            try {
                return (org.semanticweb.owl.io.Renderer)ClassLoader.getSystemClassLoader().loadClass(renderingClass).newInstance();
            }
            catch (Exception ex) {
                System.err.println("Cannot create renderer " + renderingClass + "\n" + ex.getMessage());
                return null;
            }
        }
        return null;
    }
}

