/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.owl.ui;

import com.sun.research.owl.ui.InputPanel;
import com.sun.research.owl.ui.RendererPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.semanticweb.owl.inference.OWLTaxonomyReasoner;
import org.semanticweb.owl.io.Renderer;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.helper.OntologyHelper;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.reasoner.impl.HTTPReasoner;
import uk.ac.man.cs.img.owl.inference.InferenceHelper;
import uk.ac.man.cs.img.owl.inference.dl.SimpleOWLTaxonomyReasoner;

public class TaxonomyReasoner
extends JPanel {
    private InputPanel ontologyInputPanel;
    private InputPanel digReasonerPanel;
    private RendererPanel ontologyRendererPanel;
    private JTextArea textOutput = new JTextArea(30, 50);

    public TaxonomyReasoner() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.weightx = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        this.digReasonerPanel = new InputPanel("Reasoner");
        this.digReasonerPanel.setText("http://localhost:8080");
        this.add((Component)this.digReasonerPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 0;
        c.weightx = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        this.ontologyInputPanel = new InputPanel("Ontology");
        this.add((Component)this.ontologyInputPanel, c);
        JButton processButton = new JButton();
        processButton.setText("Process");
        processButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaxonomyReasoner.this.processButtonActionPerformed(evt);
            }
        });
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = -1;
        this.add((Component)processButton, c);
        this.ontologyRendererPanel = new RendererPanel();
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 0;
        this.add((Component)this.ontologyRendererPanel, c);
        JScrollPane textScrollPane = new JScrollPane();
        this.textOutput.setEditable(false);
        textScrollPane.setViewportView(this.textOutput);
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 1;
        c.gridwidth = 0;
        c.weighty = 1.0;
        this.add((Component)textScrollPane, c);
    }

    public static void main(String[] args) {
        JFrame window = new JFrame("Taxonomy Reasoner");
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        TaxonomyReasoner panel = new TaxonomyReasoner();
        window.getContentPane().add((Component)panel, "Center");
        window.pack();
        window.setSize(window.getPreferredSize());
        window.show();
    }

    private void processButtonActionPerformed(ActionEvent evt) {
        try {
            this.process();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e, "Exception", 0);
        }
    }

    private void process() throws Exception {
        HTTPReasoner digReasoner = null;
        String reasonerURL = this.digReasonerPanel.getText();
        if (reasonerURL.length() == 0) {
            System.err.println("No reasoner specified");
            throw new Exception("No Resoner specified");
        }
        digReasoner = new HTTPReasoner(reasonerURL);
        SimpleOWLTaxonomyReasoner reasoner = new SimpleOWLTaxonomyReasoner((Reasoner)digReasoner);
        URI uri = null;
        String input = this.ontologyInputPanel.getText();
        if (input.length() == 0) {
            System.err.println("No URI Specified");
            throw new Exception("No URI Specified");
        }
        uri = new URI(input);
        OWLOntology onto = OntologyHelper.getOntology((URI)uri);
        reasoner.setOntology(onto);
        OWLOntology hierarchy = InferenceHelper.hierarchyAsNewOntology((OWLTaxonomyReasoner)reasoner);
        Renderer renderer = this.ontologyRendererPanel.getRenderer();
        StringWriter writer = new StringWriter();
        renderer.renderOntology(hierarchy, (Writer)writer);
        this.textOutput.setText(((Object)writer).toString());
    }
}

