/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetImpl
implements Dataset {
    protected DatasetGraph dsg = null;
    private Map<Graph, Model> cache = new HashMap<Graph, Model>();

    public DatasetImpl(Model model) {
        this.addToCache(model);
        this.dsg = new DataSourceGraphImpl(model.getGraph());
    }

    public DatasetImpl(DatasetGraph dsg) {
        this.dsg = dsg;
    }

    @Override
    public Model getDefaultModel() {
        return this.graph2model(this.dsg.getDefaultGraph());
    }

    @Override
    public Lock getLock() {
        return this.dsg.getLock();
    }

    @Override
    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    @Override
    public Model getNamedModel(String uri) {
        return this.graph2model(this.dsg.getGraph(Node.createURI((String)uri)));
    }

    @Override
    public boolean containsNamedModel(String uri) {
        return this.dsg.containsGraph(Node.createURI((String)uri));
    }

    @Override
    public void close() {
        this.cache = null;
        this.dsg.close();
    }

    @Override
    public Iterator<String> listNames() {
        return NodeUtils.nodesToURIs(this.dsg.listGraphNodes());
    }

    private void removeFromCache(Graph graph) {
        if (graph == null) {
            return;
        }
        this.cache.remove(graph);
    }

    private void addToCache(Model model) {
        this.cache.put(model.getGraph(), model);
    }

    private Model graph2model(Graph graph) {
        Model model = this.cache.get(graph);
        if (model == null) {
            model = ModelFactory.createModelForGraph((Graph)graph);
            this.cache.put(graph, model);
        }
        return model;
    }
}

