/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction.library;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterExtendByVar;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterYieldN;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArgType;
import com.hp.hpl.jena.sparql.pfunction.library.ListBase;
import com.hp.hpl.jena.sparql.util.graph.GNode;
import com.hp.hpl.jena.sparql.util.graph.GraphList;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;

public class listMember
extends ListBase {
    public listMember() {
        super(PropFuncArgType.PF_ARG_EITHER);
    }

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        if (argObject.isList() && argObject.getArgList().size() != 0) {
            throw new QueryBuildException("List arguments (object) to " + predicate.getURI());
        }
    }

    public QueryIterator execOneList(Binding binding, Node listNode, Node predicate, Node member, ExecutionContext execCxt) {
        if (Var.isVar(listNode)) {
            throw new ExprEvalException("List : subject not a list or variable bound to a list");
        }
        if (Var.isVar(member)) {
            return this.members(binding, listNode, Var.alloc(member), execCxt);
        }
        return this.verify(binding, listNode, member, execCxt);
    }

    private QueryIterator members(Binding binding, Node listNode, Var itemVar, ExecutionContext execCxt) {
        List<Node> members = GraphList.members(new GNode(execCxt.getActiveGraph(), listNode));
        return new QueryIterExtendByVar(binding, itemVar, members.iterator(), execCxt);
    }

    private QueryIterator verify(Binding binding, Node listNode, Node member, ExecutionContext execCxt) {
        int count = GraphList.occurs(new GNode(execCxt.getActiveGraph(), listNode), member);
        return new QueryIterYieldN(count, binding);
    }

    protected QueryIterator execOneList(Binding binding, Node listNode, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        Node objectNode = object.getArg();
        if (object.isList()) {
            objectNode = RDF.nil.asNode();
        }
        return this.execOneList(binding, listNode, predicate, objectNode, execCxt);
    }
}

