/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.control;

import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.StateVariable;
import com.fujitsu.fla.upnp.control.ControlRequest;
import com.fujitsu.fla.upnp.control.QueryResponse;
import com.fujitsu.fla.upnp.http.HTTPRequest;
import com.fujitsu.fla.upnp.soap.SOAP;
import com.fujitsu.fla.upnp.soap.SOAPResponse;
import com.fujitsu.fla.upnp.xml.Node;

public class QueryRequest
extends ControlRequest {
    public QueryRequest() {
    }

    public QueryRequest(HTTPRequest httpReq) {
        this.set(httpReq);
    }

    private Node getVarNameNode() {
        Node bodyNode = this.getBodyNode();
        if (bodyNode == null) {
            return null;
        }
        if (!bodyNode.hasNodes()) {
            return null;
        }
        Node queryStateVarNode = bodyNode.getNode(0);
        if (queryStateVarNode == null) {
            return null;
        }
        if (!queryStateVarNode.hasNodes()) {
            return null;
        }
        return queryStateVarNode.getNode(0);
    }

    public String getVarName() {
        Node node = this.getVarNameNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public void setRequest(StateVariable stateVar) {
        Service service = stateVar.getService();
        String ctrlURL = service.getControlURL();
        this.setRequestHost(service);
        this.setEnvelopeNode(SOAP.createEnvelopeBodyNode());
        Node envNode = this.getEnvelopeNode();
        Node bodyNode = this.getBodyNode();
        Node qeuryNode = this.createContentNode(stateVar);
        bodyNode.addNode(qeuryNode);
        this.setContent(envNode);
        this.setSOAPAction("urn:schemas-upnp-org:control-1-0#QueryStateVariable");
    }

    private Node createContentNode(StateVariable stateVar) {
        Node queryVarNode = new Node();
        queryVarNode.setName("u", "QueryStateVariable");
        queryVarNode.setNameSpace("u", "urn:schemas-upnp-org:control-1-0");
        Node varNode = new Node();
        varNode.setName("u", "varName");
        varNode.setValue(stateVar.getName());
        queryVarNode.addNode(varNode);
        return queryVarNode;
    }

    public QueryResponse post() {
        SOAPResponse soapRes = this.postMessage(this.getRequestHost(), this.getRequestPort());
        return new QueryResponse(soapRes);
    }
}

