/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.event;

import com.fujitsu.fla.upnp.event.Property;
import com.fujitsu.fla.upnp.event.PropertyList;
import com.fujitsu.fla.upnp.event.Subscriber;
import com.fujitsu.fla.upnp.event.Subscription;
import com.fujitsu.fla.upnp.http.HTTPRequest;
import com.fujitsu.fla.upnp.soap.SOAPRequest;
import com.fujitsu.fla.upnp.xml.Node;

public class NotifyRequest
extends SOAPRequest {
    private static final String XMLNS = "e";
    private static final String PROPERTY = "property";
    private static final String PROPERTYSET = "propertyset";

    public NotifyRequest() {
    }

    public NotifyRequest(HTTPRequest httpReq) {
        this.set(httpReq);
    }

    public void setNT(String value) {
        this.setHeader("NT", value);
    }

    public void setNTS(String value) {
        this.setHeader("NTS", value);
    }

    public void setSID(String id) {
        this.setHeader("SID", Subscription.toSIDHeaderString(id));
    }

    public String getSID() {
        return Subscription.getSID(this.getHeaderValue("SID"));
    }

    public void setSEQ(long value) {
        this.setHeader("SEQ", Long.toString(value));
    }

    public long getSEQ() {
        return this.getLongHeaderValue("SEQ");
    }

    public boolean setRequest(Subscriber sub, String varName, String value) {
        String callback = sub.getDeliveryURL();
        String sid = sub.getSID();
        long notifyCnt = sub.getNotifyCount();
        String host = sub.getDeliveryHost();
        String path = sub.getDeliveryPath();
        int port = sub.getDeliveryPort();
        this.setMethod("NOTIFY");
        this.setURI(path);
        this.setHost(host, port);
        this.setNT("upnp:event");
        this.setNTS("upnp:propchange");
        this.setSID(sid);
        this.setSEQ(notifyCnt);
        this.setContentType("text/xml; charset=\"utf-8\"");
        Node propSetNode = this.createPropertySetNode(varName, value);
        this.setContent(propSetNode);
        return true;
    }

    private Node createPropertySetNode(String varName, String value) {
        Node propSetNode = new Node(PROPERTYSET);
        propSetNode.setNameSpace(XMLNS, "urn:schemas-upnp-org:event-1-0");
        Node propNode = new Node(PROPERTY);
        propSetNode.addNode(propNode);
        Node varNameNode = new Node(varName);
        varNameNode.setValue(value);
        propNode.addNode(varNameNode);
        return propSetNode;
    }

    private Node getVariableNode() {
        Node rootNode = this.getEnvelopeNode();
        if (rootNode == null) {
            return null;
        }
        if (!rootNode.hasNodes()) {
            return null;
        }
        Node propNode = rootNode.getNode(0);
        if (!propNode.hasNodes()) {
            return null;
        }
        return propNode.getNode(0);
    }

    private Property getProperty(Node varNode) {
        Property prop = new Property();
        if (varNode == null) {
            return prop;
        }
        String variableName = varNode.getName();
        int index = variableName.lastIndexOf(58);
        if (index != -1) {
            variableName = variableName.substring(index + 1);
        }
        prop.setName(variableName);
        prop.setValue(varNode.getValue());
        return prop;
    }

    public PropertyList getPropertyList() {
        PropertyList properties = new PropertyList();
        Node varSetNode = this.getEnvelopeNode();
        int i = 0;
        while (i < varSetNode.getNNodes()) {
            Node propNode = varSetNode.getNode(i);
            if (propNode != null) {
                Property prop = this.getProperty(propNode.getNode(0));
                properties.add(prop);
            }
            ++i;
        }
        return properties;
    }
}

