/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.http;

import java.util.StringTokenizer;

public class HTTPStatus {
    public static final int CONTINUE = 100;
    public static final int OK = 200;
    public static final int PARTIAL_CONTENT = 206;
    public static final int BAD_REQUEST = 400;
    public static final int NOT_FOUND = 404;
    public static final int PRECONDITION_FAILED = 412;
    public static final int INVALID_RANGE = 416;
    public static final int INTERNAL_SERVER_ERROR = 500;
    private String version = "";
    private int statusCode = 0;
    private String reasonPhrase = "";

    public static final String code2String(int code) {
        switch (code) {
            case 100: {
                return "Continue";
            }
            case 200: {
                return "OK";
            }
            case 206: {
                return "Partial Content";
            }
            case 400: {
                return "Bad Request";
            }
            case 404: {
                return "Not Found";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 416: {
                return "Invalid Range";
            }
            case 500: {
                return "Internal Server Error";
            }
        }
        return "";
    }

    public HTTPStatus() {
        this.setVersion("");
        this.setStatusCode(0);
        this.setReasonPhrase("");
    }

    public HTTPStatus(String ver, int code, String reason) {
        this.setVersion(ver);
        this.setStatusCode(code);
        this.setReasonPhrase(reason);
    }

    public HTTPStatus(String lineStr) {
        this.set(lineStr);
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public void setStatusCode(int value) {
        this.statusCode = value;
    }

    public void setReasonPhrase(String value) {
        this.reasonPhrase = value;
    }

    public String getVersion() {
        return this.version;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public static final boolean isSuccessful(int statCode) {
        return 200 <= statCode && statCode < 300;
    }

    public boolean isSuccessful() {
        return HTTPStatus.isSuccessful(this.getStatusCode());
    }

    public void set(String lineStr) {
        if (lineStr == null) {
            this.setVersion("1.1");
            this.setStatusCode(500);
            this.setReasonPhrase(HTTPStatus.code2String(500));
            return;
        }
        try {
            StringTokenizer st = new StringTokenizer(lineStr, " ");
            if (!st.hasMoreTokens()) {
                return;
            }
            String ver = st.nextToken();
            this.setVersion(ver.trim());
            if (!st.hasMoreTokens()) {
                return;
            }
            String codeStr = st.nextToken();
            int code = 0;
            try {
                code = Integer.parseInt(codeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setStatusCode(code);
            String reason = "";
            while (st.hasMoreTokens()) {
                if (reason.length() >= 0) {
                    reason = String.valueOf(reason) + " ";
                }
                reason = String.valueOf(reason) + st.nextToken();
            }
            this.setReasonPhrase(reason.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

