/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.test;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.ArgumentList;
import com.fujitsu.fla.upnp.UPnPStatus;
import com.fujitsu.fla.upnp.test.ActionDialog;
import com.fujitsu.fla.upnp.test.ActionTable;
import com.fujitsu.fla.upnp.test.CtrlPoint;
import com.fujitsu.fla.upnp.test.TableComp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ActionPane
extends JPanel
implements ActionListener {
    private CtrlPoint ctrlPoint;
    private Action action;
    private ActionTable actionTable;
    private JButton actionButton;

    public ActionPane(CtrlPoint ctrlPoint, Action action) {
        this.setLayout(new BorderLayout());
        this.ctrlPoint = ctrlPoint;
        this.action = action;
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BorderLayout());
        this.actionTable = new ActionTable(action);
        tablePane.add((Component)new TableComp(this.actionTable), "Center");
        this.add((Component)tablePane, "Center");
        JPanel buttonPane = new JPanel();
        this.actionButton = new JButton("Action");
        buttonPane.add(this.actionButton);
        this.add((Component)buttonPane, "South");
        this.actionButton.addActionListener(this);
    }

    public Action getAction() {
        return this.action;
    }

    public ActionTable getTable() {
        return this.actionTable;
    }

    public JButton getButton() {
        return this.actionButton;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.actionButton) {
            return;
        }
        ArgumentList inArgList = this.action.getInputArgumentList();
        if (inArgList.size() > 0) {
            ActionDialog dlg = new ActionDialog((Frame)this.ctrlPoint.getFrame(), this.action);
            dlg.doModal();
        }
        String title = this.action.getName();
        String msg = "";
        boolean ctrlRes = this.action.postControlAction();
        if (ctrlRes) {
            ArgumentList outArgList = this.action.getOutputArgumentList();
            int nArgs = outArgList.size();
            if (nArgs == 0) {
                msg = "(No response value)";
            }
            int n = 0;
            while (n < nArgs) {
                Argument arg = outArgList.getArgument(n);
                String name = arg.getName();
                String value = arg.getValue();
                msg = String.valueOf(msg) + name + " = " + value;
                if (n < nArgs - 1) {
                    msg = String.valueOf(msg) + ", ";
                }
                ++n;
            }
        } else {
            UPnPStatus err = this.action.getControlStatus();
            msg = String.valueOf(err.getDescription()) + " (" + Integer.toString(err.getCode()) + ")";
        }
        this.ctrlPoint.printConsole(String.valueOf(title) + " : " + msg);
        JOptionPane.showMessageDialog(this, msg, title, -1);
    }
}

