/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation;

import com.clarkparsia.explanation.BlackBoxExplanation;
import com.clarkparsia.explanation.GlassBoxExplanation;
import com.clarkparsia.explanation.HSTExplanationGenerator;
import com.clarkparsia.explanation.SatisfiabilityConverter;
import com.clarkparsia.explanation.TransactionAwareSingleExpGen;
import java.util.Set;
import org.mindswap.pellet.owlapi.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSubClassAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletExplanation {
    private OWLDataFactory factory;
    private HSTExplanationGenerator expGen;
    private SatisfiabilityConverter converter;

    public static void setup() {
        GlassBoxExplanation.setup();
    }

    public PelletExplanation(OWLOntologyManager manager, Set<OWLOntology> ontologies) {
        this(manager, ontologies, null, true);
    }

    public PelletExplanation(OWLOntologyManager manager, Set<OWLOntology> ontologies, boolean useGlassBox) {
        this(manager, ontologies, null, useGlassBox);
    }

    private PelletExplanation(OWLOntologyManager manager, Set<OWLOntology> ontologies, Reasoner reasoner, boolean useGlassBox) {
        this.factory = manager.getOWLDataFactory();
        if (reasoner == null) {
            reasoner = new Reasoner(manager);
            reasoner.loadOntologies(ontologies);
        }
        GlassBoxExplanation singleExp = useGlassBox ? new GlassBoxExplanation(manager) : new BlackBoxExplanation(manager);
        this.expGen = new HSTExplanationGenerator((TransactionAwareSingleExpGen)singleExp);
        this.expGen.setReasonerFactory((OWLReasonerFactory)new PelletReasonerFactory());
        this.expGen.setReasoner((OWLClassReasoner)reasoner);
        this.expGen.setOntologies(ontologies);
        this.converter = new SatisfiabilityConverter(manager.getOWLDataFactory());
    }

    public PelletExplanation(Reasoner reasoner) {
        this(reasoner.getManager(), reasoner.getLoadedOntologies(), reasoner, true);
    }

    public PelletExplanation(Reasoner reasoner, boolean useGlassBox) {
        this(reasoner.getManager(), reasoner.getLoadedOntologies(), reasoner, useGlassBox);
    }

    public Set<OWLAxiom> getEntailmentExplanation(OWLAxiom axiom) {
        OWLDescription unsatClass = this.converter.convert(axiom);
        return this.getUnsatisfiableExplanation(unsatClass);
    }

    public Set<Set<OWLAxiom>> getEntailmentExplanations(OWLAxiom axiom) {
        OWLDescription unsatClass = this.converter.convert(axiom);
        return this.getUnsatisfiableExplanations(unsatClass);
    }

    public Set<Set<OWLAxiom>> getEntailmentExplanations(OWLAxiom axiom, int maxExplanations) {
        OWLDescription unsatClass = this.converter.convert(axiom);
        return this.getUnsatisfiableExplanations(unsatClass, maxExplanations);
    }

    public Set<OWLAxiom> getInconsistencyExplanation() {
        return this.getUnsatisfiableExplanation((OWLDescription)this.factory.getOWLThing());
    }

    public Set<Set<OWLAxiom>> getInconsistencyExplanations() {
        return this.getUnsatisfiableExplanations((OWLDescription)this.factory.getOWLThing());
    }

    public Set<Set<OWLAxiom>> getInconsistencyExplanations(int maxExplanations) {
        return this.getUnsatisfiableExplanations((OWLDescription)this.factory.getOWLThing(), maxExplanations);
    }

    public Set<OWLAxiom> getInstanceExplanation(OWLIndividual ind, OWLDescription cls) {
        OWLClassAssertionAxiom classAssertion = this.factory.getOWLClassAssertionAxiom(ind, cls);
        return this.getEntailmentExplanation((OWLAxiom)classAssertion);
    }

    public Set<Set<OWLAxiom>> getInstanceExplanations(OWLIndividual ind, OWLDescription cls) {
        OWLClassAssertionAxiom classAssertion = this.factory.getOWLClassAssertionAxiom(ind, cls);
        return this.getEntailmentExplanations((OWLAxiom)classAssertion);
    }

    public Set<Set<OWLAxiom>> getInstanceExplanations(OWLIndividual ind, OWLDescription cls, int maxExplanations) {
        OWLClassAssertionAxiom classAssertion = this.factory.getOWLClassAssertionAxiom(ind, cls);
        return this.getEntailmentExplanations((OWLAxiom)classAssertion, maxExplanations);
    }

    public Set<OWLAxiom> getSubClassExplanation(OWLDescription subClass, OWLDescription superClass) {
        OWLSubClassAxiom subClassAxiom = this.factory.getOWLSubClassAxiom(subClass, superClass);
        return this.getEntailmentExplanation((OWLAxiom)subClassAxiom);
    }

    public Set<Set<OWLAxiom>> getSubClassExplanations(OWLDescription subClass, OWLDescription superClass) {
        OWLSubClassAxiom subClassAxiom = this.factory.getOWLSubClassAxiom(subClass, superClass);
        return this.getEntailmentExplanations((OWLAxiom)subClassAxiom);
    }

    public Set<Set<OWLAxiom>> getSubClassExplanations(OWLDescription subClass, OWLDescription superClass, int maxExplanations) {
        OWLSubClassAxiom subClassAxiom = this.factory.getOWLSubClassAxiom(subClass, superClass);
        return this.getEntailmentExplanations((OWLAxiom)subClassAxiom, maxExplanations);
    }

    public Set<OWLAxiom> getUnsatisfiableExplanation(OWLDescription unsatClass) {
        return this.expGen.getExplanation(unsatClass);
    }

    public Set<Set<OWLAxiom>> getUnsatisfiableExplanations(OWLDescription unsatClass) {
        return this.expGen.getExplanations(unsatClass);
    }

    public Set<Set<OWLAxiom>> getUnsatisfiableExplanations(OWLDescription unsatClass, int maxExplanations) {
        return this.expGen.getExplanations(unsatClass, maxExplanations);
    }

    static {
        PelletExplanation.setup();
    }
}

