/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.blocking;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.blocking.Blocking;
import org.mindswap.pellet.utils.ATermUtils;

public class OptimizedDoubleBlocking
extends Blocking {
    public boolean isDirectlyBlocked(Individual w) {
        Individual v = w.getParent();
        if (v == null) {
            return false;
        }
        for (Individual w1 = v.getParent(); w1 != null; w1 = w1.getParent()) {
            boolean cBlock;
            boolean aBlock;
            boolean b1and2 = this.block1(w, w1) && this.block2(w, v, w1);
            boolean bl = aBlock = b1and2 && this.block3(w, v, w1) && this.block4(w, v, w1);
            if (aBlock) {
                return true;
            }
            boolean bl2 = cBlock = b1and2 && this.block5(w, v, w1) && this.block6(w, v);
            if (!cBlock) continue;
            return true;
        }
        return false;
    }

    private boolean block1(Individual w, Individual w1) {
        return this.subset(w, w1);
    }

    private boolean block2(Individual w, Individual v, Individual w1) {
        for (ATermAppl av : w1.getTypes(3)) {
            Role invS;
            Role s = w.getABox().getRole(av.getArgument(0));
            ATermAppl c = (ATermAppl)av.getArgument(1);
            if (s.isDatatypeRole() || !v.hasRSuccessor(invS = s.getInverse(), w)) continue;
            if (!v.hasType((ATerm)c)) {
                return false;
            }
            for (Role r : s.getSubRoles()) {
                Role invR;
                if (!r.isTransitive() || !v.hasRSuccessor(invR = r.getInverse(), w)) continue;
                boolean hasAllRC = false;
                Set<ATermAppl> eqs = v.getABox().getRBox().getObjectTaxonomy().getNode(r.getName()).getEquivalents();
                for (ATermAppl eqR : eqs) {
                    ATermAppl allRC = ATermUtils.makeAllValues((ATerm)eqR, (ATerm)c);
                    if (!v.hasType((ATerm)allRC)) continue;
                    hasAllRC = true;
                    break;
                }
                if (hasAllRC) continue;
                return false;
            }
        }
        return true;
    }

    private boolean block3(Individual w, Individual v, Individual w1) {
        for (ATermAppl normMax : w1.getTypes(5)) {
            Role invS;
            ATermAppl max = (ATermAppl)normMax.getArgument(0);
            Role s = w.getABox().getRole(max.getArgument(0));
            int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
            ATermAppl c = (ATermAppl)max.getArgument(2);
            if (s.isDatatypeRole() || !v.hasRSuccessor(invS = s.getInverse(), w) || !v.hasType((ATerm)c) || w1.getRSuccessors(s, c).size() < n) continue;
            return false;
        }
        return true;
    }

    private boolean block4(Individual w, Individual v, Individual w1) {
        Role invT;
        ATermAppl c;
        for (ATermAppl min : w1.getTypes(4)) {
            Role t = w.getABox().getRole(min.getArgument(0));
            int m = ((ATermInt)min.getArgument(1)).getInt();
            c = (ATermAppl)min.getArgument(2);
            if (t.isDatatypeRole()) continue;
            invT = t.getInverse();
            if (w1.getRSuccessors(t, c).size() < m || !v.hasRSuccessor(invT, w) || !v.hasType((ATerm)c)) continue;
            return false;
        }
        for (ATermAppl normSome : w1.getTypes(2)) {
            ATermAppl some = (ATermAppl)normSome.getArgument(0);
            Role t = w.getABox().getRole(some.getArgument(0));
            c = (ATermAppl)some.getArgument(1);
            c = ATermUtils.negate(c);
            if (t.isDatatypeRole()) continue;
            invT = t.getInverse();
            if (w1.getRSuccessors(t, c).size() < 1 || !v.hasRSuccessor(invT, w) || !v.hasType((ATerm)c)) continue;
            return false;
        }
        return true;
    }

    private boolean block5(Individual w, Individual v, Individual w1) {
        for (ATermAppl normMax : w1.getTypes(5)) {
            Role invT;
            ATermAppl max = (ATermAppl)normMax.getArgument(0);
            Role t = w.getABox().getRole(max.getArgument(0));
            ATermAppl c = (ATermAppl)max.getArgument(2);
            if (t.isDatatypeRole() || !v.hasRSuccessor(invT = t.getInverse(), w) || !v.hasType((ATerm)c)) continue;
            return false;
        }
        return true;
    }

    private boolean block6(Individual w, Individual v) {
        for (ATermAppl min : v.getTypes(4)) {
            Role u = w.getABox().getRole(min.getArgument(0));
            ATermAppl c = (ATermAppl)min.getArgument(2);
            if (u.isDatatypeRole() || !v.hasRSuccessor(u, w) || !w.hasType((ATerm)c)) continue;
            return false;
        }
        for (ATermAppl normSome : v.getTypes(2)) {
            ATermAppl some = (ATermAppl)normSome.getArgument(0);
            Role u = w.getABox().getRole(some.getArgument(0));
            ATermAppl c = (ATermAppl)some.getArgument(1);
            c = ATermUtils.negate(c);
            if (u.isDatatypeRole() || !v.hasRSuccessor(u, w) || !w.hasType((ATerm)c)) continue;
            return false;
        }
        return true;
    }
}

