/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.LiteralIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.blocking.Blocking;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.ChooseBranch;
import org.mindswap.pellet.tableau.branch.DisjunctionBranch;
import org.mindswap.pellet.tableau.branch.GuessBranch;
import org.mindswap.pellet.tableau.branch.LiteralValueBranch;
import org.mindswap.pellet.tableau.branch.MaxBranch;
import org.mindswap.pellet.tableau.completion.queue.CompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompletionStrategy {
    public static final Logger log = Logger.getLogger(CompletionStrategy.class.getName());
    protected ABox abox;
    protected TBox tbox;
    protected Blocking blocking;
    protected Timers timers;
    protected Timer completionTimer;
    private boolean merging = false;
    private boolean mergingAll = false;
    protected List<NodeMerge> mergeList;

    public CompletionStrategy(ABox abox, Blocking blocking) {
        this.abox = abox;
        this.tbox = abox.getTBox();
        this.blocking = blocking;
        this.timers = abox.getKB().timers;
        this.completionTimer = this.timers.getTimer("complete");
    }

    public Iterator<Individual> getInitializeIterator() {
        return new IndividualIterator(this.abox);
    }

    public void initialize() {
        Individual n;
        Iterator<Individual> i;
        this.mergeList = new ArrayList<NodeMerge>();
        for (Branch branch : this.abox.getBranches()) {
            branch.setStrategy(this);
        }
        if (this.abox.isInitialized()) {
            i = this.getInitializeIterator();
            block1: while (i.hasNext()) {
                n = i.next();
                if (n.isMerged()) continue;
                if (n.isConceptRoot()) {
                    this.applyUniversalRestrictions(n);
                }
                this.applyAllValues(n);
                if (n.isMerged()) continue;
                this.applyNominalRule(n);
                if (n.isMerged()) continue;
                this.applySelfRule(n);
                EdgeList allEdges = n.getOutEdges();
                for (int e = 0; e < allEdges.size(); ++e) {
                    Edge edge = allEdges.edgeAt(e);
                    if (edge.getTo().isPruned()) continue;
                    this.applyPropertyRestrictions(edge);
                    if (n.isMerged()) continue block1;
                }
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize started");
        }
        this.abox.setBranch(0);
        this.mergeList.addAll(this.abox.getToBeMerged());
        if (!this.mergeList.isEmpty()) {
            this.mergeAll();
        }
        i = this.getInitializeIterator();
        while (i.hasNext()) {
            n = i.next();
            if (n.isMerged()) continue;
            this.applyUniversalRestrictions(n);
            this.applyUnfoldingRule(n);
            this.applySelfRule(n);
            EdgeList allEdges = n.getOutEdges();
            for (int e = 0; e < allEdges.size(); ++e) {
                Edge edge = allEdges.edgeAt(e);
                if (edge.getTo().isPruned()) continue;
                this.applyPropertyRestrictions(edge);
                if (n.isMerged()) break;
            }
            DefaultEdge topReflexive = new DefaultEdge(this.abox.getRole((ATerm)ATermUtils.TOP_OBJECT_PROPERTY), n, n, DependencySet.INDEPENDENT);
            this.applyPropertyRestrictions(topReflexive);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Merging: " + this.mergeList);
        }
        if (!this.mergeList.isEmpty()) {
            this.mergeAll();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize finished");
        }
        this.abox.setBranch(this.abox.getBranches().size() + 1);
        this.abox.treeDepth = 1;
        this.abox.setChanged(true);
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    public abstract void complete(Expressivity var1);

    public Individual createFreshIndividual(Individual parent, DependencySet ds) {
        Individual ind = this.abox.addFreshIndividual(parent, ds);
        this.applyUniversalRestrictions(ind);
        return ind;
    }

    void applyUniversalRestrictions(Individual node) {
        this.addType(node, ATermUtils.TOP, DependencySet.INDEPENDENT);
        List<Pair<ATermAppl, DependencySet>> UC = this.tbox.getUC();
        if (!UC.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder();
                for (Pair<ATermAppl, DependencySet> pair : UC) {
                    sb.append(ATermUtils.toString((ATermAppl)pair.first)).append(", ");
                }
                log.fine("UC  : " + node + " " + sb);
            }
            for (Pair<ATermAppl, DependencySet> pair : UC) {
                ATermAppl c = (ATermAppl)pair.first;
                DependencySet ds = (DependencySet)pair.second;
                this.addType(node, c, ds);
            }
        }
        Set<Role> reflexives = this.abox.getKB().getRBox().getReflexiveRoles();
        for (Role r : reflexives) {
            if (log.isLoggable(Level.FINE) && !node.hasRNeighbor(r, node)) {
                log.fine("REF : " + node + " " + r);
            }
            this.addEdge(node, r, node, r.getExplainReflexive());
        }
        Role topObjProp = this.abox.getKB().getRole((ATerm)ATermUtils.TOP_OBJECT_PROPERTY);
        for (ATermAppl domain : topObjProp.getDomains()) {
            this.addType(node, domain, topObjProp.getExplainDomain(domain));
        }
        for (ATermAppl range : topObjProp.getRanges()) {
            this.addType(node, range, topObjProp.getExplainRange(range));
        }
    }

    public void addType(Node node, ATermAppl c, DependencySet ds) {
        if (this.abox.isClosed()) {
            return;
        }
        node.addType(c, ds);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addTypeDependency(node.getName(), c, ds);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("ADD: " + node + " " + c + " - " + ds + " " + ds.getExplain());
        }
        if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                this.addType(node, conj, ds);
                node = node.getSame();
                cs = cs.getNext();
            }
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this.applyAllValues((Individual)node, c, ds);
        } else if (c.getAFun().equals(ATermUtils.SELFFUN)) {
            ATermAppl pred = (ATermAppl)c.getArgument(0);
            Role role = this.abox.getRole((ATerm)pred);
            if (log.isLoggable(Level.FINE) && !((Individual)node).hasRSuccessor(role, node)) {
                log.fine("SELF: " + node + " " + role + " " + node.getDepends((ATerm)c));
            }
            this.addEdge((Individual)node, role, node, ds);
        }
    }

    protected void updateQueueAddEdge(Individual subj, Role pred, Node obj) {
        Role r;
        ATermAppl max;
        ATermAppl c;
        int j;
        List<ATermAppl> types = subj.getTypes(5);
        int size = types.size();
        for (j = 0; j < size; ++j) {
            c = types.get(j);
            max = (ATermAppl)c.getArgument(0);
            r = this.abox.getRole(max.getArgument(0));
            if (!pred.isSubRoleOf(r)) continue;
            QueueElement newElement = new QueueElement(subj, c);
            this.abox.getCompletionQueue().add(newElement, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add(newElement, NodeSelector.CHOOSE);
        }
        if (obj instanceof Individual) {
            types = ((Individual)obj).getTypes(5);
            size = types.size();
            for (j = 0; j < size; ++j) {
                c = types.get(j);
                max = (ATermAppl)c.getArgument(0);
                r = this.abox.getRole(max.getArgument(0));
                Role invR = pred.getInverse();
                if (invR == null || !invR.isSubRoleOf(r)) continue;
                QueueElement newElement = new QueueElement(obj, c);
                this.abox.getCompletionQueue().add(newElement, NodeSelector.MAX_NUMBER);
                this.abox.getCompletionQueue().add(newElement, NodeSelector.CHOOSE);
            }
        }
    }

    public void addEdge(Individual subj, Role pred, Node obj, DependencySet ds) {
        Edge edge = subj.addEdge(pred, obj, ds);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addEdgeDependency(edge, ds);
        }
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), subj.getName());
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), obj.getName());
        }
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.updateQueueAddEdge(subj, pred, obj);
        }
        if (edge != null) {
            Individual o;
            int max;
            if (subj.isBlockable() && obj.isNominal() && !obj.isLiteral() && (max = (o = (Individual)obj).getMaxCard(pred.getInverse())) != Integer.MAX_VALUE && !o.hasDistinctRNeighborsForMin(pred.getInverse(), max, ATermUtils.TOP, true)) {
                int guessMin = o.getMinCard(pred.getInverse());
                if (guessMin == 0) {
                    guessMin = 1;
                }
                if (guessMin > max) {
                    return;
                }
                GuessBranch newBranch = new GuessBranch(this.abox, this, o, pred.getInverse(), guessMin, max, ds);
                this.addBranch(newBranch);
                if (!newBranch.tryNext()) {
                    return;
                }
                if (this.abox.isClosed()) {
                    return;
                }
                if (subj.isMerged()) {
                    return;
                }
            }
            this.applyPropertyRestrictions(edge);
        }
    }

    void applyPropertyRestrictions(Edge edge) {
        Individual subj = edge.getFrom();
        Role pred = edge.getRole();
        Node obj = edge.getTo();
        DependencySet ds = edge.getDepends();
        this.applyDomainRange(subj, pred, obj, ds);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        this.applyFunctionality(subj, pred, obj);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        this.applyDisjointness(subj, pred, obj, ds);
        this.applyAllValues(subj, pred, obj, ds);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        if (pred.isObjectRole()) {
            Individual o = (Individual)obj;
            this.applyAllValues(o, pred.getInverse(), subj, ds);
            this.checkReflexivitySymmetry(subj, pred, o, ds);
            this.checkReflexivitySymmetry(o, pred.getInverse(), subj, ds);
            this.applyDisjointness(o, pred.getInverse(), subj, ds);
        }
    }

    void applyDomainRange(Individual subj, Role pred, Node obj, DependencySet ds) {
        Set<ATermAppl> domains = pred.getDomains();
        Set<ATermAppl> ranges = pred.getRanges();
        for (ATermAppl domain : domains) {
            if (log.isLoggable(Level.FINE) && !subj.hasType((ATerm)domain)) {
                log.fine("DOM : " + obj + " <- " + pred + " <- " + subj + " : " + ATermUtils.toString(domain));
            }
            this.addType(subj, domain, ds.union(pred.getExplainDomain(domain), this.abox.doExplanation()));
        }
        for (ATermAppl range : ranges) {
            if (log.isLoggable(Level.FINE) && !obj.hasType((ATerm)range)) {
                log.fine("RAN : " + subj + " -> " + pred + " -> " + obj + " : " + ATermUtils.toString(range));
            }
            this.addType(obj, range, ds.union(pred.getExplainRange(range), this.abox.doExplanation()));
        }
    }

    void applyFunctionality(Individual subj, Role pred, Node obj) {
        DependencySet maxCardDS;
        DependencySet dependencySet = maxCardDS = pred.isFunctional() ? pred.getExplainFunctional() : subj.hasMax1(pred);
        if (maxCardDS != null) {
            this.applyFunctionalMaxRule(subj, pred, ATermUtils.getTop(pred), maxCardDS);
        }
        if (pred.isDatatypeRole() && pred.isInverseFunctional()) {
            this.applyFunctionalMaxRule((Literal)obj, pred, DependencySet.INDEPENDENT);
        } else if (pred.isObjectRole()) {
            Individual val = (Individual)obj;
            Role invR = pred.getInverse();
            DependencySet dependencySet2 = maxCardDS = invR.isFunctional() ? invR.getExplainFunctional() : val.hasMax1(invR);
            if (maxCardDS != null) {
                this.applyFunctionalMaxRule(val, invR, ATermUtils.TOP, maxCardDS);
            }
        }
    }

    void applyDisjointness(Individual subj, Role pred, Node obj, DependencySet ds) {
        Set<Role> disjoints = pred.getDisjointRoles();
        if (disjoints.isEmpty()) {
            return;
        }
        EdgeList edges = subj.getEdgesTo(obj);
        int n = edges.size();
        for (int i = 0; i < n; ++i) {
            Edge otherEdge = edges.edgeAt(i);
            if (!disjoints.contains(otherEdge.getRole())) continue;
            ds = ds.union(otherEdge.getDepends(), this.abox.doExplanation());
            ds = ds.union(pred.getExplainDisjointRole(otherEdge.getRole()), this.abox.doExplanation());
            this.abox.setClash(Clash.disjointProps(subj, ds, pred.getName(), otherEdge.getRole().getName()));
            return;
        }
    }

    void checkReflexivitySymmetry(Individual subj, Role pred, Individual obj, DependencySet ds) {
        if (pred.isAsymmetric() && obj.hasRSuccessor(pred, subj)) {
            EdgeList edges = obj.getEdgesTo(subj, pred);
            ds = ds.union(edges.edgeAt(0).getDepends(), this.abox.doExplanation());
            if (PelletOptions.USE_TRACING) {
                ds = ds.union(pred.getExplainAsymmetric(), this.abox.doExplanation());
            }
            this.abox.setClash(Clash.unexplained(subj, ds, "Antisymmetric property " + pred));
        } else if (subj.equals(obj)) {
            if (pred.isIrreflexive()) {
                this.abox.setClash(Clash.unexplained(subj, ds.union(pred.getExplainIrreflexive(), this.abox.doExplanation()), "Irreflexive property " + pred));
            } else {
                ATermAppl notSelfP = ATermUtils.makeNot((ATerm)ATermUtils.makeSelf(pred.getName()));
                if (subj.hasType((ATerm)notSelfP)) {
                    this.abox.setClash(Clash.unexplained(subj, ds.union(subj.getDepends((ATerm)notSelfP), this.abox.doExplanation()), "Local irreflexive property " + pred));
                }
            }
        }
    }

    void applyAllValues(Individual subj, Role pred, Node obj, DependencySet ds) {
        List<ATermAppl> allValues = subj.getTypes(3);
        int allValuesSize = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            DependencySet finalDS;
            ATermAppl av = i.next();
            ATerm p = av.getArgument(0);
            ATermAppl c = (ATermAppl)av.getArgument(1);
            ATermList roleChain = ATermUtils.EMPTY_LIST;
            Role s = null;
            if (p.getType() == 4) {
                roleChain = (ATermList)p;
                s = this.abox.getRole(roleChain.getFirst());
                roleChain = roleChain.getNext();
            } else {
                s = this.abox.getRole(p);
            }
            if (s.isTop() && s.isObjectRole()) {
                this.applyAllValuesTop(av, c, ds);
                if (!this.abox.isClosed()) continue;
                return;
            }
            if (pred.isSubRoleOf(s)) {
                finalDS = subj.getDepends((ATerm)av);
                finalDS = finalDS.union(ds, this.abox.doExplanation());
                finalDS = finalDS.union(s.getExplainSubOrInv(pred), this.abox.doExplanation());
                if (roleChain.isEmpty()) {
                    this.applyAllValues(subj, s, obj, c, finalDS);
                } else {
                    ATermAppl allRC = ATermUtils.makeAllValues((ATerm)roleChain, (ATerm)c);
                    this.applyAllValues(subj, allRC, finalDS);
                }
                if (this.abox.isClosed()) {
                    return;
                }
            }
            if (!s.isSimple()) {
                finalDS = subj.getDepends((ATerm)av).union(ds, this.abox.doExplanation());
                Set<ATermList> subRoleChains = s.getSubRoleChains();
                for (ATermList chain : subRoleChains) {
                    Role firstRole = this.abox.getRole(chain.getFirst());
                    if (!pred.isSubRoleOf(firstRole)) continue;
                    ATermAppl allRC = ATermUtils.makeAllValues((ATerm)chain.getNext(), (ATerm)c);
                    this.applyAllValues(subj, pred, obj, allRC, finalDS.union(firstRole.getExplainSub((ATerm)pred.getName()), this.abox.doExplanation()).union(s.getExplainSub((ATerm)chain), this.abox.doExplanation()));
                    if (!subj.isMerged() && !this.abox.isClosed()) continue;
                    return;
                }
            }
            if (subj.isMerged()) {
                return;
            }
            obj = obj.getSame();
            if (allValuesSize == allValues.size()) continue;
            i = allValues.iterator();
            allValuesSize = allValues.size();
        }
    }

    protected void applyUnfoldingRule(IndividualIterator i) {
        i.reset(NodeSelector.ATOM);
        while (i.hasNext()) {
            Individual node = i.next();
            this.applyUnfoldingRule(node);
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected final void applySelfRule(Individual node) {
        List<ATermAppl> types = node.getTypes(0);
        int size = types.size();
        for (int j = 0; j < size; ++j) {
            ATermAppl c = types.get(j);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && node.getDepends((ATerm)c) == null || !ATermUtils.isSelf(c)) continue;
            ATermAppl pred = (ATermAppl)c.getArgument(0);
            Role role = this.abox.getRole((ATerm)pred);
            if (log.isLoggable(Level.FINE) && !node.hasRSuccessor(role, node)) {
                log.fine("SELF: " + node + " " + role + " " + node.getDepends((ATerm)c));
            }
            this.addEdge(node, role, node, node.getDepends((ATerm)c));
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected final void applyUnfoldingRule(Individual node) {
        if (!node.canApply(0)) {
            return;
        }
        if (this.blocking.isBlocked(node)) {
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().add(new QueueElement(node), NodeSelector.ATOM);
            }
            return;
        }
        List<ATermAppl> types = node.getTypes(0);
        int size = types.size();
        for (int j = node.applyNext[0]; j < size; ++j) {
            ATermAppl c = types.get(j);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && node.getDepends((ATerm)c) == null) continue;
            this.applyUnfoldingRule(node, c);
            if (this.abox.isClosed()) {
                return;
            }
            size = types.size();
        }
        node.applyNext[0] = size;
    }

    protected void applyUnfoldingRule(Individual node, ATermAppl c) {
        List<Pair<ATermAppl, Set<ATermAppl>>> unfoldingList = this.tbox.unfold(c);
        if (unfoldingList != null) {
            DependencySet ds = node.getDepends((ATerm)c);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
                return;
            }
            for (Pair<ATermAppl, Set<ATermAppl>> pair : unfoldingList) {
                ATermAppl unfoldedConcept = (ATermAppl)pair.first;
                Set unfoldingDS = (Set)pair.second;
                DependencySet finalDS = ds.union(unfoldingDS, this.abox.doExplanation());
                if (log.isLoggable(Level.FINE) && !node.hasType((ATerm)unfoldedConcept)) {
                    log.fine("UNF : " + node + ", " + ATermUtils.toString(c) + " -> " + ATermUtils.toString(unfoldedConcept) + " - " + finalDS);
                }
                this.addType(node, unfoldedConcept, finalDS);
            }
        }
    }

    protected void applyFunctionalMaxRule(Individual x, Role s, ATermAppl c, DependencySet ds) {
        Set<Role> functionalSupers = s.getFunctionalSupers();
        if (functionalSupers.isEmpty()) {
            functionalSupers = SetUtils.singleton(s);
        }
        block0: for (Role r : functionalSupers) {
            Edge edge;
            int edgeIndex;
            Set<Node> neighbors;
            EdgeList edges;
            if (PelletOptions.USE_TRACING) {
                ds = ds.union(s.getExplainSuper((ATerm)r.getName()), this.abox.doExplanation()).union(r.getExplainFunctional(), this.abox.doExplanation());
            }
            if ((edges = x.getRNeighborEdges(r)).size() <= 1 || (neighbors = edges.getFilteredNeighbors(x, c)).size() <= 1) continue;
            Node head = null;
            int edgeCount = edges.size();
            for (edgeIndex = 0; edgeIndex < edgeCount; ++edgeIndex) {
                edge = edges.edgeAt(edgeIndex);
                head = edge.getNeighbor(x);
                if (head.isPruned() || !neighbors.contains(head)) continue;
                ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                ds = ds.union(head.getDepends((ATerm)c), this.abox.doExplanation());
                ds = ds.union(r.getExplainSubOrInv(edge.getRole()), this.abox.doExplanation());
                break;
            }
            ++edgeIndex;
            while (edgeIndex < edgeCount) {
                edge = edges.edgeAt(edgeIndex);
                Node next = edge.getNeighbor(x);
                if (!next.isPruned() && neighbors.contains(next) && !head.isSame(next)) {
                    ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                    ds = ds.union(next.getDepends((ATerm)c), this.abox.doExplanation());
                    ds = ds.union(s.getExplainSubOrInv(edge.getRole()), this.abox.doExplanation());
                    if (next.isDifferent(head)) {
                        ds = ds.union(head.getDepends((ATerm)c), this.abox.doExplanation());
                        ds = ds.union(next.getDepends((ATerm)c), this.abox.doExplanation());
                        ds = ds.union(next.getDifferenceDependency(head), this.abox.doExplanation());
                        if (r.isFunctional()) {
                            this.abox.setClash(Clash.functionalCardinality(x, ds, r.getName()));
                            continue block0;
                        }
                        this.abox.setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                        continue block0;
                    }
                    if (x.isNominal() && head.isBlockable() && next.isBlockable() && head.hasSuccessor(x) && next.hasSuccessor(x)) {
                        Individual newNominal = this.createFreshIndividual(null, ds);
                        this.addEdge(x, r, newNominal, ds);
                        continue block0;
                    }
                    if (next.getNominalLevel() < head.getNominalLevel() || !head.isNominal() && next.hasSuccessor(x)) {
                        Node temp = head;
                        head = next;
                        next = temp;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("FUNC: " + x + " for prop " + r + " merge " + next + " -> " + head + " " + ds);
                    }
                    this.mergeTo(next, head, ds);
                    if (this.abox.isClosed()) {
                        return;
                    }
                    if (head.isPruned()) {
                        ds = ds.union(head.getMergeDependency(true), this.abox.doExplanation());
                        head = head.getSame();
                    }
                }
                ++edgeIndex;
            }
        }
    }

    protected void applyFunctionalMaxRule(Literal x, Role r, DependencySet ds) {
        Edge edge;
        EdgeList edges = x.getInEdges().getEdges(r);
        if (edges.size() <= 1) {
            return;
        }
        Set<Node> neighbors = edges.getNeighbors(x);
        if (neighbors.size() <= 1) {
            return;
        }
        Individual head = null;
        DependencySet headDS = null;
        for (int edgeIndex = 0; edgeIndex < edges.size(); ++edgeIndex) {
            edge = edges.edgeAt(edgeIndex);
            Individual ind = edge.getFrom();
            if (!ind.isNominal() || head != null && ind.getNominalLevel() >= head.getNominalLevel()) continue;
            head = ind;
            headDS = edge.getDepends();
        }
        if (head == null) {
            head = this.abox.addFreshIndividual(null, ds);
        } else {
            ds = ds.union(headDS, this.abox.doExplanation());
        }
        for (int i = 0; i < edges.size(); ++i) {
            edge = edges.edgeAt(i);
            Individual next = edge.getFrom();
            if (next.isPruned() || head.isSame(next)) continue;
            ds = ds.union(edge.getDepends(), this.abox.doExplanation());
            if (next.isDifferent(head)) {
                ds = ds.union(next.getDifferenceDependency(head), this.abox.doExplanation());
                if (r.isFunctional()) {
                    this.abox.setClash(Clash.functionalCardinality(x, ds, r.getName()));
                    break;
                }
                this.abox.setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                break;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("FUNC: " + x + " for prop " + r + " merge " + next + " -> " + head + " " + ds);
            }
            this.mergeTo(next, head, ds);
            if (this.abox.isClosed()) {
                return;
            }
            if (!head.isPruned()) continue;
            ds = ds.union(head.getMergeDependency(true), this.abox.doExplanation());
            head = head.getSame();
        }
    }

    void applyAllValuesTop(ATermAppl allTopC, ATermAppl c, DependencySet ds) {
        for (Node node : this.abox.getNodes()) {
            if (!node.isIndividual() || node.isPruned() || node.hasType((ATerm)c)) continue;
            node.addType(c, ds);
            node.addType(allTopC, ds);
            if (!this.abox.isClosed()) continue;
            break;
        }
    }

    void applyAllValues(IndividualIterator it) {
        it.reset(NodeSelector.UNIVERSAL);
        while (it.hasNext()) {
            Individual x = it.next();
            if (x.isPruned() || x.isMerged()) {
                x = x.getSame();
            }
            if (x.isPruned()) {
                return;
            }
            this.applyAllValues(x);
        }
    }

    void applyAllValues(Individual x) {
        List<ATermAppl> allValues = x.getTypes(3);
        int size = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = i.next();
            DependencySet avDepends = x.getDepends((ATerm)av);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && avDepends == null) continue;
            this.applyAllValues(x, av, avDepends);
            if (x.isMerged() || this.abox.isClosed()) {
                return;
            }
            if (size == allValues.size()) continue;
            i = allValues.iterator();
            size = allValues.size();
        }
    }

    void applyAllValues(Individual x, ATermAppl av, DependencySet ds) {
        if (av.getArity() == 0) {
            throw new InternalReasonerException();
        }
        ATerm p = av.getArgument(0);
        ATermAppl c = (ATermAppl)av.getArgument(1);
        ATermList roleChain = ATermUtils.EMPTY_LIST;
        Role s = null;
        if (p.getType() == 4) {
            roleChain = (ATermList)p;
            s = this.abox.getRole(roleChain.getFirst());
            roleChain = roleChain.getNext();
        } else {
            s = this.abox.getRole(p);
        }
        if (s.isTop() && s.isObjectRole()) {
            this.applyAllValuesTop(av, c, ds);
            return;
        }
        EdgeList edges = x.getRNeighborEdges(s);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edgeToY = edges.edgeAt(e);
            Node y = edgeToY.getNeighbor(x);
            DependencySet finalDS = ds.union(edgeToY.getDepends(), this.abox.doExplanation());
            if (roleChain.isEmpty()) {
                this.applyAllValues(x, s, y, c, finalDS);
            } else {
                ATermAppl allRC = ATermUtils.makeAllValues((ATerm)roleChain, (ATerm)c);
                this.applyAllValues((Individual)y, allRC, finalDS);
            }
            if (!x.isMerged() && !this.abox.isClosed()) continue;
            return;
        }
        if (!s.isSimple()) {
            Set<ATermList> subRoleChains = s.getSubRoleChains();
            for (ATermList chain : subRoleChains) {
                DependencySet subChainDS = s.getExplainSub((ATerm)chain);
                Role r = this.abox.getRole(chain.getFirst());
                edges = x.getRNeighborEdges(r);
                if (edges.isEmpty()) continue;
                ATermAppl allRC = ATermUtils.makeAllValues((ATerm)chain.getNext(), (ATerm)c);
                for (int e = 0; e < edges.size(); ++e) {
                    Edge edgeToY = edges.edgeAt(e);
                    Node y = edgeToY.getNeighbor(x);
                    DependencySet finalDS = ds.union(edgeToY.getDepends(), this.abox.doExplanation()).union(subChainDS, this.abox.doExplanation());
                    this.applyAllValues(x, r, y, allRC, finalDS);
                    if (!x.isMerged() && !this.abox.isClosed()) continue;
                    return;
                }
            }
        }
    }

    protected void applyAllValues(Individual subj, Role pred, Node obj, ATermAppl c, DependencySet ds) {
        if (!obj.hasType((ATerm)c)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("ALL : " + subj + " -> " + pred + " -> " + obj + " : " + ATermUtils.toString(c) + " - " + ds);
            }
            if (PelletOptions.USE_COMPLETION_QUEUE && !PelletOptions.MAINTAIN_COMPLETION_QUEUE && obj.isPruned()) {
                return;
            }
            this.addType(obj, c, ds);
        }
    }

    protected void applySomeValuesRule(IndividualIterator i) {
        i.reset(NodeSelector.EXISTENTIAL);
        while (i.hasNext()) {
            Individual x = i.next();
            this.applySomeValuesRule(x);
            if (!this.abox.isClosed() && !x.isMerged()) continue;
            return;
        }
    }

    protected void applySomeValuesRule(Individual x) {
        if (!x.canApply(2)) {
            return;
        }
        if (this.blocking.isBlocked(x)) {
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().add(new QueueElement(x), NodeSelector.EXISTENTIAL);
            }
            return;
        }
        List<ATermAppl> types = x.getTypes(2);
        int size = types.size();
        for (int j = x.applyNext[2]; j < size; ++j) {
            ATermAppl sv = types.get(j);
            this.applySomeValuesRule(x, sv);
            if (!this.abox.isClosed() && !x.isPruned()) continue;
            return;
        }
        x.applyNext[2] = size;
    }

    protected void applySomeValuesRule(Individual x, ATermAppl sv) {
        ATermAppl a = (ATermAppl)sv.getArgument(0);
        ATermAppl s = (ATermAppl)a.getArgument(0);
        ATermAppl c = (ATermAppl)a.getArgument(1);
        DependencySet ds = x.getDepends((ATerm)sv);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        c = ATermUtils.negate(c);
        if (s.equals(ATermUtils.TOP_OBJECT_PROPERTY)) {
            if (ATermUtils.isNominal(c)) {
                return;
            }
            for (Node node : this.abox.getNodes()) {
                if (!node.isIndividual() || node.isPruned() || !node.hasType((ATerm)c)) continue;
                return;
            }
            Individual y = this.createFreshIndividual(x, ds);
            this.addType(y, c, ds);
            return;
        }
        Role role = this.abox.getRole((ATerm)s);
        boolean neighborFound = false;
        boolean neighborSafe = x.isBlockable();
        Node y = null;
        Edge edge2 = null;
        EdgeList edges = x.getRNeighborEdges(role);
        for (Edge edge2 : edges) {
            y = edge2.getNeighbor(x);
            if (PelletOptions.USE_COMPLETION_QUEUE && y.isPruned()) {
                y = null;
                continue;
            }
            if (!y.hasType((ATerm)c) || !(neighborFound = neighborSafe || y.isLiteral() || !this.blocking.isBlocked((Individual)y))) continue;
        }
        if (neighborFound) {
            return;
        }
        if (role.isDatatypeRole()) {
            Literal literal = (Literal)y;
            if (ATermUtils.isNominal(c) && !PelletOptions.USE_PSEUDO_NOMINALS) {
                this.abox.copyOnWrite();
                literal = this.abox.addLiteral((ATermAppl)c.getArgument(0));
            } else {
                if (!role.isFunctional() || literal == null) {
                    literal = this.abox.addLiteral(ds);
                } else {
                    ds = ds.union(role.getExplainFunctional(), this.abox.doExplanation());
                    ds = ds.union(edge2.getDepends(), this.abox.doExplanation());
                }
                literal.addType(c, ds);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("SOME: " + x + " -> " + s + " -> " + literal + " : " + ATermUtils.toString(c) + " - " + ds);
            }
            this.addEdge(x, role, literal, ds);
        } else if (ATermUtils.isNominal(c) && !PelletOptions.USE_PSEUDO_NOMINALS) {
            this.abox.copyOnWrite();
            ATermAppl value = (ATermAppl)c.getArgument(0);
            y = this.abox.getIndividual((ATerm)value);
            if (log.isLoggable(Level.FINE)) {
                log.fine("VAL : " + x + " -> " + s + " -> " + y + " - " + ds);
            }
            if (y == null) {
                if (ATermUtils.isAnonNominal(value)) {
                    y = this.abox.addIndividual(value, ds);
                } else {
                    if (ATermUtils.isLiteral(value)) {
                        throw new InternalReasonerException("Object Property " + role + " is used with a hasValue restriction " + "where the value is a literal: " + ATermUtils.toString(value));
                    }
                    throw new InternalReasonerException("Nominal " + c + " is not found in the KB!");
                }
            }
            if (y.isMerged()) {
                ds = ds.union(y.getMergeDependency(true), this.abox.doExplanation());
                y = y.getSame();
            }
            this.addEdge(x, role, y, ds);
        } else {
            DependencySet maxCardDS;
            boolean useExistingNode = false;
            boolean useExistingRole = false;
            DependencySet dependencySet = maxCardDS = role.isFunctional() ? role.getExplainFunctional() : x.hasMax1(role);
            if (maxCardDS != null) {
                ds = ds.union(maxCardDS, this.abox.doExplanation());
                if (edge2 != null) {
                    useExistingNode = true;
                    useExistingRole = true;
                } else {
                    Set<Role> fs = role.isFunctional() ? role.getFunctionalSupers() : role.getSubRoles();
                    for (Role f : fs) {
                        edges = x.getRNeighborEdges(f);
                        if (edges.isEmpty()) continue;
                        if (useExistingNode) {
                            DependencySet fds = DependencySet.INDEPENDENT;
                            if (PelletOptions.USE_TRACING) {
                                fds = role.isFunctional() ? role.getExplainSuper((ATerm)f.getName()) : role.getExplainSub((ATerm)f.getName());
                            }
                            Edge otherEdge = edges.edgeAt(0);
                            Node otherNode = otherEdge.getNeighbor(x);
                            DependencySet d = ds.union(edge2.getDepends(), this.abox.doExplanation()).union(otherEdge.getDepends(), this.abox.doExplanation()).union(fds, this.abox.doExplanation());
                            this.mergeTo(y, otherNode, d);
                            continue;
                        }
                        useExistingNode = true;
                        edge2 = edges.edgeAt(0);
                        y = edge2.getNeighbor(x);
                    }
                    if (y != null) {
                        y = y.getSame();
                    }
                }
            }
            if (useExistingNode) {
                ds = ds.union(edge2.getDepends(), this.abox.doExplanation());
            } else {
                y = this.createFreshIndividual(x, ds);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("SOME: " + x + " -> " + role + " -> " + y + " : " + ATermUtils.toString(c) + (useExistingNode ? "" : " (*)") + " - " + ds);
            }
            this.addType(y, c, ds);
            if (!useExistingRole) {
                this.addEdge(x, role, y, ds);
            }
        }
    }

    protected void applyDisjunctionRule(IndividualIterator i) {
        i.reset(NodeSelector.DISJUNCTION);
        while (i.hasNext()) {
            Individual node = i.next();
            this.applyDisjunctionRule(node);
            if (!this.abox.isClosed() && !node.isMerged()) continue;
            return;
        }
    }

    protected void applyDisjunctionRule(Individual node) {
        if (!node.canApply(1)) {
            return;
        }
        if (this.blocking.isIndirectlyBlocked(node)) {
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().add(new QueueElement(node), NodeSelector.DISJUNCTION);
            }
            return;
        }
        List<ATermAppl> types = node.getTypes(1);
        int size = types.size();
        ATermAppl[] disjunctions = new ATermAppl[size - node.applyNext[1]];
        types.subList(node.applyNext[1], size).toArray(disjunctions);
        if (PelletOptions.USE_DISJUNCTION_SORTING != "NO") {
            CompletionStrategy.sortDisjunctions(node, disjunctions);
        }
        for (ATermAppl disjunction : disjunctions) {
            this.applyDisjunctionRule(node, disjunction);
            if (!this.abox.isClosed() && !node.isMerged()) continue;
            return;
        }
        node.applyNext[1] = size;
    }

    private static void sortDisjunctions(final Individual node, ATermAppl[] disjunctions) {
        if (PelletOptions.USE_DISJUNCTION_SORTING != "OLDEST_FIRST") {
            throw new InternalReasonerException("Unknown disjunction sorting option " + PelletOptions.USE_DISJUNCTION_SORTING);
        }
        Comparator<ATermAppl> comparator = new Comparator<ATermAppl>(){

            @Override
            public int compare(ATermAppl d1, ATermAppl d2) {
                return node.getDepends((ATerm)d1).max() - node.getDepends((ATerm)d2).max();
            }
        };
        Arrays.sort(disjunctions, comparator);
    }

    protected void applyDisjunctionRule(Individual node, ATermAppl disjunction) {
        ATermAppl a = (ATermAppl)disjunction.getArgument(0);
        ATermList disjuncts = (ATermList)a.getArgument(0);
        ATermAppl[] disj = new ATermAppl[disjuncts.getLength()];
        int index = 0;
        while (!disjuncts.isEmpty()) {
            disj[index] = ATermUtils.negate((ATermAppl)disjuncts.getFirst());
            if (node.hasType((ATerm)disj[index])) {
                return;
            }
            disjuncts = disjuncts.getNext();
            ++index;
        }
        DisjunctionBranch newBranch = new DisjunctionBranch(this.abox, this, node, disjunction, node.getDepends((ATerm)disjunction), disj);
        this.addBranch(newBranch);
        newBranch.tryNext();
    }

    protected boolean applyMaxRule(Individual x, Role r, ATermAppl c, int k, DependencySet ds) {
        EdgeList edges = x.getRNeighborEdges(r);
        Set<Node> neighbors = edges.getFilteredNeighbors(x, c);
        int n = neighbors.size();
        if (k == 0 && n > 0) {
            for (int e = 0; e < edges.size(); ++e) {
                Edge edge = edges.edgeAt(e);
                Node neighbor = edge.getNeighbor(x);
                DependencySet typeDS = neighbor.getDepends((ATerm)c);
                if (typeDS == null) continue;
                Role edgeRole = edge.getRole();
                DependencySet subDS = r.getExplainSubOrInv(edgeRole);
                ds = ds.union(subDS, this.abox.doExplanation());
                ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                ds = ds.union(typeDS, this.abox.doExplanation());
            }
            this.abox.setClash(Clash.maxCardinality(x, ds, r.getName(), 0));
            return false;
        }
        if (n <= k) {
            return false;
        }
        ArrayList<NodeMerge> mergePairs = new ArrayList<NodeMerge>();
        DependencySet differenceDS = this.findMergeNodes(neighbors, x, mergePairs);
        ds = ds.union(differenceDS, this.abox.doExplanation());
        if (mergePairs.size() == 0) {
            DependencySet dsEdges = x.hasDistinctRNeighborsForMax(r, k + 1, c);
            if (dsEdges == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Cannot determine the exact clash dependency for " + x);
                }
                this.abox.setClash(Clash.maxCardinality(x, ds));
                return false;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Early clash detection for max rule worked " + x + " has more than " + k + " " + r + " edges " + ds.union(dsEdges, this.abox.doExplanation()) + " " + x.getRNeighborEdges(r).getNeighbors(x));
            }
            if (this.abox.doExplanation()) {
                this.abox.setClash(Clash.maxCardinality(x, ds.union(dsEdges, this.abox.doExplanation()), r.getName(), k));
            } else {
                this.abox.setClash(Clash.maxCardinality(x, ds.union(dsEdges, this.abox.doExplanation())));
            }
            return false;
        }
        MaxBranch newBranch = new MaxBranch(this.abox, this, x, r, k, c, mergePairs, ds);
        this.addBranch(newBranch);
        if (!newBranch.tryNext()) {
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("hasMore: " + (n > k + 1));
        }
        return n > k + 1;
    }

    protected void applyChooseRule(IndividualIterator i) {
        i.reset(NodeSelector.CHOOSE);
        while (i.hasNext()) {
            Individual x = i.next();
            this.applyChooseRule(x);
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyChooseRule(Individual x) {
        if (!x.canApply(5)) {
            return;
        }
        if (this.blocking.isIndirectlyBlocked(x)) {
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().add(new QueueElement(x), NodeSelector.CHOOSE);
            }
            return;
        }
        List<ATermAppl> maxCardinality = x.getTypes(5);
        for (ATermAppl maxCard : maxCardinality) {
            this.applyChooseRule(x, maxCard);
        }
    }

    protected void applyChooseRule(Individual x, ATermAppl maxCard) {
        ATermAppl max = (ATermAppl)maxCard.getArgument(0);
        Role r = this.abox.getRole(max.getArgument(0));
        ATermAppl c = (ATermAppl)max.getArgument(2);
        if (ATermUtils.isTop(c)) {
            return;
        }
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && x.getDepends((ATerm)maxCard) == null) {
            return;
        }
        EdgeList edges = x.getRNeighborEdges(r);
        for (Edge edge : edges) {
            Node neighbor = edge.getNeighbor(x);
            if (neighbor.hasType((ATerm)c) || neighbor.hasType((ATerm)ATermUtils.negate(c))) continue;
            ChooseBranch newBranch = new ChooseBranch(this.abox, this, (Individual)neighbor, c, x.getDepends((ATerm)maxCard));
            this.addBranch(newBranch);
            newBranch.tryNext();
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyGuessingRule(IndividualIterator i) {
        i.reset(NodeSelector.GUESS);
        block0: while (i.hasNext()) {
            Individual x = i.next();
            if (x.isBlockable()) continue;
            List<ATermAppl> types = x.getTypes(5);
            int size = types.size();
            for (int j = 0; j < size; ++j) {
                ATermAppl mc = types.get(j);
                this.applyGuessingRule(x, mc);
                if (this.abox.isClosed()) {
                    return;
                }
                if (x.isPruned()) break block0;
            }
        }
    }

    private void applyGuessingRule(Individual x, ATermAppl mc) {
        ATermAppl max = (ATermAppl)mc.getArgument(0);
        Role r = this.abox.getRole(max.getArgument(0));
        int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
        if (r.isDatatypeRole()) {
            return;
        }
        boolean apply = false;
        EdgeList edges = x.getRPredecessorEdges(r.getInverse());
        for (int e = 0; e < edges.size(); ++e) {
            Edge edge = edges.edgeAt(e);
            Individual pred = edge.getFrom();
            if (!pred.isBlockable()) continue;
            apply = true;
            break;
        }
        if (!apply) {
            return;
        }
        if (x.getMaxCard(r) < n) {
            return;
        }
        if (x.hasDistinctRNeighborsForMin(r, n, ATermUtils.TOP, true)) {
            return;
        }
        int guessMin = x.getMinCard(r);
        if (guessMin == 0) {
            guessMin = 1;
        }
        DependencySet ds = x.getDepends((ATerm)mc);
        edges = x.getRNeighborEdges(r);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edge = edges.edgeAt(e);
            ds = ds.union(edge.getDepends(), this.abox.doExplanation());
        }
        GuessBranch newBranch = new GuessBranch(this.abox, this, x, r, guessMin, n, ds);
        this.addBranch(newBranch);
        newBranch.tryNext();
    }

    protected void applyMaxRule(IndividualIterator i) {
        i.reset(NodeSelector.MAX_NUMBER);
        while (i.hasNext()) {
            Individual x = i.next();
            this.applyMaxRule(x);
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyMaxRule(Individual x) {
        if (!x.canApply(5)) {
            return;
        }
        if (this.blocking.isIndirectlyBlocked(x)) {
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().add(new QueueElement(x), NodeSelector.MAX_NUMBER);
            }
            return;
        }
        List<ATermAppl> maxCardinality = x.getTypes(5);
        for (int i = 0; i < maxCardinality.size(); ++i) {
            ATermAppl mc = maxCardinality.get(i);
            this.applyMaxRule(x, mc);
            if (this.abox.isClosed()) {
                return;
            }
            if (!x.isMerged()) continue;
            return;
        }
        x.applyNext[5] = maxCardinality.size();
    }

    protected void applyMaxRule(Individual x, ATermAppl mc) {
        ATermAppl max = (ATermAppl)mc.getArgument(0);
        Role r = this.abox.getRole(max.getArgument(0));
        int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
        ATermAppl c = (ATermAppl)max.getArgument(2);
        DependencySet ds = x.getDepends((ATerm)mc);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        if (n == 1) {
            this.applyFunctionalMaxRule(x, r, c, ds);
            if (this.abox.isClosed()) {
                return;
            }
        } else {
            boolean hasMore = true;
            while (hasMore) {
                hasMore = this.applyMaxRule(x, r, c, n, ds);
                if (this.abox.isClosed()) {
                    return;
                }
                if (x.isMerged()) {
                    return;
                }
                if (!hasMore) continue;
                ds = ds.union(new DependencySet(this.abox.getBranches().size()), this.abox.doExplanation());
            }
        }
    }

    protected void applyMinRule(IndividualIterator i) {
        i.reset(NodeSelector.MIN_NUMBER);
        while (i.hasNext()) {
            Individual x = i.next();
            this.applyMinRule(x);
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyMinRule(Individual x) {
        if (!x.canApply(4)) {
            return;
        }
        if (this.blocking.isBlocked(x)) {
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().add(new QueueElement(x), NodeSelector.MIN_NUMBER);
            }
            return;
        }
        List<ATermAppl> types = x.getTypes(4);
        int size = types.size();
        for (int j = x.applyNext[4]; j < size; ++j) {
            ATermAppl mc = types.get(j);
            this.applyMinRule(x, mc);
            if (!this.abox.isClosed()) continue;
            return;
        }
        x.applyNext[4] = size;
    }

    protected void applyMinRule(Individual x, ATermAppl mc) {
        ATermAppl c;
        int n;
        Role r = this.abox.getRole(mc.getArgument(0));
        if (x.hasDistinctRNeighborsForMin(r, n = ((ATermInt)mc.getArgument(1)).getInt(), c = (ATermAppl)mc.getArgument(2))) {
            return;
        }
        DependencySet ds = x.getDepends((ATerm)mc);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("MIN : " + x + " -> " + r + " -> anon" + (n == 1 ? "" : this.abox.getAnonCount() + 1 + " - anon") + (this.abox.getAnonCount() + n) + " " + c + " " + ds);
        }
        Node[] y = new Node[n];
        for (int c1 = 0; c1 < n; ++c1) {
            y[c1] = r.isDatatypeRole() ? this.abox.addLiteral(ds) : this.createFreshIndividual(x, ds);
            Node succ = y[c1];
            DependencySet finalDS = ds;
            this.addEdge(x, r, succ, ds);
            if (succ.isPruned()) {
                finalDS = finalDS.union(succ.getMergeDependency(true), this.abox.doExplanation());
                succ = succ.getMergedTo();
            }
            this.addType(succ, c, finalDS);
            for (int c2 = 0; c2 < c1; ++c2) {
                succ.setDifferent(y[c2], finalDS);
            }
        }
    }

    protected void applyLiteralRule(CompletionQueue it) {
        it.reset(NodeSelector.LITERAL);
        while (it.hasNext()) {
            Literal lit = (Literal)it.nextLiteral();
            if (lit.getValue() != null) continue;
            LiteralValueBranch newBranch = new LiteralValueBranch(this.abox, this, lit, lit.getDatatype());
            this.addBranch(newBranch);
            newBranch.tryNext();
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyLiteralRule() {
        LiteralIterator i = new LiteralIterator(this.abox);
        while (i.hasNext()) {
            Datatype dt;
            Literal lit = (Literal)i.next();
            if (lit.getValue() != null || (dt = lit.getDatatype()).size() == -1) continue;
            LiteralValueBranch newBranch = new LiteralValueBranch(this.abox, this, lit, lit.getDatatype());
            this.addBranch(newBranch);
            newBranch.tryNext();
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyNominalRule(IndividualIterator i) {
        i.reset(NodeSelector.NOMINAL);
        while (i.hasNext()) {
            Individual y = i.next();
            if (!y.canApply(6)) continue;
            if (this.blocking.isBlocked(y)) {
                if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                this.abox.getCompletionQueue().add(new QueueElement(y), NodeSelector.NOMINAL);
                continue;
            }
            this.applyNominalRule(y);
            if (this.abox.isClosed()) {
                return;
            }
            if (!y.isMerged()) continue;
            this.applyNominalRule(y.getSame());
        }
    }

    void applyNominalRule(Individual y) {
        if (PelletOptions.USE_PSEUDO_NOMINALS) {
            return;
        }
        List<ATermAppl> types = y.getTypes(6);
        int size = types.size();
        for (int j = 0; j < size; ++j) {
            ATermAppl nc = types.get(j);
            DependencySet ds = y.getDepends((ATerm)nc);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) continue;
            this.applyNominalRule(y, nc, ds);
            if (!this.abox.isClosed() && !y.isMerged()) continue;
            return;
        }
    }

    void applyNominalRule(Individual y, ATermAppl nc, DependencySet ds) {
        this.abox.copyOnWrite();
        ATermAppl nominal = (ATermAppl)nc.getArgument(0);
        Individual z = this.abox.getIndividual((ATerm)nominal);
        if (z == null) {
            if (ATermUtils.isAnonNominal(nominal)) {
                z = this.abox.addIndividual(nominal, ds);
            } else {
                throw new InternalReasonerException("Nominal " + nominal + " not found in KB!");
            }
        }
        if (z.isMerged()) {
            ds = ds.union(z.getMergeDependency(true), this.abox.doExplanation());
            z = z.getSame();
        }
        if (y.isSame(z)) {
            return;
        }
        if (y.isDifferent(z)) {
            ds = ds.union(y.getDifferenceDependency(z), this.abox.doExplanation());
            if (this.abox.doExplanation()) {
                this.abox.setClash(Clash.nominal(y, ds, z.getName()));
            } else {
                this.abox.setClash(Clash.nominal(y, ds));
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("NOM:  " + y + " -> " + z);
        }
        this.mergeTo(y, z, ds);
    }

    private void mergeLater(Node y, Node z, DependencySet ds) {
        this.mergeList.add(new NodeMerge(y, z, ds));
    }

    public void mergeAll() {
        if (this.mergingAll) {
            return;
        }
        this.mergingAll = true;
        while (!(this.merging || this.mergeList.isEmpty() || this.abox.isClosed())) {
            NodeMerge merge = this.mergeList.remove(0);
            Node y = this.abox.getNode((ATerm)merge.getSource());
            Node z = this.abox.getNode((ATerm)merge.getTarget());
            DependencySet ds = merge.getDepends();
            if (y.isMerged()) {
                ds = ds.union(y.getMergeDependency(true), this.abox.doExplanation());
                y = y.getSame();
            }
            if (z.isMerged()) {
                ds = ds.union(z.getMergeDependency(true), this.abox.doExplanation());
                z = z.getSame();
            }
            if (y.isPruned() || z.isPruned()) continue;
            this.mergeTo(y, z, ds);
        }
        this.mergingAll = false;
    }

    public void mergeTo(Node y, Node z, DependencySet ds) {
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), y.getName());
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), z.getName());
        }
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addMergeDependency(y.getName(), z.getName(), ds);
        }
        if (y.isDifferent(z)) {
            this.abox.setClash(Clash.nominal(y, y.getDifferenceDependency(z).union(ds, this.abox.doExplanation())));
            return;
        }
        if (!y.isSame(z)) {
            this.abox.setChanged(true);
            if (this.merging) {
                this.mergeLater(y, z, ds);
                return;
            }
            this.merging = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine("MERG: " + y + " -> " + z + " " + ds);
            }
            ds = ds.copy(this.abox.getBranch());
            if (y instanceof Literal && z instanceof Literal) {
                this.mergeLiterals((Literal)y, (Literal)z, ds);
            } else if (y instanceof Individual && z instanceof Individual) {
                this.mergeIndividuals((Individual)y, (Individual)z, ds);
            } else {
                throw new InternalReasonerException("Invalid merge operation!");
            }
        }
        this.merging = false;
        this.mergeAll();
    }

    protected void mergeIndividuals(Individual y, Individual x, DependencySet ds) {
        y.setSame(x, ds);
        x.setNominalLevel(Math.min(x.getNominalLevel(), y.getNominalLevel()));
        Map<ATermAppl, DependencySet> types = y.getDepends();
        for (Map.Entry<ATermAppl, DependencySet> entry : types.entrySet()) {
            ATermAppl yType = entry.getKey();
            DependencySet finalDS = ds.union(entry.getValue(), this.abox.doExplanation());
            this.addType(x, yType, finalDS);
        }
        EdgeList inEdges = y.getInEdges();
        for (int e = 0; e < inEdges.size(); ++e) {
            Edge edge = inEdges.edgeAt(e);
            Individual z = edge.getFrom();
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this.abox.doExplanation());
            if (y.equals(z)) {
                this.addEdge(x, r, x, finalDS);
            } else if (x.hasSuccessor(z)) {
                this.addEdge(x, r.getInverse(), z, finalDS);
            } else {
                this.addEdge(z, r, x, finalDS);
            }
            z.removeEdge(edge);
            if (this.abox.getBranch() < 0 || !PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), z.getName());
        }
        x.inheritDifferents(y, ds);
        y.prune(ds);
        EdgeList outEdges = y.getOutEdges();
        for (int e = 0; e < outEdges.size(); ++e) {
            Edge edge = outEdges.edgeAt(e);
            Node z = edge.getTo();
            if (!z.isNominal() || y.equals(z)) continue;
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this.abox.doExplanation());
            this.addEdge(x, r, z, finalDS);
            if (this.abox.getBranch() < 0 || !PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), z.getName());
        }
    }

    protected void mergeLiterals(Literal y, Literal x, DependencySet ds) {
        y.setSame(x, ds);
        x.addAllTypes(y.getDepends(), ds);
        EdgeList inEdges = y.getInEdges();
        for (int e = 0; e < inEdges.size(); ++e) {
            Edge edge = inEdges.edgeAt(e);
            Individual z = edge.getFrom();
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this.abox.doExplanation());
            this.addEdge(z, r, x, finalDS);
            z.removeEdge(edge);
            if (this.abox.getBranch() < 0 || !PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), z.getName());
        }
        x.inheritDifferents(y, ds);
        y.prune(ds);
    }

    DependencySet findMergeNodes(Set<Node> neighbors, Individual node, List<NodeMerge> pairs) {
        Timer t = this.timers.startTimer("findMergeNodes");
        DependencySet ds = DependencySet.INDEPENDENT;
        ArrayList<Node> nodes = new ArrayList<Node>(neighbors);
        for (int i = 0; i < nodes.size(); ++i) {
            Node y = (Node)nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = (Node)nodes.get(j);
                if (y.isDifferent(x)) {
                    ds = ds.union(y.getDifferenceDependency(x), this.abox.doExplanation());
                    continue;
                }
                if (x.getNominalLevel() < y.getNominalLevel()) {
                    pairs.add(new NodeMerge(y, x));
                    continue;
                }
                if (y.isNominal()) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                if (y.hasSuccessor(node)) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                pairs.add(new NodeMerge(y, x));
            }
        }
        t.stop();
        return ds;
    }

    public void restoreLocal(Individual ind, Branch br) {
        this.abox.setClash(null);
        this.abox.setBranch(br.getBranch());
        HashMap<Node, Boolean> visited = new HashMap<Node, Boolean>();
        this.restoreLocal(ind, br.getBranch(), visited);
        for (Map.Entry entry : visited.entrySet()) {
            boolean restored = (Boolean)entry.getValue();
            if (!restored) continue;
            this.applyAllValues((Individual)entry.getKey());
        }
    }

    private void restoreLocal(Individual ind, int branch, Map<Node, Boolean> visited) {
        boolean restored = ind.restore(branch);
        visited.put(ind, restored);
        if (restored) {
            for (Edge edge : ind.getOutEdges()) {
                Node succ = edge.getTo();
                if (visited.containsKey(succ)) continue;
                if (succ.isLiteral()) {
                    visited.put(succ, Boolean.FALSE);
                    succ.restore(branch);
                    continue;
                }
                this.restoreLocal((Individual)succ, branch, visited);
            }
            for (Edge edge : ind.getInEdges()) {
                Individual pred = edge.getFrom();
                if (visited.containsKey(pred)) continue;
                this.restoreLocal(pred, branch, visited);
            }
        }
    }

    public void restore(Branch br) {
        this.abox.setBranch(br.getBranch());
        this.abox.setClash(null);
        this.abox.rulesNotApplied = true;
        this.mergeList.clear();
        List<ATermAppl> nodeList = this.abox.getNodeNames();
        if (log.isLoggable(Level.FINE)) {
            log.fine("RESTORE: Branch " + br.getBranch());
        }
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().clearQueue(NodeSelector.UNIVERSAL);
            this.abox.getCompletionQueue().restore(br.getBranch());
        }
        if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
            this.abox.getIncrementalChangeTracker().clear();
        }
        int nodeCount = nodeList.size();
        int deleteBlock = 0;
        for (int i = 0; i < nodeCount; ++i) {
            ATermAppl a = nodeList.get(i);
            Node node = this.abox.getNode((ATerm)a);
            if (node.getNodeDepends().getBranch() > br.getBranch()) {
                this.abox.removeNode(a);
                if (node.isMerged()) {
                    node.undoSetSame();
                }
                ++deleteBlock;
                continue;
            }
            if (deleteBlock > 0) {
                List<ATermAppl> subList = nodeList.subList(i - deleteBlock, i);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Remove nodes " + subList);
                }
                subList.clear();
                nodeCount -= deleteBlock;
                i -= deleteBlock;
                deleteBlock = 0;
            }
            if (PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            node.restore(br.getBranch());
        }
        if (deleteBlock > 0) {
            nodeList.subList(nodeCount - deleteBlock, nodeCount).clear();
        }
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            Set<ATermAppl> effected = this.abox.getBranchEffectTracker().removeAll(br.getBranch() + 1);
            for (ATermAppl a : effected) {
                Node n = this.abox.getNode((ATerm)a);
                if (n == null) continue;
                n.restore(br.getBranch());
            }
        }
        this.restoreAllValues();
        if (log.isLoggable(Level.FINE)) {
            this.abox.printTree();
        }
        if (!this.abox.isClosed()) {
            this.abox.validate();
        }
    }

    protected void addBranch(Branch newBranch) {
        this.abox.getBranches().add(newBranch);
        if (newBranch.getBranch() != this.abox.getBranches().size()) {
            throw new RuntimeException("Invalid branch created: " + newBranch.getBranch() + " != " + this.abox.getBranches().size());
        }
        this.completionTimer.check();
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addBranchAddDependency(newBranch);
        }
    }

    void printBlocked() {
        int blockedCount = 0;
        StringBuffer blockedNodes = new StringBuffer();
        IndividualIterator n = this.abox.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            ATermAppl x = node.getName();
            if (!this.blocking.isBlocked(node)) continue;
            ++blockedCount;
            blockedNodes.append(x).append(" ");
        }
        log.fine("Blocked nodes " + blockedCount + " [" + blockedNodes + "]");
    }

    protected void checkDatatypeCount(IndividualIterator it) {
        this.timers.startTimer("clashDatatype");
        it.reset(NodeSelector.DATATYPE);
        while (it.hasNext()) {
            Individual x = it.next();
            this.checkDatatypeCount(x);
            if (!this.abox.isClosed()) continue;
            return;
        }
        this.timers.stopTimer("clashDatatype");
    }

    void checkDatatypeCount(Individual x) {
        ATermAppl r;
        HashMap allValues = new HashMap();
        HashMap<ATermAppl, DependencySet> depends = new HashMap<ATermAppl, DependencySet>();
        for (ATermAppl av : x.getTypes(3)) {
            if (av.getArgument(0) instanceof ATermList) continue;
            r = (ATermAppl)av.getArgument(0);
            ATermAppl c = (ATermAppl)av.getArgument(1);
            Role role = this.abox.getRole((ATerm)r);
            if (!role.isDatatypeRole()) continue;
            DependencySet ds = (DependencySet)depends.get(r);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && x.getDepends((ATerm)av) == null) continue;
            ArrayList<ATermAppl> ranges = (ArrayList<ATermAppl>)allValues.get(r);
            if (ranges == null) {
                ranges = new ArrayList<ATermAppl>();
                ds = DependencySet.EMPTY;
            }
            if (ATermUtils.isAnd(c)) {
                ATermList types = (ATermList)c.getArgument(0);
                while (types.isEmpty()) {
                    ranges.add((ATermAppl)types.getFirst());
                    types = types.getNext();
                }
            } else {
                ranges.add(c);
            }
            ds = ds.union(x.getDepends((ATerm)av), this.abox.doExplanation());
            allValues.put(r, ranges);
            depends.put(r, ds);
        }
        for (ATermAppl mc : x.getTypes(4)) {
            r = (ATermAppl)mc.getArgument(0);
            Role role = this.abox.getRole((ATerm)r);
            Set<ATermAppl> ranges = role.getRanges();
            if (!role.isDatatypeRole() || ranges.isEmpty() || !PelletOptions.MAINTAIN_COMPLETION_QUEUE && x.getDepends((ATerm)mc) == null) continue;
            ArrayList<ATermAppl> allRanges = (ArrayList<ATermAppl>)allValues.get(r);
            if (allRanges == null) {
                allRanges = new ArrayList<ATermAppl>();
                allValues.put(r, allRanges);
                depends.put(r, DependencySet.INDEPENDENT);
            }
            allRanges.addAll(ranges);
        }
        for (Map.Entry entry : allValues.entrySet()) {
            ATermAppl max;
            boolean clash;
            r = (ATermAppl)entry.getKey();
            List ranges = (List)entry.getValue();
            ATermAppl[] dt = new ATermAppl[ranges.size()];
            ranges.toArray(dt);
            this.timers.startTimer("getMaxCount");
            int n = this.abox.getDatatypeReasoner().intersection(dt).size();
            this.timers.stopTimer("getMaxCount");
            if (n == -1 || n == Integer.MAX_VALUE || !(clash = x.checkMaxClash(max = ATermUtils.makeNormalizedMax(r, n, ATermUtils.TOP_LIT), DependencySet.INDEPENDENT))) continue;
            return;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        int lastIndex = name.lastIndexOf(46);
        return name.substring(lastIndex + 1);
    }

    protected void restoreAllValues() {
        IndividualIterator i = new IndividualIterator(this.abox);
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.applyAllValues(ind);
        }
    }
}

