/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.completion.SRQStrategy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.Timer;

public class EmptySRQStrategy
extends SRQStrategy {
    private LinkedList<Individual> mayNeedExpanding;
    private Individual root;
    private Map<Individual, ATermAppl> cachedNodes;
    private Map<ATermAppl, Individual> inverseCache;
    private List<List<Individual>> mnx;
    public static final int NONE = 0;
    public static final int HIT = 1;
    public static final int MISS = 2;
    public static final int FAIL = 4;
    public static final int ADD = 8;
    public static final int ALL = 15;
    public static int SHOW_CACHE_INFO = 0;

    public EmptySRQStrategy(ABox abox) {
        super(abox);
    }

    public void initialize() {
        this.mergeList = new ArrayList();
        this.cachedNodes = new HashMap<Individual, ATermAppl>();
        this.inverseCache = new HashMap<ATermAppl, Individual>();
        this.mnx = new ArrayList<List<Individual>>();
        this.mnx.add(null);
        assert (this.abox.size() == 1) : "EmptySHNStrategy can only be used with originally empty ABoxes";
        this.root = this.abox.getIndIterator().next();
        this.applyUniversalRestrictions(this.root);
        this.abox.setBranch(1);
        this.abox.treeDepth = 1;
        this.abox.setChanged(true);
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    public void complete(Expressivity expr) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("************  EmptySHNStrategy  ************");
        }
        if (this.abox.getNodes().isEmpty()) {
            this.abox.setComplete(true);
            return;
        }
        if (this.abox.getNodes().size() > 1) {
            throw new RuntimeException("EmptySHNStrategy can only be used with an ABox that has a single individual.");
        }
        this.initialize();
        this.mayNeedExpanding = new LinkedList();
        this.mayNeedExpanding.add(this.root);
        while (!this.abox.isComplete() && !this.abox.isClosed()) {
            Individual x = this.getNextIndividual();
            if (x == null) {
                this.abox.setComplete(true);
                break;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Starting with node " + x);
                this.abox.printTree();
                this.abox.validate();
            }
            this.expand(x);
            if (!this.abox.isClosed()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
            }
            if (this.backtrack()) {
                this.abox.setClash(null);
                continue;
            }
            this.abox.setComplete(true);
        }
        if (log.isLoggable(Level.FINE)) {
            this.abox.printTree();
        }
        if (PelletOptions.USE_ADVANCED_CACHING && !this.abox.isClosed()) {
            IndividualIterator i = new IndividualIterator(this.abox);
            while (i.hasNext()) {
                Individual ind = (Individual)i.next();
                ATermAppl c = this.cachedNodes.get(ind);
                if (c == null) continue;
                this.cacheSat(c);
            }
        }
    }

    private void cacheSat(ATermAppl c) {
        if (!this.abox.getCache().putSat(c, true)) {
            return;
        }
        if ((SHOW_CACHE_INFO & 8) != 0) {
            System.out.println("+++ Cache sat concept " + c);
        }
        if (ATermUtils.isAnd(c)) {
            ATermList list = (ATermList)c.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl d = (ATermAppl)list.getFirst();
                this.cacheSat(d);
                list = list.getNext();
            }
        }
    }

    private Individual getNextIndividual() {
        if (this.mayNeedExpanding.isEmpty()) {
            return null;
        }
        return this.mayNeedExpanding.get(0);
    }

    private void expand(Individual x) {
        if (this.blocking.isDirectlyBlocked(x)) {
            this.mayNeedExpanding.remove(0);
            return;
        }
        this.completionTimer.check();
        if (!this.abox.doExplanation() && PelletOptions.USE_ADVANCED_CACHING) {
            Timer t = this.abox.getKB().timers.startTimer("cache");
            Bool cachedSat = this.cachedSat(x);
            t.stop();
            if (cachedSat.isKnown()) {
                if (cachedSat.isTrue()) {
                    this.mayNeedExpanding.remove(0);
                } else {
                    DependencySet ds = DependencySet.EMPTY;
                    for (ATermAppl c : x.getTypes()) {
                        ds = ds.union(x.getDepends((ATerm)c), this.abox.doExplanation());
                    }
                    this.abox.setClash(Clash.atomic(x, ds));
                }
                return;
            }
        }
        do {
            this.applyUnfoldingRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.applyDisjunctionRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            if (x.canApply(0) || x.canApply(1)) continue;
            this.applySomeValuesRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.applyMinRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            if (x.canApply(0) || x.canApply(1)) continue;
            this.applyChooseRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.applyMaxRule(x);
            if (!this.abox.isClosed()) continue;
            return;
        } while (x.canApply(0) || x.canApply(1) || x.canApply(2) || x.canApply(4));
        this.mayNeedExpanding.remove(0);
        EdgeList sortedSuccessors = x.getOutEdges().sort();
        if (PelletOptions.SEARCH_TYPE) {
            for (Edge edge : sortedSuccessors) {
                Node succ = edge.getTo();
                if (succ.isLiteral() || succ.equals(x)) continue;
                this.mayNeedExpanding.add((Individual)succ);
            }
        } else {
            for (int i = sortedSuccessors.size() - 1; i >= 0; --i) {
                Edge edge = sortedSuccessors.edgeAt(i);
                Node succ = edge.getTo();
                if (succ.isLiteral() || succ.equals(x)) continue;
                this.mayNeedExpanding.add((Individual)succ);
            }
        }
    }

    private ATermAppl createConcept(Individual x) {
        int count = 0;
        ATermAppl[] terms = new ATermAppl[x.getTypes().size()];
        for (int t = 0; t < 7; ++t) {
            if (t == 6) continue;
            for (ATermAppl c : x.getTypes(t)) {
                if (c.equals(ATermUtils.TOP)) continue;
                terms[count++] = c;
            }
        }
        switch (count) {
            case 0: {
                return ATermUtils.TOP;
            }
            case 1: {
                return terms[0];
            }
        }
        return ATermUtils.makeAnd(ATermUtils.toSet((ATerm[])terms, count));
    }

    private Bool cachedSat(Individual x) {
        ATermList concepts;
        if (x.equals(this.root) || this.cachedNodes.containsKey(x)) {
            return Bool.UNKNOWN;
        }
        ATermAppl c = this.createConcept(x);
        Individual cachedNode = this.inverseCache.get(c);
        if (cachedNode != null) {
            if (cachedNode.equals(x)) {
                return Bool.UNKNOWN;
            }
            if ((SHOW_CACHE_INFO & 1) != 0) {
                System.out.println("already searching for " + c);
            }
            return Bool.TRUE;
        }
        Bool sat = this.abox.getCachedSat(c);
        if (sat.isUnknown() && ATermUtils.isAnd(c) && (concepts = (ATermList)c.getArgument(0)).getLength() == 2) {
            ATermAppl c1 = (ATermAppl)concepts.getFirst();
            ATermAppl c2 = (ATermAppl)concepts.getLast();
            CachedNode cached1 = this.abox.getCached(c1);
            CachedNode cached2 = this.abox.getCached(c2);
            if (cached1 != null && cached1.isComplete() && cached2 != null && cached2.isComplete() && (sat = this.abox.getCache().isMergable(this.abox.getKB(), cached1, cached2)).isKnown()) {
                this.abox.getCache().putSat(c, sat.isTrue());
            }
        }
        if (sat.isUnknown()) {
            if ((SHOW_CACHE_INFO & 2) != 0) {
                System.out.println("??? Cache miss for " + c);
            }
            this.cachedNodes.put(x, c);
            this.inverseCache.put(c, x);
        } else if ((SHOW_CACHE_INFO & 1) != 0) {
            System.out.println("*** Cache hit for " + c + " sat = " + sat);
        }
        return sat;
    }

    public void restoreLocal(Individual ind, Branch br) {
        this.restore(br);
    }

    public void restore(Branch br) {
        Node clashNode = this.abox.getClash().getNode();
        List<ATermAppl> clashPath = clashNode.getPath();
        clashPath.add(clashNode.getName());
        this.abox.setBranch(br.getBranch());
        this.abox.setClash(null);
        this.mergeList.clear();
        List<ATermAppl> nodeList = this.abox.getNodeNames();
        if (log.isLoggable(Level.FINE)) {
            log.fine("RESTORE: Branch " + br.getBranch());
            if (br.getNodeCount() < nodeList.size()) {
                log.fine("Remove nodes " + nodeList.subList(br.getNodeCount(), nodeList.size()));
            }
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ATermAppl c;
            ATermAppl x = nodeList.get(i);
            Node node = this.abox.getNode((ATerm)x);
            if (i >= br.getNodeCount()) {
                this.abox.removeNode(x);
                c = this.cachedNodes.remove(node);
                if (c != null) {
                    this.inverseCache.remove(c);
                }
                if (c == null || !PelletOptions.USE_ADVANCED_CACHING) continue;
                if (clashPath.contains(x)) {
                    if ((SHOW_CACHE_INFO & 8) != 0) {
                        System.out.println("+++ Cache unsat concept " + c);
                    }
                    this.abox.getCache().putSat(c, false);
                    continue;
                }
                if ((SHOW_CACHE_INFO & 8) == 0) continue;
                System.out.println("--- Do not cache concept " + c + " " + x + " " + clashNode + " " + clashPath);
                continue;
            }
            node.restore(br.getBranch());
            if (!node.equals(clashNode) || (c = this.cachedNodes.remove(node)) == null) continue;
            this.inverseCache.remove(c);
        }
        nodeList.subList(br.getNodeCount(), nodeList.size()).clear();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.applyAllValues(ind);
        }
        if (log.isLoggable(Level.FINE)) {
            this.abox.printTree();
        }
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        while (!branchFound) {
            this.completionTimer.check();
            int lastBranch = this.abox.getClash().getDepends().max();
            if (lastBranch <= 0) {
                return false;
            }
            List<Branch> branches = this.abox.getBranches();
            Branch newBranch = null;
            if (lastBranch <= branches.size()) {
                branches.subList(lastBranch, branches.size()).clear();
                newBranch = branches.get(lastBranch - 1);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("JUMP: " + lastBranch);
                }
                if (newBranch == null || lastBranch != newBranch.getBranch()) {
                    throw new RuntimeException("Internal error in reasoner: Trying to backtrack branch " + lastBranch + " but got " + newBranch);
                }
                if (newBranch.getTryNext() < newBranch.getTryCount()) {
                    newBranch.setLastClash(this.abox.getClash().getDepends());
                }
                newBranch.setTryNext(newBranch.getTryNext() + 1);
                if (newBranch.getTryNext() < newBranch.getTryCount()) {
                    this.restore(newBranch);
                    branchFound = newBranch.tryNext();
                }
            }
            if (!branchFound) {
                this.abox.getClash().getDepends().remove(lastBranch);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("FAIL: " + lastBranch);
                continue;
            }
            this.mayNeedExpanding = new LinkedList(this.mnx.get(newBranch.getBranch()));
            this.mnx.subList(newBranch.getBranch() + 1, this.mnx.size()).clear();
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("MNX : " + this.mayNeedExpanding);
        }
        this.abox.validate();
        return branchFound;
    }

    protected void addBranch(Branch newBranch) {
        super.addBranch(newBranch);
        assert (this.mnx.size() == newBranch.getBranch()) : this.mnx.size() + " != " + newBranch.getBranch();
        this.mnx.add(new ArrayList<Individual>(this.mayNeedExpanding));
    }
}

