/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import com.clarkparsia.pellet.expressivity.Expressivity;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.blocking.Blocking;
import org.mindswap.pellet.tableau.blocking.DoubleBlocking;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;

public class SROIQStrategy
extends CompletionStrategy {
    public SROIQStrategy(ABox abox) {
        super(abox, new DoubleBlocking());
    }

    protected SROIQStrategy(ABox abox, Blocking blocking) {
        super(abox, blocking);
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        while (!branchFound) {
            Branch br;
            this.completionTimer.check();
            int lastBranch = this.abox.getClash().getDepends().max();
            if (lastBranch <= 0) {
                return false;
            }
            if (lastBranch > this.abox.getBranches().size()) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but has only " + this.abox.getBranches().size() + " branches. Clash found: " + this.abox.getClash());
            }
            if (PelletOptions.USE_INCREMENTAL_DELETION && (br = this.abox.getBranches().get(lastBranch - 1)).getTryNext() == br.getTryCount() - 1 && this.abox.getClash().getDepends().size() == 2) {
                this.abox.getKB().getDependencyIndex().addCloseBranchDependency(br, this.abox.getClash().getDepends());
                return false;
            }
            List<Branch> branches = this.abox.getBranches();
            if (PelletOptions.USE_TRACING && PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                List<Branch> brList = branches.subList(lastBranch, branches.size());
                Iterator<Branch> it = brList.iterator();
                while (it.hasNext()) {
                    this.abox.getKB().getDependencyIndex().removeBranchDependencies(it.next());
                }
                brList.clear();
            } else {
                branches.subList(lastBranch, branches.size()).clear();
            }
            Branch newBranch = branches.get(lastBranch - 1);
            if (log.isLoggable(Level.FINE)) {
                log.fine("JUMP: Branch " + lastBranch);
            }
            if (lastBranch != newBranch.getBranch()) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but got " + newBranch.getBranch());
            }
            if (newBranch.getTryNext() < newBranch.getTryCount()) {
                newBranch.setLastClash(this.abox.getClash().getDepends());
            }
            newBranch.setTryNext(newBranch.getTryNext() + 1);
            if (newBranch.getTryNext() < newBranch.getTryCount()) {
                this.restore(newBranch);
            }
            if ((branchFound = newBranch.tryNext()) || !log.isLoggable(Level.FINE)) continue;
            log.fine("FAIL: Branch " + lastBranch);
        }
        return branchFound;
    }

    public void complete(Expressivity expr) {
        boolean fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expr.hasUserDefinedDatatype() || expr.hasCardinalityD() || expr.hasKeys());
        this.initialize();
        while (!this.abox.isComplete()) {
            while (this.abox.isChanged() && !this.abox.isClosed()) {
                IndividualIterator i;
                this.completionTimer.check();
                this.abox.setChanged(false);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this.abox.validate();
                    this.printBlocked();
                    this.abox.printTree();
                }
                IndividualIterator individualIterator = i = PelletOptions.USE_COMPLETION_QUEUE ? this.abox.getCompletionQueue() : this.abox.getIndIterator();
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().flushQueue();
                }
                if (!PelletOptions.USE_PSEUDO_NOMINALS) {
                    this.applyNominalRule(i);
                    if (this.abox.isClosed()) break;
                }
                this.applyGuessingRule(i);
                if (this.abox.isClosed()) break;
                this.applyChooseRule(i);
                if (this.abox.isClosed()) break;
                this.applyMaxRule(i);
                if (this.abox.isClosed()) break;
                if (fullDatatypeReasoning) {
                    this.checkDatatypeCount(i);
                    if (this.abox.isClosed()) break;
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        this.abox.getCompletionQueue().setAllowLiterals(true);
                    }
                    this.applyLiteralRule();
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        this.abox.getCompletionQueue().setAllowLiterals(false);
                    }
                    if (this.abox.isClosed()) break;
                }
                this.applyUnfoldingRule(i);
                if (this.abox.isClosed()) break;
                this.applyDisjunctionRule(i);
                if (this.abox.isClosed()) break;
                this.applySomeValuesRule(i);
                if (this.abox.isClosed()) break;
                this.applyMinRule(i);
                if (this.abox.isClosed()) break;
                if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                this.abox.getCompletionQueue().setClosed(this.abox.isClosed());
            }
            if (this.abox.isClosed()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                    this.abox.getCompletionQueue().setClosed(false);
                    continue;
                }
                this.abox.setComplete(true);
                if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                this.abox.getCompletionQueue().flushQueue();
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = this.abox.getBranches().get(i);
                    unexploredBranch.setTryNext(unexploredBranch.getTryNext() + 1);
                    if (unexploredBranch.getTryNext() < unexploredBranch.getTryCount()) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring branch " + unexploredBranch.getBranch() + " tryNext = " + unexploredBranch.getTryNext() + " tryCount = " + unexploredBranch.getTryCount());
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing branch " + unexploredBranch.getBranch());
                    this.abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
    }
}

