/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy.printer;

import aterm.ATermAppl;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.taxonomy.printer.TreeTaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.TaxonomyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTreePrinter
extends TreeTaxonomyPrinter<ATermAppl>
implements TaxonomyPrinter<ATermAppl> {
    private QNameProvider qnames = new QNameProvider();

    @Override
    protected void printNode(Set<ATermAppl> set) {
        super.printNode(set);
        Set<ATermAppl> instances = TaxonomyUtils.getDirectInstances(this.taxonomy, set.iterator().next());
        if (instances.size() > 0) {
            this.out.print(" - (");
            boolean printed = false;
            int anonCount = 0;
            Iterator<ATermAppl> ins = instances.iterator();
            int k = 0;
            while (ins.hasNext()) {
                ATermAppl x = ins.next();
                if (ATermUtils.isBnode(x)) {
                    ++anonCount;
                } else {
                    if (printed) {
                        this.out.print(", ");
                    } else {
                        printed = true;
                    }
                    this.printURI(this.out, x);
                }
                ++k;
            }
            if (anonCount > 0) {
                if (printed) {
                    this.out.print(", ");
                }
                this.out.print(anonCount + " Anonymous Individual");
                if (anonCount > 1) {
                    this.out.print("s");
                }
            }
            this.out.print(")");
        }
    }

    @Override
    protected void printURI(PrintWriter out, ATermAppl c) {
        String str = null;
        str = c.equals(ATermUtils.TOP) ? "owl:Thing" : (c.equals(ATermUtils.BOTTOM) ? "owl:Nothing" : (ATermUtils.isPrimitive(c) ? this.qnames.shortForm(c.getName()) : c.toString()));
        out.print(str);
    }
}

