/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.QueryNode;
import com.hp.hpl.jena.graph.query.QueryNodeFactory;
import com.hp.hpl.jena.graph.query.QueryTriple;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import com.ibm.icu.util.StringTokenizer;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestSuite;

public class TestQueryTriple
extends QueryTestBase {
    public static final QueryNodeFactory F = QueryNode.factory;
    protected static final String[][] matchings = new String[][]{{"s P o", "s P o", "y"}, {"s P o", "a Q b", "y"}, {"?x P y", "a P y", "y0=a"}, {"?x P ?y", "go P og", "y0=go;1=og"}, {"?x P ?x", "a P a", "y0=a"}, {"?x P ?x", "a P b", "n"}};

    public TestQueryTriple(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestQueryTriple.class);
    }

    public void testQueryTripleSPO() {
        QueryNode.Fixed S = new QueryNode.Fixed(Node.create((String)"_subject"));
        QueryNode.Fixed P = new QueryNode.Fixed(Node.create((String)"predicate"));
        QueryNode.Fixed O = new QueryNode.Fixed(Node.create((String)"99"));
        QueryTriple t = new QueryTriple((QueryNode)S, (QueryNode)P, (QueryNode)O);
        TestQueryTriple.assertSame((Object)S, (Object)t.S);
        TestQueryTriple.assertSame((Object)P, (Object)t.P);
        TestQueryTriple.assertSame((Object)O, (Object)t.O);
    }

    public void testQueryTripleClassifySimple() {
        this.testQueryTripleClassifySimple(TestQueryTriple.triple("_x y ?z"));
        this.testQueryTripleClassifySimple(TestQueryTriple.triple("a b 17"));
        this.testQueryTripleClassifySimple(TestQueryTriple.triple("?? y _"));
        this.testQueryTripleClassifySimple(TestQueryTriple.triple("?x y z"));
    }

    protected void testQueryTripleClassifySimple(Triple t) {
        Mapping m = new Mapping(new Node[0]);
        Mapping m2 = new Mapping(new Node[0]);
        HashSet s = new HashSet();
        QueryTriple q = QueryTriple.classify((QueryNodeFactory)F, (Mapping)m, (Triple)t);
        this.testClassifiedOK(t.getSubject(), m2, s, q.S);
        this.testClassifiedOK(t.getPredicate(), m2, s, q.P);
        this.testClassifiedOK(t.getObject(), m2, s, q.O);
    }

    protected void testClassifiedOK(Node node, Mapping m2, Set s, QueryNode q) {
        TestQueryTriple.assertSame((Object)node, (Object)q.node);
        TestQueryTriple.assertSame(QueryNode.classify((QueryNodeFactory)F, (Mapping)m2, (Set)s, (Node)node).getClass(), q.getClass());
    }

    public void testJustBoundSO() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple q = QueryTriple.classify((QueryNodeFactory)F, (Mapping)m, (Triple)TestQueryTriple.triple("?x ?y ?x"));
        TestQueryTriple.assertEquals((Object)QueryNode.JustBound.class, q.O.getClass());
        TestQueryTriple.assertEquals((int)q.S.index, (int)q.O.index);
    }

    public void testJustBoundSP() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple q = QueryTriple.classify((QueryNodeFactory)F, (Mapping)m, (Triple)TestQueryTriple.triple("?x ?x ?y"));
        TestQueryTriple.assertEquals((Object)QueryNode.JustBound.class, q.P.getClass());
        TestQueryTriple.assertEquals((int)q.S.index, (int)q.P.index);
    }

    public void testJustBoundPO() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple q = QueryTriple.classify((QueryNodeFactory)F, (Mapping)m, (Triple)TestQueryTriple.triple("?x ?y ?y"));
        TestQueryTriple.assertEquals((Object)QueryNode.JustBound.class, q.O.getClass());
        TestQueryTriple.assertEquals((int)q.P.index, (int)q.O.index);
    }

    public void testJustBoundSPO() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple q = QueryTriple.classify((QueryNodeFactory)F, (Mapping)m, (Triple)TestQueryTriple.triple("?x ?x ?x"));
        TestQueryTriple.assertEquals((Object)QueryNode.JustBound.class, q.P.getClass());
        TestQueryTriple.assertEquals((Object)QueryNode.JustBound.class, q.O.getClass());
        TestQueryTriple.assertEquals((int)q.S.index, (int)q.P.index);
        TestQueryTriple.assertEquals((int)q.S.index, (int)q.O.index);
    }

    public void testSimpleClassifyArray() {
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray(""));
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray("a P b"));
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray("a P b; c Q d"));
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray("?a P ?b; ?b Q ?c"));
        this.testSimpleClassifyArray(TestQueryTriple.tripleArray("?a P ?b; ?b Q ?c; ?a Z ?c"));
    }

    protected void testSimpleClassifyArray(Triple[] triples) {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple[] q = QueryTriple.classify((QueryNodeFactory)F, (Mapping)m, (Triple[])triples);
        TestQueryTriple.assertEquals((int)triples.length, (int)q.length);
        for (int i = 0; i < q.length; ++i) {
            TestQueryTriple.assertEquals((Object)triples[i].getSubject(), (Object)q[i].S.node);
            TestQueryTriple.assertEquals((Object)triples[i].getPredicate(), (Object)q[i].P.node);
            TestQueryTriple.assertEquals((Object)triples[i].getObject(), (Object)q[i].O.node);
        }
    }

    public void testJustBoundConfinement() {
        Mapping m = new Mapping(new Node[0]);
        QueryTriple[] q = QueryTriple.classify((QueryNodeFactory)F, (Mapping)m, (Triple[])TestQueryTriple.tripleArray("?x P ?x; ?x Q ?x"));
        TestQueryTriple.assertInstanceOf(QueryNode.Bind.class, q[0].S);
        TestQueryTriple.assertInstanceOf(QueryNode.JustBound.class, q[0].O);
        TestQueryTriple.assertInstanceOf(QueryNode.Bound.class, q[1].S);
    }

    public void testMatch() {
        for (int i = 0; i < matchings.length; ++i) {
            String[] m = matchings[i];
            this.testMatch(TestQueryTriple.triple(m[0]), TestQueryTriple.triple(m[1]), m[2].charAt(0) == 'y', m[2].substring(1));
        }
    }

    protected void testMatch(Triple toClassify, Triple toMatch, boolean result, String bindings) {
        Mapping map = new Mapping(new Node[0]);
        QueryTriple t = QueryTriple.classify((QueryNodeFactory)F, (Mapping)map, (Triple)toClassify);
        Matcher m = t.createMatcher();
        Domain d = new Domain(3);
        TestQueryTriple.assertEquals((boolean)result, (boolean)m.match(d, toMatch));
        StringTokenizer st = new StringTokenizer(bindings, ";");
        while (st.hasMoreTokens()) {
            this.testBinding(d, st.nextToken());
        }
    }

    protected void testBinding(Domain d, String binding) {
        int eq = binding.indexOf(61);
        int index = Integer.parseInt(binding.substring(0, eq));
        Node value = Node.create((String)binding.substring(eq + 1));
        TestQueryTriple.assertEquals((Object)value, (Object)d.getElement(index));
    }
}

