/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.RecordingListener;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AbstractTestGraph
extends GraphTestBase {
    static final Triple[] tripleArray = AbstractTestGraph.tripleArray("S P O; A R B; X Q Y");
    static final List tripleList = Arrays.asList(AbstractTestGraph.tripleArray("i lt j; p equals q"));
    static final Triple[] setTriples = AbstractTestGraph.tripleArray("scissors cut paper; paper wraps stone; stone breaks scissors");
    static final Set tripleSet = CollectionFactory.createHashedSet(Arrays.asList(setTriples));
    protected Triple SPO = Triple.create((String)"S P O");
    protected RecordingListener L = new RecordingListener();
    protected String[][] cases = new String[][]{{"x R y", "x R y", ""}, {"x R y; a P b", "x R y", "a P b"}, {"x R y; a P b", "?? R y", "a P b"}, {"x R y; a P b", "x R ??", "a P b"}, {"x R y; a P b", "x ?? y", "a P b"}, {"x R y; a P b", "?? ?? ??", ""}, {"x R y; a P b; c P d", "?? P ??", "x R y"}, {"x R y; a P b; x S y", "x ?? ??", "a P b"}};

    public AbstractTestGraph(String name) {
        super(name);
    }

    public Graph getGraph() {
        return Factory.createGraphMem();
    }

    public Graph getGraphWith(String facts) {
        Graph g = this.getGraph();
        AbstractTestGraph.graphAdd(g, facts);
        return g;
    }

    public void testCloseSetsIsClosed() {
        Graph g = this.getGraph();
        AbstractTestGraph.assertFalse((String)"unclosed Graph shouild not be isClosed()", (boolean)g.isClosed());
        g.close();
        AbstractTestGraph.assertTrue((String)"closed Graph should be isClosed()", (boolean)g.isClosed());
    }

    public void testFindAndContains() {
        Graph g = this.getGraph();
        Node r = Node.create((String)"r");
        Node s = Node.create((String)"s");
        Node p = Node.create((String)"P");
        g.add(Triple.create((Node)r, (Node)p, (Node)s));
        AbstractTestGraph.assertTrue((boolean)g.contains(r, p, Node.ANY));
        AbstractTestGraph.assertEquals((int)1, (int)g.find(r, p, Node.ANY).toList().size());
    }

    public void testRepeatedSubjectDoesNotConceal() {
        Graph g = this.getGraphWith("s P o; s Q r");
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("s P o")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("s Q r")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("?? P o")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("?? Q r")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("?? P ??")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("?? Q ??")));
    }

    public void testFindByFluidTriple() {
        Graph g = this.getGraphWith("x y z ");
        Set expect = AbstractTestGraph.tripleSet("x y z");
        AbstractTestGraph.assertEquals((Object)expect, (Object)g.find((TripleMatch)AbstractTestGraph.triple("?? y z")).toSet());
        AbstractTestGraph.assertEquals((Object)expect, (Object)g.find((TripleMatch)AbstractTestGraph.triple("x ?? z")).toSet());
        AbstractTestGraph.assertEquals((Object)expect, (Object)g.find((TripleMatch)AbstractTestGraph.triple("x y ??")).toSet());
    }

    public void testContainsConcrete() {
        Graph g = this.getGraphWith("s P o; _x _R _y; x S 0");
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("s P o")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("_x _R _y")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("x S 0")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("s P Oh")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("S P O")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("s p o")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("_x _r _y")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("x S 1")));
    }

    public void testContainsFluid() {
        Graph g = this.getGraphWith("x R y; a P b");
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("?? R y")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("x ?? y")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("x R ??")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("?? P b")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("a ?? b")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("a P ??")));
        AbstractTestGraph.assertTrue((boolean)g.contains(AbstractTestGraph.triple("?? R y")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("?? R b")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("a ?? y")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("x P ??")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("?? R x")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("x ?? R")));
        AbstractTestGraph.assertFalse((boolean)g.contains(AbstractTestGraph.triple("a S ??")));
    }

    public void testContainsByValue() {
        if (this.getGraph().getCapabilities().handlesLiteralTyping()) {
            Graph g1 = this.getGraphWith("x P '1'xsd:integer");
            AbstractTestGraph.assertTrue((boolean)g1.contains(AbstractTestGraph.triple("x P '01'xsd:int")));
            Graph g2 = this.getGraphWith("x P '1'xsd:int");
            AbstractTestGraph.assertTrue((boolean)g2.contains(AbstractTestGraph.triple("x P '1'xsd:integer")));
            Graph g3 = this.getGraphWith("x P '123'xsd:string");
            AbstractTestGraph.assertTrue((boolean)g3.contains(AbstractTestGraph.triple("x P '123'")));
        }
    }

    public void testIsEmpty() {
        Graph g = this.getGraph();
        if (this.canBeEmpty(g)) {
            AbstractTestGraph.assertTrue((boolean)g.isEmpty());
            g.add(Triple.create((String)"S P O"));
            AbstractTestGraph.assertFalse((boolean)g.isEmpty());
            g.add(Triple.create((String)"A B C"));
            AbstractTestGraph.assertFalse((boolean)g.isEmpty());
            g.add(Triple.create((String)"S P O"));
            AbstractTestGraph.assertFalse((boolean)g.isEmpty());
            g.delete(Triple.create((String)"S P O"));
            AbstractTestGraph.assertFalse((boolean)g.isEmpty());
            g.delete(Triple.create((String)"A B C"));
            AbstractTestGraph.assertTrue((boolean)g.isEmpty());
        }
    }

    public void testAGraph() {
        String title = ((Object)((Object)this)).getClass().getName();
        Graph g = this.getGraph();
        int baseSize = g.size();
        AbstractTestGraph.graphAdd(g, "x R y; p S q; a T b");
        AbstractTestGraph.assertContainsAll(title + ": simple graph", g, "x R y; p S q; a T b");
        AbstractTestGraph.assertEquals((String)(title + ": size"), (int)(baseSize + 3), (int)g.size());
        AbstractTestGraph.graphAdd(g, "spindizzies lift cities; Diracs communicate instantaneously");
        AbstractTestGraph.assertEquals((String)(title + ": size after adding"), (int)(baseSize + 5), (int)g.size());
        g.delete(AbstractTestGraph.triple("x R y"));
        g.delete(AbstractTestGraph.triple("a T b"));
        AbstractTestGraph.assertEquals((String)(title + ": size after deleting"), (int)(baseSize + 3), (int)g.size());
        AbstractTestGraph.assertContainsAll(title + ": modified simple graph", g, "p S q; spindizzies lift cities; Diracs communicate instantaneously");
        AbstractTestGraph.assertOmitsAll(title + ": modified simple graph", g, "x R y; a T b");
        ExtendedIterator it = g.find(Node.ANY, AbstractTestGraph.node("lift"), Node.ANY);
        AbstractTestGraph.assertTrue((String)(title + ": finds some triple(s)"), (boolean)it.hasNext());
        AbstractTestGraph.assertEquals((String)(title + ": finds a 'lift' triple"), (Object)AbstractTestGraph.triple("spindizzies lift cities"), (Object)it.next());
        AbstractTestGraph.assertFalse((String)(title + ": finds exactly one triple"), (boolean)it.hasNext());
        it.close();
    }

    public void testHasTransactions() {
        Graph g = this.getGraph();
        TransactionHandler th = g.getTransactionHandler();
        th.transactionsSupported();
        try {
            th.begin();
        }
        catch (UnsupportedOperationException x) {
            // empty catch block
        }
        try {
            th.abort();
        }
        catch (UnsupportedOperationException x) {
            // empty catch block
        }
        try {
            th.commit();
        }
        catch (UnsupportedOperationException x) {
            // empty catch block
        }
        Command cmd = new Command(){

            public Object execute() {
                return null;
            }
        };
        try {
            th.executeInTransaction(cmd);
        }
        catch (UnsupportedOperationException x) {
            // empty catch block
        }
    }

    public void testExecuteInTransactionCatchesThrowable() {
        Graph g = this.getGraph();
        TransactionHandler th = g.getTransactionHandler();
        if (th.transactionsSupported()) {
            Command cmd = new Command(){

                public Object execute() throws Error {
                    throw new Error();
                }
            };
            try {
                th.executeInTransaction(cmd);
            }
            catch (JenaException x) {
                // empty catch block
            }
        }
    }

    public void testBulkUpdate() {
        Graph g = this.getGraph();
        BulkUpdateHandler bu = g.getBulkUpdateHandler();
        Graph items = AbstractTestGraph.graphWith("pigs might fly; dead can dance");
        int initialSize = g.size();
        bu.add(tripleArray);
        this.testContains(g, tripleArray);
        this.testOmits(g, tripleList);
        bu.add(tripleList);
        this.testContains(g, tripleList);
        this.testContains(g, tripleArray);
        bu.add(tripleSet.iterator());
        this.testContains(g, tripleSet.iterator());
        this.testContains(g, tripleList);
        this.testContains(g, tripleArray);
        bu.add(items);
        this.testContains(g, items);
        this.testContains(g, tripleSet.iterator());
        this.testContains(g, tripleArray);
        this.testContains(g, tripleList);
        bu.delete(tripleArray);
        this.testOmits(g, tripleArray);
        this.testContains(g, tripleList);
        this.testContains(g, tripleSet.iterator());
        this.testContains(g, items);
        bu.delete(tripleSet.iterator());
        this.testOmits(g, tripleSet.iterator());
        this.testOmits(g, tripleArray);
        this.testContains(g, tripleList);
        this.testContains(g, items);
        bu.delete(items);
        this.testOmits(g, tripleSet.iterator());
        this.testOmits(g, tripleArray);
        this.testContains(g, tripleList);
        this.testOmits(g, items);
        bu.delete(tripleList);
        AbstractTestGraph.assertEquals((String)"graph has original size", (int)initialSize, (int)g.size());
    }

    public void testBulkAddWithReification() {
        this.testBulkAddWithReification(false);
        this.testBulkAddWithReification(true);
    }

    public void testBulkAddWithReificationPreamble() {
        Graph g = this.getGraph();
        this.xSPO(g.getReifier());
        AbstractTestGraph.assertFalse((boolean)AbstractTestGraph.getReificationTriples(g.getReifier()).isEmpty());
    }

    public void testBulkAddWithReification(boolean withReifications) {
        Graph graphToUpdate = this.getGraph();
        BulkUpdateHandler bu = graphToUpdate.getBulkUpdateHandler();
        Graph graphToAdd = AbstractTestGraph.graphWith("pigs might fly; dead can dance");
        Reifier updatedReifier = graphToUpdate.getReifier();
        Reifier addedReifier = graphToAdd.getReifier();
        this.xSPOyXYZ(addedReifier);
        bu.add(graphToAdd, withReifications);
        AbstractTestGraph.assertIsomorphic(withReifications ? AbstractTestGraph.getReificationTriples(addedReifier) : AbstractTestGraph.graphWith(""), AbstractTestGraph.getReificationTriples(updatedReifier));
    }

    protected void xSPOyXYZ(Reifier r) {
        this.xSPO(r);
        r.reifyAs(Node.create((String)"y"), Triple.create((String)"X Y Z"));
    }

    protected void aABC(Reifier r) {
        r.reifyAs(Node.create((String)"a"), Triple.create((String)"A B C"));
    }

    protected void xSPO(Reifier r) {
        r.reifyAs(Node.create((String)"x"), Triple.create((String)"S P O"));
    }

    public void testRemove() {
        this.testRemove("?? ?? ??", "?? ?? ??");
        this.testRemove("S ?? ??", "S ?? ??");
        this.testRemove("S ?? ??", "?? P ??");
        this.testRemove("S ?? ??", "?? ?? O");
        this.testRemove("?? P ??", "S ?? ??");
        this.testRemove("?? P ??", "?? P ??");
        this.testRemove("?? P ??", "?? ?? O");
        this.testRemove("?? ?? O", "S ?? ??");
        this.testRemove("?? ?? O", "?? P ??");
        this.testRemove("?? ?? O", "?? ?? O");
    }

    public void testRemove(String findRemove, String findCheck) {
        Graph g = this.getGraphWith("S P O");
        ExtendedIterator it = g.find((TripleMatch)Triple.create((String)findRemove));
        try {
            it.next();
            it.remove();
            it.close();
            AbstractTestGraph.assertEquals((String)("remove with " + findRemove + ":"), (int)0, (int)g.size());
            AbstractTestGraph.assertFalse((boolean)g.contains(Triple.create((String)findCheck)));
        }
        catch (UnsupportedOperationException e) {
            it.close();
            AbstractTestGraph.assertFalse((boolean)g.getCapabilities().iteratorRemoveAllowed());
        }
        it.close();
    }

    public void testBulkRemoveWithReification() {
        this.testBulkUpdateRemoveWithReification(true);
        this.testBulkUpdateRemoveWithReification(false);
    }

    public void testBulkUpdateRemoveWithReification(boolean withReifications) {
        Graph g = this.getGraph();
        BulkUpdateHandler bu = g.getBulkUpdateHandler();
        Graph items = AbstractTestGraph.graphWith("pigs might fly; dead can dance");
        Reifier gr = g.getReifier();
        Reifier ir = items.getReifier();
        this.xSPOyXYZ(ir);
        this.xSPO(gr);
        this.aABC(gr);
        bu.delete(items, withReifications);
        Graph answer = AbstractTestGraph.graphWith("");
        Reifier ar = answer.getReifier();
        if (withReifications) {
            this.aABC(ar);
        } else {
            this.xSPO(ar);
            this.aABC(ar);
        }
        AbstractTestGraph.assertIsomorphic(AbstractTestGraph.getReificationTriples(ar), AbstractTestGraph.getReificationTriples(gr));
    }

    public void testHasCapabilities() {
        Graph g = this.getGraph();
        Capabilities c = g.getCapabilities();
        boolean sa = c.sizeAccurate();
        boolean aaSome = c.addAllowed();
        boolean aaAll = c.addAllowed(true);
        boolean daSome = c.deleteAllowed();
        boolean daAll = c.deleteAllowed(true);
        boolean cbe = c.canBeEmpty();
    }

    public void testFind() {
        Graph g = this.getGraph();
        AbstractTestGraph.graphAdd(g, "S P O");
        AbstractTestGraph.assertDiffer(new HashSet(), g.find(Node.ANY, Node.ANY, Node.ANY).toSet());
        AbstractTestGraph.assertDiffer(new HashSet(), g.find((TripleMatch)Triple.ANY).toSet());
    }

    protected boolean canBeEmpty(Graph g) {
        return g.isEmpty();
    }

    public void testEventRegister() {
        Graph g = this.getGraph();
        GraphEventManager gem = g.getEventManager();
        AbstractTestGraph.assertSame((Object)gem, (Object)gem.register((GraphListener)new RecordingListener()));
    }

    public void testEventUnregister() {
        this.getGraph().getEventManager().unregister((GraphListener)this.L);
    }

    protected Graph getAndRegister(GraphListener gl) {
        Graph g = this.getGraph();
        g.getEventManager().register(gl);
        return g;
    }

    public void testAddTriple() {
        Graph g = this.getAndRegister(this.L);
        g.add(this.SPO);
        this.L.assertHas(new Object[]{"add", g, this.SPO});
    }

    public void testDeleteTriple() {
        Graph g = this.getAndRegister(this.L);
        g.delete(this.SPO);
        this.L.assertHas(new Object[]{"delete", g, this.SPO});
    }

    public void testListSubjects() {
        Set emptySubjects = this.listSubjects(this.getGraphWith(""));
        Graph g = this.getGraphWith("x P y; y Q z");
        AbstractTestGraph.assertEquals((Object)this.nodeSet("x y"), (Object)this.remove(this.listSubjects(g), emptySubjects));
        g.delete(AbstractTestGraph.triple("x P y"));
        AbstractTestGraph.assertEquals((Object)this.nodeSet("y"), (Object)this.remove(this.listSubjects(g), emptySubjects));
    }

    protected Set listSubjects(Graph g) {
        return AbstractTestGraph.iteratorToSet((Iterator)g.queryHandler().subjectsFor(Node.ANY, Node.ANY));
    }

    public void testListPredicates() {
        Set emptyPredicates = this.listPredicates(this.getGraphWith(""));
        Graph g = this.getGraphWith("x P y; y Q z");
        AbstractTestGraph.assertEquals((Object)this.nodeSet("P Q"), (Object)this.remove(this.listPredicates(g), emptyPredicates));
        g.delete(AbstractTestGraph.triple("x P y"));
        AbstractTestGraph.assertEquals((Object)this.nodeSet("Q"), (Object)this.remove(this.listPredicates(g), emptyPredicates));
    }

    protected Set listPredicates(Graph g) {
        return AbstractTestGraph.iteratorToSet((Iterator)g.queryHandler().predicatesFor(Node.ANY, Node.ANY));
    }

    public void testListObjects() {
        Set emptyObjects = this.listObjects(this.getGraphWith(""));
        Graph g = this.getGraphWith("x P y; y Q z");
        AbstractTestGraph.assertEquals((Object)this.nodeSet("y z"), (Object)this.remove(this.listObjects(g), emptyObjects));
        g.delete(AbstractTestGraph.triple("x P y"));
        AbstractTestGraph.assertEquals((Object)this.nodeSet("z"), (Object)this.remove(this.listObjects(g), emptyObjects));
    }

    protected Set listObjects(Graph g) {
        return AbstractTestGraph.iteratorToSet((Iterator)g.queryHandler().objectsFor(Node.ANY, Node.ANY));
    }

    private Set remove(Set A, Set B) {
        HashSet result = new HashSet(A);
        result.removeAll(B);
        return result;
    }

    public void testEventDeleteByFind() {
        Graph g = this.getAndRegister(this.L);
        if (g.getCapabilities().iteratorRemoveAllowed()) {
            Triple toRemove = AbstractTestGraph.triple("remove this triple");
            g.add(toRemove);
            ExtendedIterator rtr = g.find((TripleMatch)toRemove);
            AbstractTestGraph.assertTrue((String)"ensure a(t least) one triple", (boolean)rtr.hasNext());
            rtr.next();
            rtr.remove();
            rtr.close();
            this.L.assertHas(new Object[]{"add", g, toRemove, "delete", g, toRemove});
        }
    }

    public void testTwoListeners() {
        RecordingListener L1 = new RecordingListener();
        RecordingListener L2 = new RecordingListener();
        Graph g = this.getGraph();
        GraphEventManager gem = g.getEventManager();
        gem.register((GraphListener)L1).register((GraphListener)L2);
        g.add(this.SPO);
        L2.assertHas(new Object[]{"add", g, this.SPO});
        L1.assertHas(new Object[]{"add", g, this.SPO});
    }

    public void testUnregisterWorks() {
        Graph g = this.getGraph();
        GraphEventManager gem = g.getEventManager();
        gem.register((GraphListener)this.L).unregister((GraphListener)this.L);
        g.add(this.SPO);
        this.L.assertHas(new Object[0]);
    }

    public void testRegisterTwice() {
        Graph g = this.getAndRegister(this.L);
        g.getEventManager().register((GraphListener)this.L);
        g.add(this.SPO);
        this.L.assertHas(new Object[]{"add", g, this.SPO, "add", g, this.SPO});
    }

    public void testUnregisterOnce() {
        Graph g = this.getAndRegister(this.L);
        g.getEventManager().register((GraphListener)this.L).unregister((GraphListener)this.L);
        g.delete(this.SPO);
        this.L.assertHas(new Object[]{"delete", g, this.SPO});
    }

    public void testBulkAddArrayEvent() {
        Graph g = this.getAndRegister(this.L);
        Triple[] triples = AbstractTestGraph.tripleArray("x R y; a P b");
        g.getBulkUpdateHandler().add(triples);
        this.L.assertHas(new Object[]{"add[]", g, triples});
    }

    public void testBulkAddList() {
        Graph g = this.getAndRegister(this.L);
        List<Triple> elems = Arrays.asList(AbstractTestGraph.tripleArray("bells ring loudly; pigs might fly"));
        g.getBulkUpdateHandler().add(elems);
        this.L.assertHas(new Object[]{"addList", g, elems});
    }

    public void testBulkDeleteArray() {
        Graph g = this.getAndRegister(this.L);
        Triple[] triples = AbstractTestGraph.tripleArray("x R y; a P b");
        g.getBulkUpdateHandler().delete(triples);
        this.L.assertHas(new Object[]{"delete[]", g, triples});
    }

    public void testBulkDeleteList() {
        Graph g = this.getAndRegister(this.L);
        List<Triple> elems = Arrays.asList(AbstractTestGraph.tripleArray("bells ring loudly; pigs might fly"));
        g.getBulkUpdateHandler().delete(elems);
        this.L.assertHas(new Object[]{"deleteList", g, elems});
    }

    public void testBulkAddIterator() {
        Graph g = this.getAndRegister(this.L);
        Triple[] triples = AbstractTestGraph.tripleArray("I wrote this; you read that; I wrote this");
        g.getBulkUpdateHandler().add(this.asIterator(triples));
        this.L.assertHas(new Object[]{"addIterator", g, Arrays.asList(triples)});
    }

    public void testBulkDeleteIterator() {
        Graph g = this.getAndRegister(this.L);
        Triple[] triples = AbstractTestGraph.tripleArray("I wrote this; you read that; I wrote this");
        g.getBulkUpdateHandler().delete(this.asIterator(triples));
        this.L.assertHas(new Object[]{"deleteIterator", g, Arrays.asList(triples)});
    }

    public Iterator asIterator(Triple[] triples) {
        return Arrays.asList(triples).iterator();
    }

    public void testBulkAddGraph() {
        Graph g = this.getAndRegister(this.L);
        Graph triples = AbstractTestGraph.graphWith("this type graph; I type slowly");
        g.getBulkUpdateHandler().add(triples);
        this.L.assertHas(new Object[]{"addGraph", g, triples});
    }

    public void testBulkDeleteGraph() {
        Graph g = this.getAndRegister(this.L);
        Graph triples = AbstractTestGraph.graphWith("this type graph; I type slowly");
        g.getBulkUpdateHandler().delete(triples);
        this.L.assertHas(new Object[]{"deleteGraph", g, triples});
    }

    public void testGeneralEvent() {
        Graph g = this.getAndRegister(this.L);
        int[] value = new int[]{};
        g.getEventManager().notifyEvent(g, (Object)value);
        this.L.assertHas(new Object[]{"someEvent", g, value});
    }

    public void testRemoveAllEvent() {
        Graph g = this.getAndRegister(this.L);
        g.getBulkUpdateHandler().removeAll();
        this.L.assertHas(new Object[]{"someEvent", g, GraphEvents.removeAll});
    }

    public void testRemoveSomeEvent() {
        Graph g = this.getAndRegister(this.L);
        Node S = AbstractTestGraph.node("S");
        Node P = AbstractTestGraph.node("?P");
        Node O = AbstractTestGraph.node("??");
        g.getBulkUpdateHandler().remove(S, P, O);
        Object event = GraphEvents.remove((Node)S, (Node)P, (Node)O);
        this.L.assertHas(new Object[]{"someEvent", g, event});
    }

    public void testContainsNode() {
        Graph g = this.getGraph();
        AbstractTestGraph.graphAdd(g, "a P b; _c _Q _d; a 11 12");
        QueryHandler qh = g.queryHandler();
        AbstractTestGraph.assertTrue((boolean)qh.containsNode(AbstractTestGraph.node("a")));
        AbstractTestGraph.assertTrue((boolean)qh.containsNode(AbstractTestGraph.node("P")));
        AbstractTestGraph.assertTrue((boolean)qh.containsNode(AbstractTestGraph.node("b")));
        AbstractTestGraph.assertTrue((boolean)qh.containsNode(AbstractTestGraph.node("_c")));
        AbstractTestGraph.assertTrue((boolean)qh.containsNode(AbstractTestGraph.node("_Q")));
        AbstractTestGraph.assertTrue((boolean)qh.containsNode(AbstractTestGraph.node("_d")));
        AbstractTestGraph.assertTrue((boolean)qh.containsNode(AbstractTestGraph.node("11")));
        AbstractTestGraph.assertTrue((boolean)qh.containsNode(AbstractTestGraph.node("12")));
        AbstractTestGraph.assertFalse((boolean)qh.containsNode(AbstractTestGraph.node("x")));
        AbstractTestGraph.assertFalse((boolean)qh.containsNode(AbstractTestGraph.node("_y")));
        AbstractTestGraph.assertFalse((boolean)qh.containsNode(AbstractTestGraph.node("99")));
    }

    public void testSubjectsFor() {
        Graph g = this.getGraphWith("a P b; a Q c; a P d; b P x; c Q y");
        this.testSameSubjects(g, Node.ANY, Node.ANY);
        this.testSameSubjects(g, AbstractTestGraph.node("P"), Node.ANY);
        this.testSameSubjects(g, AbstractTestGraph.node("Q"), AbstractTestGraph.node("c"));
    }

    protected void testSameSubjects(Graph g, Node p, Node o) {
        Set bis = AbstractTestGraph.iteratorToSet((Iterator)SimpleQueryHandler.subjectsFor((Graph)g, (Node)p, (Node)o));
        Set qhs = AbstractTestGraph.iteratorToSet((Iterator)g.queryHandler().subjectsFor(p, o));
        AbstractTestGraph.assertEquals((Object)bis, (Object)qhs);
    }

    public void testListSubjectsNoRemove() {
        Graph g = this.getGraphWith("a P b; b Q c; c R a");
        ExtendedIterator it = g.queryHandler().subjectsFor(Node.ANY, Node.ANY);
        it.next();
        try {
            it.remove();
            AbstractTestGraph.fail((String)("listSubjects for " + g.getClass() + " should not support .remove()"));
        }
        catch (UnsupportedOperationException e) {
            AbstractTestGraph.pass();
        }
    }

    public void testObjectsFor() {
        Graph g = this.getGraphWith("b P a; c Q a; d P a; x P b; y Q c");
        this.testSameObjects(g, Node.ANY, Node.ANY);
        this.testSameObjects(g, AbstractTestGraph.node("P"), Node.ANY);
        this.testSameObjects(g, AbstractTestGraph.node("Q"), AbstractTestGraph.node("c"));
    }

    protected void testSameObjects(Graph g, Node s, Node p) {
        Set bis = AbstractTestGraph.iteratorToSet((Iterator)SimpleQueryHandler.objectsFor((Graph)g, (Node)s, (Node)p));
        Set qhs = AbstractTestGraph.iteratorToSet((Iterator)g.queryHandler().objectsFor(s, p));
        AbstractTestGraph.assertEquals((Object)bis, (Object)qhs);
    }

    public void testListObjectsNoRemove() {
        Graph g = this.getGraphWith("a P b; b Q c; c R a");
        ExtendedIterator it = g.queryHandler().objectsFor(Node.ANY, Node.ANY);
        it.next();
        try {
            it.remove();
            AbstractTestGraph.fail((String)("listObjects for " + g.getClass() + " should not support .remove()"));
        }
        catch (UnsupportedOperationException e) {
            AbstractTestGraph.pass();
        }
    }

    public void testListObjectNoDuplicates() {
        Graph g = this.getGraphWith("a P 1; b P 1");
        int count = 0;
        Node one = AbstractTestGraph.node("1");
        ExtendedIterator it = g.queryHandler().objectsFor(Node.ANY, Node.ANY);
        while (it.hasNext()) {
            if (!it.next().equals(one)) continue;
            ++count;
        }
        AbstractTestGraph.assertEquals((int)1, (int)count);
    }

    public void testPredicatesFor() {
        Graph g = this.getGraphWith("a P b; c Q d; e R f; g P b; h Q i");
        this.testSamePredicates(g, Node.ANY, Node.ANY);
        this.testSamePredicates(g, Node.ANY, AbstractTestGraph.node("b"));
        this.testSamePredicates(g, AbstractTestGraph.node("g"), Node.ANY);
        this.testSamePredicates(g, AbstractTestGraph.node("e"), AbstractTestGraph.node("f"));
    }

    protected void testSamePredicates(Graph g, Node s, Node o) {
        Set bis = AbstractTestGraph.iteratorToSet((Iterator)SimpleQueryHandler.predicatesFor((Graph)g, (Node)s, (Node)o));
        Set qhs = AbstractTestGraph.iteratorToSet((Iterator)g.queryHandler().predicatesFor(s, o));
        AbstractTestGraph.assertEquals((Object)bis, (Object)qhs);
    }

    public void testListPredicatesNoRemove() {
        Graph g = this.getGraphWith("a P b; b Q c; c R a");
        ExtendedIterator it = g.queryHandler().predicatesFor(Node.ANY, Node.ANY);
        it.next();
        try {
            it.remove();
            AbstractTestGraph.fail((String)("listPredicates for " + g.getClass() + " should not support .remove()"));
        }
        catch (UnsupportedOperationException e) {
            AbstractTestGraph.pass();
        }
    }

    public void testRemoveAll() {
        this.testRemoveAll("");
        this.testRemoveAll("a R b");
        this.testRemoveAll("c S d; e:ff GGG hhhh; _i J 27; Ell Em 'en'");
    }

    public void testRemoveAll(String triples) {
        Graph g = this.getGraph();
        AbstractTestGraph.graphAdd(g, triples);
        g.getBulkUpdateHandler().removeAll();
        AbstractTestGraph.assertTrue((boolean)g.isEmpty());
    }

    public void testRemoveSPO() {
        for (int i = 0; i < this.cases.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                Graph content = this.getGraph();
                Graph baseContent = this.copy(content);
                AbstractTestGraph.graphAdd(content, this.cases[i][0]);
                Triple remove = AbstractTestGraph.triple(this.cases[i][1]);
                Graph expected = AbstractTestGraph.graphWith(this.cases[i][2]);
                content.getBulkUpdateHandler().remove(remove.getSubject(), remove.getPredicate(), remove.getObject());
                Graph finalContent = this.remove(this.copy(content), baseContent);
                AbstractTestGraph.assertIsomorphic(this.cases[i][1], expected, finalContent);
            }
        }
    }

    protected void add(Graph toUpdate, Graph toAdd) {
        toUpdate.getBulkUpdateHandler().add(toAdd);
    }

    protected Graph remove(Graph toUpdate, Graph toRemove) {
        toUpdate.getBulkUpdateHandler().delete(toRemove);
        return toUpdate;
    }

    protected Graph copy(Graph g) {
        Graph result = Factory.createDefaultGraph();
        result.getBulkUpdateHandler().add(g);
        return result;
    }

    protected Graph getClosed() {
        Graph result = this.getGraph();
        result.close();
        return result;
    }
}

