/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestFindLiterals
extends GraphTestBase {
    static final Map1 getObject = new Map1(){

        public Object map1(Object o) {
            return ((Triple)o).getObject();
        }
    };

    public TestFindLiterals(String name) {
        super(name);
    }

    public static TestFindLiterals aTest(final String graph, final String size, final String search, final String results) {
        return new TestFindLiterals("TestFindLiterals: graph {" + graph + "} size " + size + " search " + search + " expecting {" + results + "}"){

            public void runBare() {
                Graph g = 2.graphWith(graph);
                int n = Integer.parseInt(size);
                Node literal = Node.create((String)search);
                2.assertEquals((String)"graph has wrong size", (int)n, (int)g.size());
                Set got = 2.iteratorToSet((Iterator)g.find(Node.ANY, Node.ANY, literal).mapWith(getObject));
                2.assertEquals((Object)this.nodeSet(results), (Object)got);
            }
        };
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite(TestFindLiterals.class);
        result.addTest((Test)TestFindLiterals.aTest("a P 'simple'", "1", "'simple'", "'simple'"));
        result.addTest((Test)TestFindLiterals.aTest("a P 'simple'xsd:string", "1", "'simple'", "'simple'xsd:string"));
        result.addTest((Test)TestFindLiterals.aTest("a P 'simple'", "1", "'simple'xsd:string", "'simple'"));
        result.addTest((Test)TestFindLiterals.aTest("a P 'simple'xsd:string", "1", "'simple'xsd:string", "'simple'xsd:string"));
        result.addTest((Test)TestFindLiterals.aTest("a P 'simple'; a P 'simple'xsd:string", "2", "'simple'", "'simple' 'simple'xsd:string"));
        result.addTest((Test)TestFindLiterals.aTest("a P 'simple'; a P 'simple'xsd:string", "2", "'simple'xsd:string", "'simple' 'simple'xsd:string"));
        result.addTest((Test)TestFindLiterals.aTest("a P 1", "1", "1", "1"));
        result.addTest((Test)TestFindLiterals.aTest("a P '1'xsd:float", "1", "'1'xsd:float", "'1'xsd:float"));
        result.addTest((Test)TestFindLiterals.aTest("a P '1'xsd:double", "1", "'1'xsd:double", "'1'xsd:double"));
        result.addTest((Test)TestFindLiterals.aTest("a P '1'xsd:float", "1", "'1'xsd:float", "'1'xsd:float"));
        result.addTest((Test)TestFindLiterals.aTest("a P '1.1'xsd:float", "1", "'1'xsd:float", ""));
        result.addTest((Test)TestFindLiterals.aTest("a P '1'xsd:double", "1", "'1'xsd:int", ""));
        result.addTest((Test)TestFindLiterals.aTest("a P 'abc'rdf:XMLLiteral", "1", "'abc'", ""));
        result.addTest((Test)TestFindLiterals.aTest("a P 'abc'", "1", "'abc'rdf:XMLLiteral", ""));
        result.addTest((Test)TestFindLiterals.aTest("a P '1'xsd:float", "1", "'1'xsd:double", ""));
        result.addTest((Test)TestFindLiterals.aTest("a P '1'xsd:double", "1", "'1'xsd:float", ""));
        result.addTest((Test)TestFindLiterals.aTest("a P 1", "1", "'1'", ""));
        result.addTest((Test)TestFindLiterals.aTest("a P 1", "1", "'1'xsd:integer", "'1'xsd:integer"));
        result.addTest((Test)TestFindLiterals.aTest("a P 1", "1", "'1'", ""));
        result.addTest((Test)TestFindLiterals.aTest("a P '1'xsd:short", "1", "'1'xsd:integer", "'1'xsd:short"));
        result.addTest((Test)TestFindLiterals.aTest("a P '1'xsd:int", "1", "'1'xsd:integer", "'1'xsd:int"));
        return result;
    }

    public void testFloatVsDouble() {
        Node A = Node.create((String)"'1'xsd:float");
        Node B = Node.create((String)"'1'xsd:double");
        TestFindLiterals.assertFalse((boolean)A.equals((Object)B));
        TestFindLiterals.assertFalse((boolean)A.sameValueAs((Object)B));
        TestFindLiterals.assertFalse((boolean)B.sameValueAs((Object)A));
        TestFindLiterals.assertFalse((boolean)A.matches(B));
        TestFindLiterals.assertFalse((boolean)B.matches(A));
    }

    public void testProgrammaticValues() {
        Node ab = Node.createLiteral((LiteralLabel)new LiteralLabel((Object)new Byte(42)));
        Node as = Node.createLiteral((LiteralLabel)new LiteralLabel((Object)new Short(42)));
        Node ai = Node.createLiteral((LiteralLabel)new LiteralLabel((Object)new Integer(42)));
        Node al = Node.createLiteral((LiteralLabel)new LiteralLabel((Object)new Long(42L)));
        Graph g = TestFindLiterals.graphWith("");
        Node SB = Node.create((String)"SB");
        Node SS = Node.create((String)"SS");
        Node SI = Node.create((String)"SI");
        Node SL = Node.create((String)"SL");
        Node P = Node.create((String)"P");
        g.add(Triple.create((Node)SB, (Node)P, (Node)ab));
        g.add(Triple.create((Node)SS, (Node)P, (Node)as));
        g.add(Triple.create((Node)SI, (Node)P, (Node)ai));
        g.add(Triple.create((Node)SL, (Node)P, (Node)al));
        TestFindLiterals.assertEquals((int)4, (int)TestFindLiterals.iteratorToSet((Iterator)g.find(Node.ANY, P, Node.create((String)"42"))).size());
    }
}

