/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.faster.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.test.AbstractTestGraph;
import com.hp.hpl.jena.mem.faster.GraphMemFaster;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import junit.framework.TestSuite;

public class TestFasterGraphMem
extends AbstractTestGraph {
    public TestFasterGraphMem(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFasterGraphMem.class);
    }

    public Graph getGraph() {
        return new GraphMemFaster();
    }

    public void testRemoveAllDoesntUseFind() {
        GraphMemWithoutFind g = new GraphMemWithoutFind();
        TestFasterGraphMem.graphAdd((Graph)g, "x P y; a Q b");
        g.getBulkUpdateHandler().removeAll();
        TestFasterGraphMem.assertEquals((int)0, (int)g.size());
    }

    public void testSizeAfterRemove() {
        Graph g = this.getGraphWith("x p y");
        ExtendedIterator it = g.find((TripleMatch)TestFasterGraphMem.triple("x ?? ??"));
        it.removeNext();
        TestFasterGraphMem.assertEquals((int)0, (int)g.size());
    }

    public void testContainsConcreteDoesntUseFind() {
        GraphMemWithoutFind g = new GraphMemWithoutFind();
        TestFasterGraphMem.graphAdd((Graph)g, "x P y; a Q b");
        TestFasterGraphMem.assertTrue((boolean)g.contains(TestFasterGraphMem.triple("x P y")));
        TestFasterGraphMem.assertTrue((boolean)g.contains(TestFasterGraphMem.triple("a Q b")));
        TestFasterGraphMem.assertFalse((boolean)g.contains(TestFasterGraphMem.triple("a P y")));
        TestFasterGraphMem.assertFalse((boolean)g.contains(TestFasterGraphMem.triple("y R b")));
    }

    protected final class GraphMemWithoutFind
    extends GraphMemFaster {
        protected GraphMemWithoutFind() {
        }

        public ExtendedIterator graphBaseFind(TripleMatch t) {
            throw new JenaException("find is Not Allowed");
        }
    }
}

