/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.spec.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import com.hp.hpl.jena.rdf.model.ModelMakerCreatorRegistry;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.ModelSpecCreatorRegistry;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.impl.PlainModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.rdf.model.test.TestModelFactory;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.shared.BadDescriptionException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

public class TestModelSpec
extends ModelTestBase {
    public TestModelSpec(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpec.class);
    }

    public void testNotFindMaker() {
        Resource type = TestModelSpec.resource("jms:xyz");
        TestModelSpec.assertSame(null, (Object)ModelMakerCreatorRegistry.findCreator((Resource)type));
    }

    public void testFindMakerChoice() {
        Resource type1 = TestModelSpec.resource("jms:type1");
        Resource type2 = TestModelSpec.resource("jms:type2");
        ModelMakerCreator mmc1 = new ModelMakerCreator(){

            public ModelMaker create(Model desc, Resource root) {
                return null;
            }
        };
        ModelMakerCreator mmc2 = new ModelMakerCreator(){

            public ModelMaker create(Model desc, Resource root) {
                return null;
            }
        };
        ModelMakerCreatorRegistry.register((Resource)type1, (ModelMakerCreator)mmc1);
        ModelMakerCreatorRegistry.register((Resource)type2, (ModelMakerCreator)mmc2);
        TestModelSpec.assertSame((Object)mmc1, (Object)ModelMakerCreatorRegistry.findCreator((Resource)type1));
        TestModelSpec.assertSame((Object)mmc2, (Object)ModelMakerCreatorRegistry.findCreator((Resource)type2));
    }

    public void testFindStandardMakers() {
        TestModelSpec.assertNotNull((Object)ModelMakerCreatorRegistry.findCreator((Resource)JenaModelSpec.FileMakerSpec));
        TestModelSpec.assertNotNull((Object)ModelMakerCreatorRegistry.findCreator((Resource)JenaModelSpec.MemMakerSpec));
        TestModelSpec.assertNotNull((Object)ModelMakerCreatorRegistry.findCreator((Resource)JenaModelSpec.RDBMakerSpec));
    }

    public void testDefaultMaker() {
        Model spec = TestModelSpec.modelWithStatements("_x jms:maker _y; _y jms:reificationMode jms:rsMinimal");
        ModelSpec ms = ModelFactory.createSpec((Model)spec);
        Model m = ModelFactory.createModel((ModelSpec)ms);
        TestModelSpec.assertInstanceOf(GraphMemBase.class, m.getGraph());
    }

    public void testAbsentDefaultMaker() {
        Model spec = TestModelSpec.modelWithStatements("_x rdf:type jms:DefaultModelSpec");
        ModelSpec ms = ModelFactory.createSpec((Model)spec);
        Model m = ModelFactory.createModel((ModelSpec)ms);
        TestModelSpec.assertInstanceOf(GraphMemBase.class, m.getGraph());
    }

    public void testNotFindCreator() {
        Resource type = TestModelSpec.resource("jms:SomeType");
        TestModelSpec.assertSame(null, (Object)ModelSpecCreatorRegistry.findCreator((Resource)type));
    }

    public void testFindCreator() {
        Resource type = TestModelSpec.resource("jms:SomeType");
        ModelSpecCreator c = new ModelSpecCreator(){

            public ModelSpec create(Resource root, Model m) {
                return null;
            }
        };
        ModelSpecCreatorRegistry.register((Resource)type, (ModelSpecCreator)c);
        TestModelSpec.assertSame((Object)c, (Object)ModelSpecCreatorRegistry.findCreator((Resource)type));
    }

    public void testFindCreatorChoice() {
        Resource type1 = TestModelSpec.resource("jms:SomeType1");
        Resource type2 = TestModelSpec.resource("jms:SomeType2");
        ModelSpecCreator c1 = new ModelSpecCreator(){

            public ModelSpec create(Resource root, Model m) {
                return null;
            }
        };
        ModelSpecCreator c2 = new ModelSpecCreator(){

            public ModelSpec create(Resource root, Model m) {
                return null;
            }
        };
        ModelSpecCreatorRegistry.register((Resource)type1, (ModelSpecCreator)c1);
        ModelSpecCreatorRegistry.register((Resource)type2, (ModelSpecCreator)c2);
        TestModelSpec.assertSame((Object)c1, (Object)ModelSpecCreatorRegistry.findCreator((Resource)type1));
        TestModelSpec.assertSame((Object)c2, (Object)ModelSpecCreatorRegistry.findCreator((Resource)type2));
    }

    public void testHasStandardCreators() {
        TestModelSpec.assertNotNull((Object)ModelSpecCreatorRegistry.findCreator((Resource)JenaModelSpec.InfModelSpec));
        TestModelSpec.assertNotNull((Object)ModelSpecCreatorRegistry.findCreator((Resource)JenaModelSpec.PlainModelSpec));
        TestModelSpec.assertNotNull((Object)ModelSpecCreatorRegistry.findCreator((Resource)JenaModelSpec.OntModelSpec));
    }

    public void testNamedCreatePlain() {
        ModelSpec ms = ModelSpecFactory.createSpec((Model)TestModelSpec.createPlainModelDesc());
        Model m = ms.createModelOver("aName");
        TestModelSpec.assertInstanceOf(GraphMemBase.class, m.getGraph());
    }

    public void testNamedCreateInf() {
        String URI2 = "http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory";
        ModelSpec ms = ModelSpecFactory.createSpec((Model)TestModelSpec.createInfModelDesc(URI2));
        Model m = ms.createModelOver("iName");
        TestModelSpec.assertInstanceOf(InfGraph.class, m.getGraph());
    }

    public void testDetectRootAmbiguity() {
        Model desc = TestModelSpec.createPlainModelDesc().add(TestModelSpec.createPlainModelDesc());
        try {
            ModelSpecFactory.createSpec((Model)desc);
            TestModelSpec.fail((String)"must trap ambiguous description");
        }
        catch (BadDescriptionException b) {
            TestModelSpec.pass();
        }
    }

    public void testCreateByName() {
        Resource plain = TestModelSpec.resource();
        Model desc = TestModelSpec.createPlainModelDesc(plain);
        ModelSpec ms = ModelSpecFactory.createSpec((Model)ModelSpecFactory.withSchema((Model)desc), (Resource)plain);
        TestModelSpec.assertInstanceOf(GraphMemBase.class, ms.createFreshModel().getGraph());
    }

    public void testCreateByNameChoice() {
        Resource plain = TestModelSpec.resource();
        Resource inf = TestModelSpec.resource();
        String URI2 = "http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory";
        Model desc = TestModelSpec.createPlainModelDesc(plain).add(TestModelSpec.createInfModelDesc(inf, URI2));
        ModelSpec ms = ModelSpecFactory.createSpec((Model)ModelSpecFactory.withSchema((Model)desc), (Resource)plain);
        TestModelSpec.assertInstanceOf(GraphMemBase.class, ms.createFreshModel().getGraph());
    }

    public void testOntModeSpecIsaModelSpec() {
        TestModelSpec.assertInstanceOf(ModelSpec.class, OntModelSpec.DAML_MEM_RULE_INF);
    }

    public void testOntModelSpecCreatesOntModels() {
        Model m = OntModelSpec.DAML_MEM_RULE_INF.createFreshModel();
        TestModelSpec.assertInstanceOf(OntModel.class, m);
    }

    public void testOntModelSpecDescription() {
        OntModelSpec oms = OntModelSpec.DAML_MEM_RULE_INF;
        Model d = oms.getDescription();
        TestModelSpec.assertTrue((String)"", (boolean)d.contains(null, JenaModelSpec.ontLanguage, (RDFNode)TestModelFactory.DAMLLangResource));
        StmtIterator si = d.listStatements(null, JenaModelSpec.docManager, (RDFNode)null);
        Resource manager = si.nextStatement().getResource();
        TestModelSpec.assertSame((Object)oms.getDocumentManager(), (Object)ModelSpecImpl.getValue((RDFNode)manager));
    }

    public void testOntModelSpecMaker() {
        OntModelSpec oms = OntModelSpec.DAML_MEM_RULE_INF;
        Model d = oms.getDescription();
        Statement s = d.getRequiredProperty(null, JenaModelSpec.importMaker);
        Model makerSpec = oms.getImportModelMaker().getDescription();
        TestModelSpec.assertNotNull((Object)s);
        TestModelSpec.assertIsoModels(makerSpec, this.subModel(d, s.getObject()));
    }

    public void testOntModelReasoner() {
        OntModelSpec oms = OntModelSpec.DAML_MEM_RULE_INF;
        Model d = oms.getDescription();
        Resource reasonerURI = d.createResource(oms.getReasonerFactory().getURI());
        Statement s = d.getRequiredProperty(null, JenaModelSpec.reasonsWith);
        Model reasonerSpec = ModelFactory.createDefaultModel().add(d.createResource(), JenaModelSpec.reasoner, (RDFNode)reasonerURI);
        TestModelSpec.assertIsoModels(reasonerSpec, this.subModel(d, s.getObject()));
    }

    public Model subModel(Model m, RDFNode root) {
        Model result = ModelFactory.createDefaultModel();
        if (root instanceof Resource) {
            result.add(m.listStatements((Resource)root, null, (RDFNode)null));
        }
        return result;
    }

    public void testCreateOntSpec() {
        OntModelSpec oms = OntModelSpec.OWL_MEM_RULE_INF;
        Model spec = ModelFactory.createDefaultModel();
        Resource lang = spec.createResource(oms.getLanguage());
        Resource me = TestModelSpec.resource();
        Resource factory = spec.createResource(oms.getReasonerFactory().getURI());
        spec.add(me, JenaModelSpec.ontLanguage, (RDFNode)lang);
        Resource r = spec.createResource();
        spec.add(r, JenaModelSpec.reasoner, (RDFNode)factory);
        spec.add(me, JenaModelSpec.reasonsWith, (RDFNode)r);
        Resource m = spec.createResource();
        Model modelMaker = ModelFactory.createDefaultModel();
        modelMaker.add(m, RDF.type, (RDFNode)JenaModelSpec.MemMakerSpec);
        modelMaker.add(m, JenaModelSpec.reificationMode, (RDFNode)JenaModelSpec.rsStandard);
        spec.add(me, JenaModelSpec.importMaker, (RDFNode)m);
        spec.add(modelMaker);
        OntDocumentManager odm = oms.getDocumentManager();
        Resource dm = ModelSpecImpl.createValue((Object)odm);
        spec.add(me, JenaModelSpec.docManager, (RDFNode)dm);
        OntModelSpec ms = new OntModelSpec(spec);
        TestModelSpec.assertEquals((String)lang.getURI(), (String)ms.getLanguage());
        TestModelSpec.assertEquals((String)factory.getURI(), (String)ms.getReasonerFactory().getURI());
        TestModelSpec.assertIsoModels(modelMaker, ms.getImportModelMaker().getDescription());
        TestModelSpec.assertSame((Object)odm, (Object)ms.getDocumentManager());
    }

    public void testCreateOntSpecWithoutMaker() {
        OntModelSpec oms = OntModelSpec.OWL_MEM_RULE_INF;
        Model spec = ModelFactory.createDefaultModel();
        Resource lang = spec.createResource(oms.getLanguage());
        Resource me = TestModelSpec.resource();
        Resource factory = spec.createResource(oms.getReasonerFactory().getURI());
        spec.add(me, JenaModelSpec.ontLanguage, (RDFNode)lang);
        Resource r = spec.createResource();
        spec.add(r, JenaModelSpec.reasoner, (RDFNode)factory);
        spec.add(me, JenaModelSpec.reasonsWith, (RDFNode)r);
        OntDocumentManager odm = oms.getDocumentManager();
        Resource dm = ModelSpecImpl.createValue((Object)odm);
        spec.add(me, JenaModelSpec.docManager, (RDFNode)dm);
        OntModelSpec ms = new OntModelSpec(spec);
        TestModelSpec.assertEquals((String)lang.getURI(), (String)ms.getLanguage());
        TestModelSpec.assertEquals((String)factory.getURI(), (String)ms.getReasonerFactory().getURI());
        TestModelSpec.assertSame((Object)odm, (Object)ms.getDocumentManager());
    }

    public void testCreateOntSpecWithoutDocmanager() {
        OntModelSpec oms = OntModelSpec.OWL_MEM_RULE_INF;
        Model spec = ModelFactory.createDefaultModel();
        Resource lang = spec.createResource(oms.getLanguage());
        Resource me = TestModelSpec.resource();
        Resource factory = spec.createResource(oms.getReasonerFactory().getURI());
        spec.add(me, JenaModelSpec.ontLanguage, (RDFNode)lang);
        Resource r = spec.createResource();
        spec.add(r, JenaModelSpec.reasoner, (RDFNode)factory);
        spec.add(me, JenaModelSpec.reasonsWith, (RDFNode)r);
        Resource m = spec.createResource();
        Model modelMaker = ModelFactory.createDefaultModel();
        modelMaker.add(m, RDF.type, (RDFNode)JenaModelSpec.MemMakerSpec);
        modelMaker.add(m, JenaModelSpec.reificationMode, (RDFNode)JenaModelSpec.rsStandard);
        spec.add(me, JenaModelSpec.importMaker, (RDFNode)m);
        spec.add(modelMaker);
        OntModelSpec ms = new OntModelSpec(spec);
        TestModelSpec.assertEquals((String)lang.getURI(), (String)ms.getLanguage());
        TestModelSpec.assertEquals((String)factory.getURI(), (String)ms.getReasonerFactory().getURI());
        TestModelSpec.assertIsoModels(modelMaker, ms.getImportModelMaker().getDescription());
    }

    public void testCreateOntSpecWithoutReasoner() {
        OntModelSpec oms = OntModelSpec.OWL_MEM_RULE_INF;
        Model spec = ModelFactory.createDefaultModel();
        Resource lang = spec.createResource(oms.getLanguage());
        Resource me = TestModelSpec.resource();
        spec.add(me, JenaModelSpec.ontLanguage, (RDFNode)lang);
        Resource m = spec.createResource();
        Model modelMaker = ModelFactory.createDefaultModel();
        modelMaker.add(m, RDF.type, (RDFNode)JenaModelSpec.MemMakerSpec);
        modelMaker.add(m, JenaModelSpec.reificationMode, (RDFNode)JenaModelSpec.rsStandard);
        spec.add(me, JenaModelSpec.importMaker, (RDFNode)m);
        spec.add(modelMaker);
        OntDocumentManager odm = oms.getDocumentManager();
        Resource dm = ModelSpecImpl.createValue((Object)odm);
        spec.add(me, JenaModelSpec.docManager, (RDFNode)dm);
        OntModelSpec ms = new OntModelSpec(spec);
        TestModelSpec.assertEquals((String)lang.getURI(), (String)ms.getLanguage());
        TestModelSpec.assertIsoModels(modelMaker, ms.getImportModelMaker().getDescription());
        TestModelSpec.assertSame((Object)odm, (Object)ms.getDocumentManager());
    }

    public void testOntModelSpecWithModelName() {
        final ArrayList record = new ArrayList();
        ModelMakerImpl tracker = new ModelMakerImpl((GraphMaker)new SimpleGraphMaker()){

            public Model createModel(String name, boolean strict) {
                record.add(name);
                return super.createModel(name, strict);
            }
        };
        Model x = TestModelSpec.modelWithStatements("_this jms:ontLanguage http://www.w3.org/TR/owl-features/#term_OWLLite; _this jms:modelName 'cranberry'; _this jms:docManager _DM; _this jms:reasonsWith _R; _R jms:reasoner http://jena.hpl.hp.com/2003/RDFSExptRuleReasoner");
        OntModelSpec s = (OntModelSpec)ModelSpecFactory.createSpec((Model)x);
        s.setBaseModelMaker((ModelMaker)tracker);
        Model m = s.createFreshModel();
        TestModelSpec.assertEquals((Object)this.list("cranberry"), record);
    }

    protected List list(String element) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(element);
        return result;
    }

    public void testCreateFailingMaker() {
        try {
            ModelSpecImpl.createMaker((Model)TestModelSpec.modelWithStatements(""));
            TestModelSpec.fail((String)"should generate BadDescriptionException");
        }
        catch (BadDescriptionException e) {
            TestModelSpec.pass();
        }
    }

    public void testCreateMemModelMaker() {
        Resource mem = JenaModelSpec.MemMakerSpec;
        this.testCreateModelMaker(JenaModelSpec.rsStandard, mem, SimpleGraphMaker.class);
        this.testCreateModelMaker(JenaModelSpec.rsMinimal, mem, SimpleGraphMaker.class);
        this.testCreateModelMaker(JenaModelSpec.rsConvenient, mem, SimpleGraphMaker.class);
    }

    public void testCreateFileModelMaker() {
        Resource file = JenaModelSpec.FileMakerSpec;
        this.testCreateModelMaker(JenaModelSpec.rsStandard, file, FileGraphMaker.class);
        this.testCreateModelMaker(JenaModelSpec.rsMinimal, file, FileGraphMaker.class);
        this.testCreateModelMaker(JenaModelSpec.rsConvenient, file, FileGraphMaker.class);
    }

    public void testCreateFileModelMakerRooted() {
        String fileBase = "/somewhere";
        Resource me = TestModelSpec.resource();
        Model spec = ModelFactory.createDefaultModel().add(me, RDF.type, (RDFNode)JenaModelSpec.FileMakerSpec).add(me, JenaModelSpec.fileBase, fileBase);
        ModelMaker maker = ModelSpecImpl.createMaker((Model)spec);
        FileGraphMaker fgm = (FileGraphMaker)maker.getGraphMaker();
        TestModelSpec.assertEquals((String)fileBase, (String)fgm.getFileBase());
        Model desc = ModelFactory.createModelForGraph((Graph)fgm.getDescription());
        TestModelSpec.assertTrue((boolean)desc.listStatements(null, JenaModelSpec.fileBase, fileBase).hasNext());
    }

    public void testCreateModelMaker(Resource style, Resource cl, Class required) {
        Resource me = TestModelSpec.resource();
        ReificationStyle wanted = JenaModelSpec.findStyle((RDFNode)style);
        Model spec = TestModelSpec.modelWithStatements("").add(me, RDF.type, (RDFNode)cl).add(me, JenaModelSpec.reificationMode, (RDFNode)style);
        ModelMaker maker = ModelSpecImpl.createMaker((Model)spec);
        TestModelSpec.assertTrue((boolean)required.isInstance(maker.getGraphMaker()));
        TestModelSpec.assertEquals((Object)wanted, (Object)maker.getGraphMaker().getReificationStyle());
    }

    public void testCreatePlainMemModel() {
        Resource me = TestModelSpec.resource();
        Model spec = TestModelSpec.createPlainModelDesc(me);
        PlainModelSpec pms = new PlainModelSpec(me, spec);
        ModelMaker mm = pms.getModelMaker();
        Model desc = mm.getDescription(me);
        TestModelSpec.assertTrue((boolean)desc.contains(me, RDF.type, (RDFNode)JenaModelSpec.MemMakerSpec));
        TestModelSpec.assertTrue((boolean)desc.listStatements(null, JenaModelSpec.reificationMode, (RDFNode)JenaModelSpec.rsMinimal).hasNext());
        TestModelSpec.assertInstanceOf(SimpleGraphMaker.class, mm.getGraphMaker());
        TestModelSpec.assertEquals((Object)ReificationStyle.Minimal, (Object)mm.getGraphMaker().getReificationStyle());
    }

    public void testCreatePlainFileModel() {
        Resource me = TestModelSpec.resource();
        Resource maker = TestModelSpec.resource();
        Model spec = TestModelSpec.createPlainModelDesc(me, maker, JenaModelSpec.FileMakerSpec);
        PlainModelSpec pms = new PlainModelSpec(me, spec);
        ModelMaker mm = pms.getModelMaker();
        Model desc = mm.getDescription(me);
        TestModelSpec.assertTrue((boolean)desc.listStatements(null, RDF.type, (RDFNode)JenaModelSpec.FileMakerSpec).hasNext());
        TestModelSpec.assertTrue((boolean)desc.listStatements(null, JenaModelSpec.reificationMode, (RDFNode)JenaModelSpec.rsMinimal).hasNext());
        TestModelSpec.assertInstanceOf(FileGraphMaker.class, mm.getGraphMaker());
        TestModelSpec.assertEquals((Object)ReificationStyle.Minimal, (Object)mm.getGraphMaker().getReificationStyle());
    }

    public static Model createPlainModelDesc() {
        return TestModelSpec.createPlainModelDesc(TestModelSpec.resource());
    }

    public static Model createPlainModelDesc(Resource root) {
        return TestModelSpec.createPlainModelDesc(root, TestModelSpec.resource());
    }

    public static Model createPlainModelDesc(Resource root, Resource maker) {
        return TestModelSpec.createPlainModelDesc(root, maker, JenaModelSpec.MemMakerSpec);
    }

    public static Model createPlainModelDesc(Resource root, Resource maker, Resource spec) {
        return ModelFactory.createDefaultModel().add(root, JenaModelSpec.maker, (RDFNode)maker).add(maker, RDF.type, (RDFNode)spec).add(maker, JenaModelSpec.reificationMode, (RDFNode)JenaModelSpec.rsMinimal);
    }

    public static Model createInfModelDesc(String URI2) {
        return TestModelSpec.createInfModelDesc(TestModelSpec.resource(), URI2);
    }

    public static Model createInfModelDesc(Resource root, String URI2) {
        Resource maker = TestModelSpec.resource();
        Resource reasoner = TestModelSpec.resource();
        Resource res = TestModelSpec.resource(URI2);
        return ModelFactory.createDefaultModel().add(root, JenaModelSpec.reasonsWith, (RDFNode)reasoner).add(reasoner, JenaModelSpec.reasoner, (RDFNode)res).add(root, JenaModelSpec.maker, (RDFNode)maker).add(maker, RDF.type, (RDFNode)JenaModelSpec.MemMakerSpec).add(maker, JenaModelSpec.reificationMode, (RDFNode)JenaModelSpec.rsMinimal);
    }
}

