/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.spec.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestModelSpecImplLoadFiles
extends ModelTestBase {
    protected static final Resource anchor = TestModelSpecImplLoadFiles.resource("anchor");
    protected static final Property loaded = TestModelSpecImplLoadFiles.property("loaded");

    public TestModelSpecImplLoadFiles(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestModelSpecImplLoadFiles.class);
    }

    protected ModelSpec getImpl() {
        Model description = TestModelSpecImplLoadFiles.modelWithStatements("root jms:loadWith file:quinx");
        Resource root = TestModelSpecImplLoadFiles.resource(description, "root");
        TestingModelSpec result = new TestingModelSpec(root, description);
        result.getModelMaker().createModel("aName");
        result.getModelMaker().getGraphMaker().getGraph();
        return result;
    }

    public void testCreateModelOver() {
        this.checkLoaded(this.getImpl().createModelOver("aName"));
    }

    public void testOpenModel() {
        this.checkLoaded(this.getImpl().openModel());
    }

    public void testOpenModelWithArg() {
        this.checkLoaded(this.getImpl().openModel("aName"));
    }

    public void testCreateDefaultModel() {
        this.checkLoaded(this.getImpl().createDefaultModel());
    }

    public void testCreateFreshModel() {
        this.checkLoaded(this.getImpl().createFreshModel());
    }

    public void testOpenModelIfPresent() {
        this.checkLoaded(this.getImpl().openModelIfPresent("aName"));
    }

    public void testGetModel() {
        this.checkLoaded(this.getImpl().getModel());
    }

    public void testCreateModel() {
        this.checkLoaded(this.getImpl().createModel());
    }

    protected void checkLoaded(Model model) {
        TestModelSpecImplLoadFiles.assertNotNull((Object)model);
        TestModelSpecImplLoadFiles.assertIsoModels(TestModelSpecImplLoadFiles.modelWithStatements("anchor loaded file:quinx"), model);
    }

    protected static class TestingModelSpec
    extends ModelSpecImpl {
        public TestingModelSpec(Resource root, Model description) {
            super(root, description);
        }

        public Model implementCreateModelOver(String name) {
            return ModelFactory.createDefaultModel();
        }

        protected Model doCreateModel() {
            return ModelFactory.createDefaultModel();
        }

        public Property getMakerProperty() {
            return null;
        }

        protected Model loadFile(Model m, Resource fileName) {
            return m.add(anchor, loaded, (RDFNode)fileName);
        }
    }
}

