/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.spec.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestSuite;

public class TestModelSpecMore
extends ModelTestBase {
    public TestModelSpecMore(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpecMore.class);
    }

    public void testLoadWorks() throws Exception {
        String url = this.makeModel("a bb c");
        Model wanted = FileManager.get().loadModel(url);
        Model spec = TestModelSpecMore.modelWithStatements("_root rdf:type jms:PlainModelSpec; _root jms:maker jms:MemMaker; _root jms:loadWith " + url);
        ModelSpec ms = ModelFactory.createSpec((Model)spec);
        Model m = ModelFactory.createModel((ModelSpec)ms);
        TestModelSpecMore.assertIsoModels(wanted, m);
    }

    public void testLoadOnInfModel() throws Exception {
        String url = this.makeModel("birds fly south");
        Model wanted = FileManager.get().loadModel(url);
        Model spec = TestModelSpecMore.modelWithStatements("_this jms:maker _maker; _this jms:reasonsWith _reasoner; _this jms:loadWith " + url + "; _reasoner jms:reasoner http://jena.hpl.hp.com/2003/RDFSExptRuleReasoner");
        ModelSpec ms = ModelFactory.createSpec((Model)spec);
        Model m = ModelFactory.createModel((ModelSpec)ms);
        this.assertSubModelOf(wanted, m);
    }

    protected void assertSubModelOf(Model sub, Model entire) {
        if (sub.difference(entire).size() > 0L) {
            TestModelSpecMore.fail((String)"not a sub-model");
        }
    }

    public void testLoadMultiWorks() throws Exception {
        String url1 = this.makeModel("dogs may bark");
        String url2 = this.makeModel("pigs might fly");
        Model wanted = FileManager.get().loadModel(url1);
        FileManager.get().readModel(wanted, url2);
        Model spec = TestModelSpecMore.modelWithStatements("_root rdf:type jms:PlainModelSpec; _root jms:maker jms:MemMaker");
        TestModelSpecMore.modelAdd(spec, "_root jms:loadWith " + url1);
        TestModelSpecMore.modelAdd(spec, "_root jms:loadWith " + url2);
        ModelSpec ms = ModelFactory.createSpec((Model)spec);
        Model m = ModelFactory.createModel((ModelSpec)ms);
        TestModelSpecMore.assertIsoModels(wanted, m);
    }

    protected String makeModel(String statements) throws FileNotFoundException, IOException {
        String name = FileUtils.tempFileName((String)"test-load-with-", (String)".rdf").getAbsolutePath();
        Model m = TestModelSpecMore.modelWithStatements(statements);
        FileOutputStream fos = new FileOutputStream(name);
        m.write((OutputStream)fos, FileUtils.guessLang((String)name));
        fos.close();
        return "file:" + name;
    }

    public void testOpenModel() {
        Model s = TestModelSpecMore.modelWithStatements("_root jms:maker jms:MemMaker");
        TestModelSpecMore.assertInstanceOf(Model.class, ModelFactory.createSpec((Model)s).openModel("nosuch"));
    }

    public void testModelSpecImpl() {
        Model d = TestModelSpecMore.modelWithStatements("_x jms:modelName 'redrose'");
        MiniModelSpec s = new MiniModelSpec(TestModelSpecMore.resource(d, "_x"), d);
        ModelMaker maker = s.getModelMaker();
        TestModelSpecMore.assertFalse((boolean)maker.hasModel("redrose"));
        Model m1 = s.createDefaultModel();
        TestModelSpecMore.assertTrue((boolean)maker.hasModel("redrose"));
    }

    public void testModelSpecImplOpen() {
        Model d = TestModelSpecMore.modelWithStatements("");
        MiniModelSpec s = new MiniModelSpec(TestModelSpecMore.resource(d, "_x"), d);
        s.openModel("sundog");
        TestModelSpecMore.assertTrue((boolean)s.getModelMaker().hasModel("sundog"));
    }

    public void testModelSpecImplOpenIfPresent() {
        Model d = TestModelSpecMore.modelWithStatements("");
        MiniModelSpec s = new MiniModelSpec(TestModelSpecMore.resource(d, "_x"), d);
        TestModelSpecMore.assertNull((Object)s.openModelIfPresent("sundog"));
        s.openModel("sundog");
        TestModelSpecMore.assertNotNull((Object)s.openModelIfPresent("sundog"));
    }

    protected final class MiniModelSpec
    extends ModelSpecImpl {
        protected MiniModelSpec(Resource root, Model description) {
            super(root, description);
        }

        protected Model doCreateModel() {
            return null;
        }

        public Model createModelOver(String name) {
            return null;
        }

        public Property getMakerProperty() {
            return null;
        }

        public Model implementCreateModelOver(String name) {
            return null;
        }
    }
}

