/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.spec.test;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestSuite;

public class TestModelSpecWithSchema
extends ModelTestBase {
    protected static final Filter inJMS = new Filter(){

        public boolean accept(Object o) {
            Statement s = (Statement)o;
            return s.getSubject().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#") && s.getResource().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#");
        }
    };

    public TestModelSpecWithSchema(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpecWithSchema.class);
    }

    public void testReificationMode() {
        this.testDomain("jms:reificationMode rdfs:domain jms:MakerSpec");
    }

    public void testMaker() {
        this.testDomain("jms:maker rdfs:domain jms:PlainModelSpec");
    }

    public void testImportMaker() {
        this.testDomain("jms:importMaker rdfs:domain jms:OntModelSpec");
    }

    public void testOntLanguage() {
        this.testDomain("jms:ontLanguage rdfs:domain jms:OntModelSpec");
    }

    public void testReasonsWith() {
        this.testDomain("jms:reasonsWith rdfs:domain jms:InfModelSpec");
    }

    public void testModelName() {
        this.testDomain("jms:modelName rdfs:domain jms:ModelSpec");
    }

    public void testFileBase() {
        this.testDomain("jms:fileBase rdfs:domain jms:FileMakerSpec");
    }

    public void testHasConnection() {
        this.testDomain("jms:hasConnection rdfs:domain jms:RDBMakerSpec");
    }

    public void testSubclasses() {
        Set got;
        Model m = JenaModelSpec.getSchema();
        Model m2 = ModelSpecFactory.withSpecSchema((Model)((InfModel)JenaModelSpec.getSchema()).getRawModel());
        Set wanted = TestModelSpecWithSchema.iteratorToSet((Iterator)m.listStatements(null, RDFS.subClassOf, (RDFNode)null).filterKeep(inJMS));
        if (!((Object)wanted).equals(got = TestModelSpecWithSchema.iteratorToSet((Iterator)m2.listStatements(null, RDFS.subClassOf, (RDFNode)null)))) {
            HashSet extra = new HashSet(got);
            extra.removeAll(wanted);
            HashSet missing = new HashSet(wanted);
            missing.remove(got);
            System.err.println(">> " + extra);
            System.err.println(">> " + missing);
            TestModelSpecWithSchema.fail((String)"not equal");
        }
    }

    protected void testDomain(String triple) {
        Statement s = TestModelSpecWithSchema.statement(triple);
        Property P = (Property)s.getSubject().as(Property.class);
        Resource C = s.getResource();
        Resource X = ResourceFactory.createResource();
        Resource Y = ResourceFactory.createResource();
        Model m = ModelFactory.createDefaultModel().add(X, P, (RDFNode)Y);
        Model ws = ModelSpecFactory.withSpecSchema((Model)m);
        StmtIterator it = ws.listStatements(C, RDFS.subClassOf, (RDFNode)null);
        while (it.hasNext()) {
            TestModelSpecWithSchema.assertTrue((boolean)ws.contains(X, RDF.type, it.nextStatement().getObject()));
        }
    }

    protected void testOK(String wanted, String toTest) {
        TestModelSpecWithSchema.assertIsoModels(this.m(wanted), ModelSpecFactory.withSpecSchema((Model)this.m(toTest)));
    }

    public Model m(String s) {
        return TestModelSpecWithSchema.modelWithStatements(s);
    }
}

