/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.spec.test;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.InfModelSpec;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleReasoner;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NoReasonerSuppliedException;
import com.hp.hpl.jena.shared.NoSuchReasonerException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.RulesetNotFoundException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestModelSpecsWithRuleSets
extends ModelTestBase {
    public static final Resource A = TestModelSpecsWithRuleSets.resource("_a");

    public TestModelSpecsWithRuleSets(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpecsWithRuleSets.class);
    }

    public void testTriples() {
        this.check("a R b", "a R b", new Object[0]);
        this.check("a R b", "a R ?0", new Object[]{"b"});
        this.check("a P b", "a ?0 ?1", new Object[]{"P", "b"});
        this.check("_a P 17; Q P _a", "?0 ?1 ?2; ?3 ?1 ?0", new Object[]{"_a", "P", "17", "Q"});
    }

    public void check(String wanted, String template, Object[] args) {
        Model m = TestModelSpecsWithRuleSets.modelWithStatements(template, args);
        TestModelSpecsWithRuleSets.assertIsoModels(TestModelSpecsWithRuleSets.modelWithStatements(wanted), m);
    }

    private static Model modelWithStatements(String facts, Object[] objects) {
        Graph g = Factory.createGraphMem();
        StringTokenizer semis = new StringTokenizer(facts, ";");
        while (semis.hasMoreTokens()) {
            g.add(TestModelSpecsWithRuleSets.replace(TestModelSpecsWithRuleSets.triple(PrefixMapping.Extended, semis.nextToken()), objects));
        }
        return ModelFactory.createModelForGraph((Graph)g);
    }

    private static Triple replace(Triple t, Object[] objects) {
        return Triple.create((Node)TestModelSpecsWithRuleSets.replace(t.getSubject(), objects), (Node)TestModelSpecsWithRuleSets.replace(t.getPredicate(), objects), (Node)TestModelSpecsWithRuleSets.replace(t.getObject(), objects));
    }

    private static Node replace(Node n, Object[] objects) {
        String name;
        if (n.isVariable() && Character.isDigit((name = n.getName()).charAt(0))) {
            return Node.create((String)((String)objects[Integer.parseInt(name)]));
        }
        return n;
    }

    protected static void assertSameRules(List wanted, List got) {
        TestModelSpecsWithRuleSets.assertEquals(new HashSet(wanted), new HashSet(got));
    }

    public void testNoReasonerSuppliedException() {
        Model rs = TestModelSpecsWithRuleSets.modelWithStatements("_a rdf:type jms:ReasonerSpec");
        Resource A = TestModelSpecsWithRuleSets.resource("_a");
        try {
            InfModelSpec.getReasonerFactory((Resource)A, (Model)rs);
            TestModelSpecsWithRuleSets.fail((String)"should catch missing reasoner");
        }
        catch (NoReasonerSuppliedException e) {
            TestModelSpecsWithRuleSets.pass();
        }
    }

    public void testNoSuchReasonerException() {
        Model rs = TestModelSpecsWithRuleSets.modelWithStatements("_a rdf:type jms:ReasonerSpec; _a jms:reasoner nosuch:reasoner");
        Resource A = TestModelSpecsWithRuleSets.resource("_a");
        try {
            InfModelSpec.getReasonerFactory((Resource)A, (Model)rs);
            TestModelSpecsWithRuleSets.fail((String)"should catch unknown reasoner");
        }
        catch (NoSuchReasonerException e) {
            TestModelSpecsWithRuleSets.assertEquals((String)"nosuch:reasoner", (String)e.getURI());
            this.assertContains("nosuch:reasoner", e.toString());
        }
    }

    public void testGetOWLFBReasoner() {
        this.testGetReasoner("http://jena.hpl.hp.com/2003/OWLFBRuleReasoner", OWLFBRuleReasoner.class);
    }

    public void testGetRDFSRuleReasoner() {
        this.testGetReasoner("http://jena.hpl.hp.com/2003/RDFSExptRuleReasoner", RDFSRuleReasoner.class);
    }

    public void testRulesetURLFails() {
        String uri = "http://jena.hpl.hp.com/2003/GenericRuleReasoner";
        Model rs = TestModelSpecsWithRuleSets.modelWithStatements("_a jms:reasoner ?0; _a jms:ruleSetURL nowhere:man", new Object[]{uri});
        try {
            InfModelSpec.getReasonerFactory((Resource)A, (Model)rs).create(null);
            TestModelSpecsWithRuleSets.fail((String)"should report ruleset failure");
        }
        catch (RulesetNotFoundException e) {
            TestModelSpecsWithRuleSets.assertEquals((String)"nowhere:man", (String)e.getURI());
        }
    }

    public void testEmptyRulesetURLWorks() {
        this.testRuleSetURL("http://jena.hpl.hp.com/2003/GenericRuleReasoner", TestModelSpecsWithRuleSets.file("empty.rules"));
    }

    public void testNonEmptyRulesetURLWorks() {
        this.testRuleSetURL("http://jena.hpl.hp.com/2003/GenericRuleReasoner", TestModelSpecsWithRuleSets.file("example.rules"));
    }

    public void testMultipleRulesetURLsWork() {
        String factoryURI = "http://jena.hpl.hp.com/2003/GenericRuleReasoner";
        String rulesA = TestModelSpecsWithRuleSets.file("example.rules");
        String rulesB = TestModelSpecsWithRuleSets.file("extra.rules");
        List rules = TestModelSpecsWithRuleSets.append(Rule.rulesFromURL((String)rulesA), Rule.rulesFromURL((String)rulesB));
        Model rs = TestModelSpecsWithRuleSets.modelWithStatements("_a jms:reasoner ?0; _a jms:ruleSetURL ?1; _a jms:ruleSetURL ?2", new Object[]{factoryURI, rulesA, rulesB});
        ReasonerFactory rf = InfModelSpec.getReasonerFactory((Resource)A, (Model)rs);
        RuleReasoner gr = (RuleReasoner)rf.create(null);
        TestModelSpecsWithRuleSets.assertSameRules(rules, gr.getRules());
    }

    public void testInlineRulesets() {
        String factoryURI = "http://jena.hpl.hp.com/2003/GenericRuleReasoner";
        String ruleStringA = "[rdfs2:  (?x ?p ?y), (?p rdfs:domain ?c) -> (?x rdf:type ?c)]";
        String ruleStringB = "[rdfs9:  (?x rdfs:subClassOf ?y), (?a rdf:type ?x) -> (?a rdf:type ?y)]";
        List rules = TestModelSpecsWithRuleSets.append(Rule.parseRules((String)ruleStringA), Rule.parseRules((String)ruleStringB));
        Model rs = this.rSpec(factoryURI).add(A, JenaModelSpec.ruleSet, (RDFNode)TestModelSpecsWithRuleSets.resource("onward:rules")).add(TestModelSpecsWithRuleSets.resource("onward:rules"), JenaModelSpec.hasRule, ruleStringA).add(TestModelSpecsWithRuleSets.resource("onward:rules"), JenaModelSpec.hasRule, ruleStringB);
        ReasonerFactory rf = InfModelSpec.getReasonerFactory((Resource)A, (Model)rs);
        RuleReasoner gr = (RuleReasoner)rf.create(null);
        TestModelSpecsWithRuleSets.assertSameRules(rules, gr.getRules());
    }

    public void testURLRulesets() {
        String factoryURI = "http://jena.hpl.hp.com/2003/GenericRuleReasoner";
        String ruleFileA = TestModelSpecsWithRuleSets.file("example.rules");
        String ruleFileB = TestModelSpecsWithRuleSets.file("extra.rules");
        List rules = TestModelSpecsWithRuleSets.append(Rule.rulesFromURL((String)ruleFileA), Rule.rulesFromURL((String)ruleFileB));
        Model rs = this.rSpec(factoryURI).add(A, JenaModelSpec.ruleSet, (RDFNode)TestModelSpecsWithRuleSets.resource("onward:rules")).add(TestModelSpecsWithRuleSets.resource("onward:rules"), JenaModelSpec.ruleSetURL, (RDFNode)TestModelSpecsWithRuleSets.resource(ruleFileA)).add(TestModelSpecsWithRuleSets.resource("onward:rules"), JenaModelSpec.ruleSetURL, (RDFNode)TestModelSpecsWithRuleSets.resource(ruleFileB));
        ReasonerFactory rf = InfModelSpec.getReasonerFactory((Resource)A, (Model)rs);
        RuleReasoner gr = (RuleReasoner)rf.create(null);
        TestModelSpecsWithRuleSets.assertSameRules(rules, gr.getRules());
    }

    public void testSchema() {
        ReasonerRegistry.theRegistry().register("fake:factory", (ReasonerFactory)new FakeFactory());
        String d = "_root jms:reasonsWith _reasoner; _reasoner jms:reasoner fake:factory; _root jms:maker _maker; _maker rdf:type jms:MemMakerSpec; _maker jms:reificationMode jms:rsMinimal; _reasoner jms:schemaURL ?0; _reasoner jms:schemaURL ?1";
        Model desc = TestModelSpecsWithRuleSets.modelWithStatements(d, new Object[]{TestModelSpecsWithRuleSets.file("schema.n3"), TestModelSpecsWithRuleSets.file("schema2.n3")});
        ModelSpec spec = ModelFactory.createSpec((Model)desc);
        this.validateHasSchema(this.loadBoth("schema.n3", "schema2.n3"), spec.createFreshModel());
    }

    private Graph loadBoth(String x, String y) {
        Model schema = FileManager.get().loadModel(TestModelSpecsWithRuleSets.file(x));
        Model schema2 = FileManager.get().loadModel(TestModelSpecsWithRuleSets.file(y));
        schema.add(schema2);
        return schema.getGraph();
    }

    private void validateHasSchema(Graph schema, Model m) {
        ((FakeReasoner)((InfGraph)m.getGraph()).getReasoner()).validate(schema);
    }

    public void testCreateReasoningModel() {
        String ruleString = "[rdfs3a: (?x rdfs:range  ?y), (?y rdfs:subClassOf ?z) -> (?x rdfs:range  ?z)]";
        List wanted = Rule.parseRules((String)ruleString);
        ModelSpec spec = this.createInfModelSpec(ruleString);
        Model m = spec.createFreshModel();
        Graph g = m.getGraph();
        TestModelSpecsWithRuleSets.assertInstanceOf(InfGraph.class, g);
        Reasoner r = ((InfGraph)g).getReasoner();
        TestModelSpecsWithRuleSets.assertInstanceOf(RuleReasoner.class, r);
        RuleReasoner rr = (RuleReasoner)r;
        List rules = rr.getRules();
        TestModelSpecsWithRuleSets.assertSameRules(wanted, rules);
    }

    public void testDescription() {
        String ruleString = "[rdfs3a: (?x rdfs:range  ?y), (?y rdfs:subClassOf ?z) -> (?x rdfs:range  ?z)]";
        Model desc = TestModelSpecsWithRuleSets.createInfModelDesc(A, "http://jena.hpl.hp.com/2003/GenericRuleReasoner", ruleString);
        ModelSpec s = ModelSpecFactory.createSpec((Model)desc);
        TestModelSpecsWithRuleSets.assertIsoModels(desc, s.getDescription());
    }

    private ModelSpec createInfModelSpec(String ruleString) {
        Model desc = TestModelSpecsWithRuleSets.createInfModelDesc(A, "http://jena.hpl.hp.com/2003/GenericRuleReasoner", ruleString);
        return ModelSpecFactory.createSpec((Model)desc);
    }

    public static Model createInfModelDesc(Resource root, String URI2, String ruleString) {
        String d = "_root jms:reasonsWith _reasoner; _reasoner jms:reasoner ?0; _root jms:maker _maker; _maker rdf:type jms:MemMakerSpec; _maker jms:reificationMode jms:rsMinimal; _reasoner jms:ruleSet _rules; _rules jms:hasRule ?1";
        return TestModelSpecsWithRuleSets.modelWithStatements(d, new Object[]{URI2, "'" + ruleString + "'"});
    }

    private void testRuleSetURL(String factoryURI, String rulesURL) {
        List rules = Rule.rulesFromURL((String)rulesURL);
        Model rs = TestModelSpecsWithRuleSets.modelWithStatements("_a jms:reasoner ?0; _a jms:ruleSetURL ?1", new Object[]{factoryURI, rulesURL});
        ReasonerFactory rf = InfModelSpec.getReasonerFactory((Resource)A, (Model)rs);
        GenericRuleReasoner gr = (GenericRuleReasoner)rf.create(null);
        TestModelSpecsWithRuleSets.assertSameRules(rules, gr.getRules());
    }

    protected void testGetReasoner(String uri, Class wantClass) {
        ReasonerFactory rf = InfModelSpec.getReasonerFactory((Resource)A, (Model)this.rSpec(uri));
        TestModelSpecsWithRuleSets.assertEquals((Object)wantClass, rf.create(null).getClass());
    }

    protected Model rSpec(String factoryURI) {
        return TestModelSpecsWithRuleSets.modelWithStatements("_a jms:reasoner " + factoryURI);
    }

    protected static String file(String name) {
        return "file:testing/modelspecs/" + name;
    }

    protected void assertContains(String x, String y) {
        if (y == null) {
            TestModelSpecsWithRuleSets.fail((String)("<null> does not contain anything, especially '" + x + "'"));
        }
        if (y.indexOf(x) < 0) {
            TestModelSpecsWithRuleSets.fail((String)("'" + y + "' does not contain '" + x + "'"));
        }
    }

    protected static class FakeFactory
    implements ReasonerFactory {
        protected FakeFactory() {
        }

        public Reasoner create(Resource configuration) {
            return new FakeReasoner();
        }

        public Model getCapabilities() {
            return null;
        }

        public String getURI() {
            return null;
        }
    }

    protected static class FakeReasoner
    implements Reasoner {
        public Graph bound = Factory.createGraphMem();

        protected FakeReasoner() {
        }

        public void validate(Graph desired) {
            Assert.assertTrue((String)"bound graph is not correct", (boolean)desired.isIsomorphicWith(this.bound));
        }

        public Reasoner bindSchema(Graph tbox) throws ReasonerException {
            this.bound.getBulkUpdateHandler().add(tbox);
            return this;
        }

        public Reasoner bindSchema(Model tbox) throws ReasonerException {
            return this.bindSchema(tbox.getGraph());
        }

        public InfGraph bind(Graph data) throws ReasonerException {
            return new BasicForwardRuleInfGraph((Reasoner)this, new ArrayList(), Factory.createGraphMem(), Factory.createGraphMem());
        }

        public void setDerivationLogging(boolean logOn) {
            throw new JenaException("fakes don't do this");
        }

        public void setParameter(Property parameterUri, Object value) {
            throw new JenaException("fakes don't do this");
        }

        public Model getReasonerCapabilities() {
            throw new JenaException("fakes don't do this");
        }

        public void addDescription(Model configSpec, Resource base) {
            throw new JenaException("fakes don't do this");
        }

        public boolean supportsProperty(Property property) {
            throw new JenaException("fakes don't do this");
        }

        public Capabilities getGraphCapabilities() {
            return new BaseInfGraph.InfCapabilities();
        }
    }
}

