/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.impl.InfModelSpec;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.impl.PlainModelSpec;
import com.hp.hpl.jena.rdf.model.spec.test.TestModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.shared.BadDescriptionException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestModelFactory
extends ModelTestBase {
    public static final Resource DAMLLangResource = TestModelFactory.resource("http://www.daml.org/2001/03/daml+oil#");

    public TestModelFactory(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelFactory.class);
    }

    public void testCreateDefaultModel() {
        ModelFactory.createDefaultModel().close();
    }

    public void testGetDefaultPrefixMapping() {
        TestModelFactory.assertSame((Object)ModelCom.getDefaultModelPrefixes(), (Object)ModelFactory.getDefaultModelPrefixes());
    }

    public void testSetDefaultPrefixMapping() {
        PrefixMapping original = ModelCom.getDefaultModelPrefixes();
        PrefixMapping pm = PrefixMapping.Factory.create();
        ModelFactory.setDefaultModelPrefixes((PrefixMapping)pm);
        TestModelFactory.assertSame((Object)pm, (Object)ModelCom.getDefaultModelPrefixes());
        TestModelFactory.assertSame((Object)pm, (Object)ModelFactory.getDefaultModelPrefixes());
        ModelCom.setDefaultModelPrefixes((PrefixMapping)original);
    }

    public void testCreateSpecFails() {
        try {
            ModelFactory.createSpec((Model)ModelFactory.createDefaultModel());
            TestModelFactory.fail((String)"empty descriptions should throw the appropriate exception");
        }
        catch (BadDescriptionException e) {
            TestModelFactory.pass();
        }
    }

    public void testCreatePlainSpec() {
        Model desc = TestModelSpec.createPlainModelDesc();
        ModelSpec spec = ModelFactory.createSpec((Model)desc);
        TestModelFactory.assertIsoModels(desc, spec.getDescription());
        TestModelFactory.assertInstanceOf(PlainModelSpec.class, spec);
        TestModelFactory.assertInstanceOf(GraphMemBase.class, spec.createFreshModel().getGraph());
    }

    public void testCreateOntSpec() {
        Resource root = ResourceFactory.createResource();
        Resource importsMaker = ResourceFactory.createResource();
        Resource baseMaker = ResourceFactory.createResource();
        Resource reasoner = ResourceFactory.createResource();
        OntDocumentManager docManager = new OntDocumentManager();
        Resource reasonerURI = ResourceFactory.createResource((String)"http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory");
        Model desc = ModelFactory.createDefaultModel().add(root, JenaModelSpec.maker, (RDFNode)baseMaker).add(root, JenaModelSpec.importMaker, (RDFNode)importsMaker).add(baseMaker, RDF.type, (RDFNode)JenaModelSpec.FileMakerSpec).add(baseMaker, JenaModelSpec.fileBase, "/tmp/example").add(baseMaker, JenaModelSpec.reificationMode, (RDFNode)JenaModelSpec.rsMinimal).add(importsMaker, RDF.type, (RDFNode)JenaModelSpec.MemMakerSpec).add(importsMaker, JenaModelSpec.reificationMode, (RDFNode)JenaModelSpec.rsMinimal).add(root, JenaModelSpec.ontLanguage, (RDFNode)DAMLLangResource).add(root, JenaModelSpec.docManager, (RDFNode)ModelSpecImpl.createValue((Object)docManager)).add(root, JenaModelSpec.reasonsWith, (RDFNode)reasoner).add(reasoner, JenaModelSpec.reasoner, (RDFNode)reasonerURI);
        ModelSpec spec = ModelFactory.createSpec((Model)desc);
        TestModelFactory.assertInstanceOf(OntModelSpec.class, spec);
        TestModelFactory.assertIsoModels(desc, spec.getDescription());
        TestModelFactory.assertInstanceOf(OntModel.class, spec.createFreshModel());
    }

    public void testCreateOntologyModelFromSpecOnly() {
        Resource root = ResourceFactory.createResource();
        Model desc = ModelFactory.createDefaultModel().add(root, JenaModelSpec.ontLanguage, (RDFNode)DAMLLangResource);
        OntModelSpec spec = (OntModelSpec)ModelFactory.createSpec((Model)desc);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec);
    }

    public void testCreateInfSpec() {
        Model desc = TestModelSpec.createInfModelDesc("http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory");
        ModelSpec spec = ModelFactory.createSpec((Model)desc);
        TestModelFactory.assertInstanceOf(InfModelSpec.class, spec);
        TestModelFactory.assertIsoModels(desc, spec.getDescription());
        TestModelFactory.assertInstanceOf(InfModel.class, spec.createFreshModel());
    }

    public void testCreateInfModel() {
        String rule = "-> (eg:r eg:p eg:v).";
        GenericRuleReasoner r = new GenericRuleReasoner(Rule.parseRules((String)rule));
        InfGraph ig = r.bind(ModelFactory.createDefaultModel().getGraph());
        InfModel im = ModelFactory.createInfModel((InfGraph)ig);
        TestModelFactory.assertInstanceOf(InfModel.class, im);
        TestModelFactory.assertTrue((im.size() == 1L ? 1 : 0) != 0);
    }

    public void testMFCreate() {
        Model desc = TestModelSpec.createPlainModelDesc();
        ModelSpec spec = ModelFactory.createSpec((Model)desc);
        Model m = ModelFactory.createModel((ModelSpec)spec);
    }

    public void testMFCreateNamed() {
        Model desc = TestModelSpec.createPlainModelDesc();
        ModelSpec spec = ModelFactory.createSpec((Model)desc);
        Model m = ModelFactory.createModelOver((ModelSpec)spec, (String)"aName");
    }

    public void testCreateNamed() {
        Resource root = ResourceFactory.createResource();
        Model desc = TestModelSpec.createPlainModelDesc(root);
        ModelSpec spec = ModelFactory.createSpec((Resource)root, (Model)desc);
    }

    public void testCreateUnion() {
        Model m1 = ModelFactory.createDefaultModel();
        Model m2 = ModelFactory.createDefaultModel();
        Model m = ModelFactory.createUnion((Model)m1, (Model)m2);
        TestModelFactory.assertInstanceOf(Union.class, m.getGraph());
        TestModelFactory.assertSame((Object)m1.getGraph(), (Object)((Union)m.getGraph()).getL());
        TestModelFactory.assertSame((Object)m2.getGraph(), (Object)((Union)m.getGraph()).getR());
    }
}

