/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.SWRLRule;

public class SatisfiabilityConverter {
    private static final Logger logger = Logger.getLogger(SatisfiabilityConverter.class.getName());
    private AxiomConverter converter;
    private OWLDataFactory factory;

    public SatisfiabilityConverter(OWLDataFactory factory) {
        this.factory = factory;
        this.converter = new AxiomConverter();
    }

    public OWLDescription convert(OWLAxiom axiom) {
        this.converter.reset();
        axiom.accept(this.converter);
        OWLDescription result = this.converter.getResult();
        if (result == null) {
            throw new RuntimeException("Not supported yet");
        }
        return result;
    }

    private class AxiomConverter
    implements OWLAxiomVisitor {
        private OWLDescription result;

        private AxiomConverter() {
        }

        private OWLObjectIntersectionOf and(OWLDescription desc1, OWLDescription desc2) {
            return SatisfiabilityConverter.this.factory.getOWLObjectIntersectionOf(this.set(desc1, desc2));
        }

        private OWLObjectIntersectionOf and(Set<OWLDescription> set) {
            return SatisfiabilityConverter.this.factory.getOWLObjectIntersectionOf(set);
        }

        OWLDescription getResult() {
            return this.result;
        }

        private OWLObjectComplementOf not(OWLDescription desc) {
            return SatisfiabilityConverter.this.factory.getOWLObjectComplementOf(desc);
        }

        private OWLObjectOneOf oneOf(OWLIndividual ind) {
            return SatisfiabilityConverter.this.factory.getOWLObjectOneOf(Collections.singleton(ind));
        }

        private OWLObjectUnionOf or(OWLDescription desc1, OWLDescription desc2) {
            return SatisfiabilityConverter.this.factory.getOWLObjectUnionOf(this.set(desc1, desc2));
        }

        void reset() {
            this.result = null;
        }

        private <T> Set<T> set(T desc1, T desc2) {
            HashSet<T> set = new HashSet<T>();
            set.add(desc1);
            set.add(desc2);
            return set;
        }

        @Override
        public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLAxiomAnnotationAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            OWLIndividual ind = axiom.getIndividual();
            OWLDescription c = axiom.getDescription();
            this.result = this.and(this.oneOf(ind), this.not(c));
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
            OWLDataValueRestriction sup = SatisfiabilityConverter.this.factory.getOWLDataValueRestriction((OWLDataPropertyExpression)axiom.getProperty(), (OWLConstant)axiom.getObject());
            OWLSubClassAxiom ax = SatisfiabilityConverter.this.factory.getOWLSubClassAxiom(sub, sup);
            ax.accept(this);
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            OWLDataSomeRestriction sub = SatisfiabilityConverter.this.factory.getOWLDataSomeRestriction((OWLDataPropertyExpression)axiom.getProperty(), SatisfiabilityConverter.this.factory.getTopDataType());
            this.result = this.and(sub, this.not(axiom.getDomain()));
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            this.result = SatisfiabilityConverter.this.factory.getOWLDataSomeRestriction((OWLDataPropertyExpression)axiom.getProperty(), SatisfiabilityConverter.this.factory.getOWLDataComplementOf((OWLDataRange)axiom.getRange()));
        }

        @Override
        public void visit(OWLDataSubPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLDeclarationAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            HashSet<OWLObjectOneOf> nominals = new HashSet<OWLObjectOneOf>();
            for (OWLIndividual ind : axiom.getIndividuals()) {
                nominals.add(this.oneOf(ind));
            }
            this.result = SatisfiabilityConverter.this.factory.getOWLObjectIntersectionOf(nominals);
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            this.result = this.and(axiom.getDescriptions());
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLEntityAnnotationAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            Iterator<OWLDescription> classes = axiom.getDescriptions().iterator();
            OWLDescription c1 = classes.next();
            OWLDescription c2 = classes.next();
            if (classes.hasNext()) {
                logger.warning("EquivalentClassesAxiom with more than two elements not supported!");
            }
            this.result = c1.isOWLNothing() ? c2 : (c2.isOWLNothing() ? c1 : (c1.isOWLThing() ? this.not(c2) : (c2.isOWLThing() ? this.not(c1) : this.or(this.and(c1, this.not(c2)), this.and(this.not(c1), c2)))));
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLImportsDeclaration axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
            OWLDataValueRestriction sup = SatisfiabilityConverter.this.factory.getOWLDataValueRestriction((OWLDataPropertyExpression)axiom.getProperty(), (OWLConstant)axiom.getObject());
            SatisfiabilityConverter.this.factory.getOWLSubClassAxiom(sub, this.not(sup)).accept(this);
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
            OWLObjectValueRestriction sup = SatisfiabilityConverter.this.factory.getOWLObjectValueRestriction((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
            SatisfiabilityConverter.this.factory.getOWLSubClassAxiom(sub, this.not(sup)).accept(this);
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
            OWLObjectValueRestriction sup = SatisfiabilityConverter.this.factory.getOWLObjectValueRestriction((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
            OWLSubClassAxiom ax = SatisfiabilityConverter.this.factory.getOWLSubClassAxiom(sub, sup);
            ax.accept(this);
        }

        @Override
        public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.result = this.and(SatisfiabilityConverter.this.factory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)axiom.getProperty(), SatisfiabilityConverter.this.factory.getOWLThing()), this.not(axiom.getDomain()));
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.result = SatisfiabilityConverter.this.factory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)axiom.getProperty(), this.not((OWLDescription)axiom.getRange()));
        }

        @Override
        public void visit(OWLObjectSubPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLOntologyAnnotationAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLSameIndividualsAxiom axiom) {
            HashSet<OWLDescription> nominals = new HashSet<OWLDescription>();
            for (OWLIndividual ind : axiom.getIndividuals()) {
                nominals.add(this.not(this.oneOf(ind)));
            }
            this.result = this.and(nominals);
        }

        @Override
        public void visit(OWLSubClassAxiom axiom) {
            OWLDescription sub = axiom.getSubClass();
            OWLDescription sup = axiom.getSuperClass();
            this.result = sup.isOWLNothing() ? sub : (sub.isOWLThing() ? this.not(sup) : this.and(sub, this.not(sup)));
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        @Override
        public void visit(SWRLRule rule) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + rule);
        }
    }
}

