/*
 * Decompiled with CFR 0.152.
 */
package org.coode.manchesterowlsyntax;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ManchesterOWLSyntaxTokenizer {
    public static final String EOF = "<EOF>";
    private Set<Character> skip = new HashSet<Character>();
    protected Set<Character> delims = new HashSet<Character>();
    private String buffer;
    private int pos;
    private int col;
    private int row;
    int startPos = 0;
    int startCol = 1;
    int startRow = 1;
    List<Token> tokens = new ArrayList<Token>();
    private StringBuilder sb;
    private static final char ESCAPE_CHAR = '\\';

    public ManchesterOWLSyntaxTokenizer(String buffer) {
        this.buffer = buffer;
        this.skip.add(Character.valueOf(' '));
        this.skip.add(Character.valueOf('\n'));
        this.skip.add(Character.valueOf('\r'));
        this.skip.add(Character.valueOf('\t'));
        this.delims.add(Character.valueOf('('));
        this.delims.add(Character.valueOf(')'));
        this.delims.add(Character.valueOf('['));
        this.delims.add(Character.valueOf(']'));
        this.delims.add(Character.valueOf(','));
        this.delims.add(Character.valueOf('{'));
        this.delims.add(Character.valueOf('}'));
        this.delims.add(Character.valueOf('^'));
        this.delims.add(Character.valueOf('@'));
        this.delims.add(Character.valueOf('<'));
        this.delims.add(Character.valueOf('>'));
        this.delims.add(Character.valueOf('='));
        this.delims.add(Character.valueOf('?'));
    }

    private void reset() {
        this.sb = new StringBuilder();
        this.tokens.clear();
        this.startRow = 1;
        this.startCol = 1;
        this.startPos = 0;
        this.pos = 0;
        this.row = 1;
        this.col = 1;
    }

    public List<Token> tokenize() {
        this.reset();
        int bufferLen = this.buffer.length();
        int lastChar = 32;
        while (this.pos < bufferLen) {
            char ch = this.readChar();
            if (ch == '\\') {
                lastChar = ch;
                ch = this.readChar();
            }
            if (ch == '\"' && lastChar != 92) {
                this.readString('\"', true);
            } else if (ch == '\'' && lastChar != 92) {
                this.readString('\'', false);
            } else if (this.skip.contains(Character.valueOf(ch))) {
                this.consumeToken();
            } else if (this.delims.contains(Character.valueOf(ch))) {
                this.consumeToken();
                this.sb.append(ch);
                this.consumeToken();
            } else {
                this.sb.append(ch);
            }
            lastChar = ch;
        }
        this.consumeToken();
        this.tokens.add(new Token(EOF, this.pos, this.col, this.row));
        return new ArrayList<Token>(this.tokens);
    }

    private void consumeToken() {
        if (this.sb.length() > 0) {
            this.tokens.add(new Token(this.sb.toString(), this.startPos, this.startCol, this.startRow));
            this.sb = new StringBuilder();
        }
        this.startPos = this.pos;
        this.startCol = this.col;
        this.startRow = this.row;
    }

    private void readString(char terminator, boolean appendTerminator) {
        if (appendTerminator) {
            this.sb.append(terminator);
        }
        while (this.pos < this.buffer.length()) {
            char ch = this.readChar();
            if (ch == '\\') {
                int j = this.pos + 1;
                if (j < this.buffer.length()) {
                    char escapedChar = this.readChar();
                    if (escapedChar == '\"' || escapedChar == '\'' || escapedChar == '\\') {
                        this.sb.append(escapedChar);
                        continue;
                    }
                    this.sb.append(ch);
                    this.sb.append(escapedChar);
                    continue;
                }
                this.sb.append('\\');
                continue;
            }
            if (ch == terminator) {
                if (!appendTerminator) break;
                this.sb.append(ch);
                break;
            }
            this.sb.append(ch);
        }
        this.consumeToken();
    }

    private char readChar() {
        char ch = this.buffer.charAt(this.pos);
        ++this.pos;
        ++this.col;
        if (ch == '\n') {
            ++this.row;
            this.col = 0;
        }
        return ch;
    }

    public static class Token {
        private String token;
        private int pos;
        private int col;
        private int row;

        public Token(String token, int pos, int col, int row) {
            this.token = token;
            this.pos = pos;
            this.col = col;
            this.row = row;
        }

        public String getToken() {
            return this.token;
        }

        public int getPos() {
            return this.pos;
        }

        public int getCol() {
            return this.col;
        }

        public int getRow() {
            return this.row;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.token);
            sb.append(" [");
            sb.append(this.pos);
            sb.append(", ");
            sb.append(this.col);
            sb.append(", ");
            sb.append(this.row);
            sb.append("]");
            return sb.toString();
        }
    }
}

