/*
 * Decompiled with CFR 0.152.
 */
package org.coode.obo.parser;

import java.net.URI;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.coode.obo.parser.OBOConsumer;
import org.coode.obo.parser.TagValueHandler;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.vocab.XSDVocabulary;

public abstract class AbstractTagValueHandler
implements TagValueHandler {
    private Logger logger = Logger.getLogger(AbstractTagValueHandler.class.getName());
    private String tag;
    private OBOConsumer consumer;

    public AbstractTagValueHandler(String tag, OBOConsumer consumer) {
        this.tag = tag;
        this.consumer = consumer;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public OWLOntologyManager getOWLOntologyManager() {
        return this.consumer.getOWLOntologyManager();
    }

    @Override
    public OWLOntology getOntology() {
        return this.consumer.getOntology();
    }

    @Override
    public void applyChange(OWLOntologyChange change) {
        try {
            this.consumer.getOWLOntologyManager().applyChange(change);
        }
        catch (OWLOntologyChangeException e) {
            this.logger.severe(e.getMessage());
        }
    }

    @Override
    public OBOConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public OWLDataFactory getDataFactory() {
        return this.consumer.getOWLOntologyManager().getOWLDataFactory();
    }

    @Override
    public URI getURIFromValue(String s) {
        return this.consumer.getURI(s);
    }

    public OWLClass getClassFromId(String s) {
        return this.getDataFactory().getOWLClass(this.getURIFromValue(s));
    }

    public OWLClass getCurrentClass() {
        return this.getDataFactory().getOWLClass(this.getURIFromValue(this.consumer.getCurrentId()));
    }

    protected OWLClass getOWLClass(String id) {
        return this.getDataFactory().getOWLClass(this.getURIFromValue(id));
    }

    protected OWLObjectProperty getOWLObjectProperty(String id) {
        return this.getDataFactory().getOWLObjectProperty(this.getURIFromValue(id));
    }

    protected OWLDescription getOWLClassOrRestriction(String termList) {
        StringTokenizer tok = new StringTokenizer(termList, " ", false);
        String id0 = null;
        String id1 = null;
        id0 = tok.nextToken();
        if (tok.hasMoreTokens()) {
            id1 = tok.nextToken();
        }
        if (id1 == null) {
            return this.getDataFactory().getOWLClass(this.getURIFromValue(id0));
        }
        OWLObjectProperty prop = this.getDataFactory().getOWLObjectProperty(this.getURIFromValue(id0));
        OWLClass filler = this.getDataFactory().getOWLClass(this.getURIFromValue(id1));
        return this.getDataFactory().getOWLObjectSomeRestriction(prop, filler);
    }

    protected OWLConstant getUntypedConstant(String literal) throws OWLException {
        return this.getDataFactory().getOWLUntypedConstant(literal);
    }

    protected OWLConstant getBooleanConstant(Boolean b) {
        if (b.booleanValue()) {
            return this.getDataFactory().getOWLTypedConstant("true", this.getDataFactory().getOWLDataType(XSDVocabulary.BOOLEAN.getURI()));
        }
        return this.getDataFactory().getOWLTypedConstant("false", this.getDataFactory().getOWLDataType(XSDVocabulary.BOOLEAN.getURI()));
    }

    protected void addAnnotation(String id, String uriID, OWLConstant value) {
        OWLConstantAnnotation anno = this.getDataFactory().getOWLConstantAnnotation(this.getURIFromValue(uriID), value);
        OWLEntity ent = null;
        ent = this.getConsumer().isTerm() ? this.getDataFactory().getOWLClass(this.getURIFromValue(id)) : (this.getConsumer().isTypedef() ? this.getDataFactory().getOWLObjectProperty(this.getURIFromValue(id)) : this.getDataFactory().getOWLIndividual(this.getURIFromValue(id)));
        OWLEntityAnnotationAxiom ax = this.getDataFactory().getOWLEntityAnnotationAxiom(ent, anno);
        this.applyChange(new AddAxiom(this.getOntology(), ax));
    }
}

