/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.functionalrenderer;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.string.EscapeUtils;
import org.coode.xml.OWLOntologyNamespaceManager;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLCardinalityRestriction;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLQuantifiedRestriction;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.util.AxiomTypeProvider;
import org.semanticweb.owl.util.VersionInfo;
import org.semanticweb.owl.vocab.OWLXMLVocabulary;

public class OWLObjectRenderer
implements OWLObjectVisitor {
    private OWLOntologyNamespaceManager nsm;
    private OWLOntology ontology;
    private Writer writer;
    private int pos;
    int lastNewLinePos;
    private boolean writeEnitiesAsURIs;
    private OWLObject focusedObject;

    public OWLObjectRenderer(OWLOntologyManager man, OWLOntology ontology, Writer writer) {
        this.ontology = ontology;
        this.writer = writer;
        this.writeEnitiesAsURIs = true;
        this.nsm = new OWLOntologyNamespaceManager(man, ontology);
        this.focusedObject = man.getOWLDataFactory().getOWLThing();
    }

    public void setFocusedObject(OWLObject focusedObject) {
        this.focusedObject = focusedObject;
    }

    private void writeNamespace(String prefix, String namespace) {
        this.write("Namespace");
        this.writeOpenBracket();
        this.write(prefix);
        this.write("=");
        this.write("<");
        this.write(namespace);
        this.write(">");
        this.writeCloseBracket();
        this.write("\n");
    }

    private void writeNamespaces() {
        if (this.nsm.getDefaultNamespace() != null) {
            this.writeNamespace("", this.nsm.getDefaultNamespace());
        }
        for (String prefix : this.nsm.getPrefixes()) {
            this.writeNamespace(prefix, this.nsm.getNamespaceForPrefix(prefix));
        }
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
    }

    private void write(OWLXMLVocabulary v) {
        this.write(v.getShortName());
    }

    private void write(String s) {
        try {
            int newLineIndex = s.indexOf(10);
            if (newLineIndex != -1) {
                this.lastNewLinePos = this.pos + newLineIndex;
            }
            this.pos += s.length();
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int getIndent() {
        return this.pos - this.lastNewLinePos - 1;
    }

    private void writeIndent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.writeSpace();
        }
    }

    private void write(URI uri) {
        String uriString = uri.toString();
        String qname = this.nsm.getQName(uriString);
        if (!qname.equals(uriString)) {
            this.write(qname);
        } else {
            this.write("<");
            this.write(uri.toString());
            this.write(">");
        }
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.writeNamespaces();
        this.write("\n\n");
        this.write(OWLXMLVocabulary.ONTOLOGY);
        this.write("(");
        int indent = this.getIndent();
        this.write("<");
        this.write(ontology.getURI().toString());
        this.write(">\n");
        for (OWLOntologyAnnotationAxiom anno : ontology.getAnnotations(ontology)) {
            this.writeIndent(indent);
            anno.getAnnotation().accept(this);
            this.write("\n");
        }
        this.write("\n\n");
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>(ontology.getAxioms());
        axioms.removeAll(ontology.getImportsDeclarations());
        for (OWLImportsDeclaration oWLImportsDeclaration : ontology.getImportsDeclarations()) {
            oWLImportsDeclaration.accept(this);
            this.write("\n");
        }
        for (OWLClass oWLClass : ontology.getReferencedClasses()) {
            this.setFocusedObject(oWLClass);
            this.write("// Class: " + oWLClass.getURI());
            this.write("\n");
            this.write("\n");
            this.writeDeclarations(oWLClass);
            this.writeAnnotations(oWLClass);
            for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(oWLClass))) {
                ax.accept(this);
            }
            this.write("\n\n\n");
        }
        for (OWLObjectProperty oWLObjectProperty : ontology.getReferencedObjectProperties()) {
            this.write("// Object property: " + oWLObjectProperty.getURI());
            this.setFocusedObject(oWLObjectProperty);
            this.write("\n");
            this.write("\n");
            this.writeDeclarations(oWLObjectProperty);
            this.writeAnnotations(oWLObjectProperty);
            for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(oWLObjectProperty))) {
                ax.accept(this);
            }
            this.write("\n\n\n");
        }
        for (OWLDataProperty oWLDataProperty : ontology.getReferencedDataProperties()) {
            this.write("// Data property: " + oWLDataProperty.getURI());
            this.setFocusedObject(oWLDataProperty);
            this.write("\n");
            this.write("\n");
            this.writeDeclarations(oWLDataProperty);
            this.writeAnnotations(oWLDataProperty);
            for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(oWLDataProperty))) {
                ax.accept(this);
            }
            this.write("\n\n\n");
        }
        for (OWLIndividual oWLIndividual : ontology.getReferencedIndividuals()) {
            this.write("// Individual: " + oWLIndividual.getURI());
            this.setFocusedObject(oWLIndividual);
            this.write("\n");
            this.write("\n");
            this.writeDeclarations(oWLIndividual);
            this.writeAnnotations(oWLIndividual);
            for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(oWLIndividual))) {
                ax.accept(this);
            }
            this.write("\n\n\n");
        }
        for (OWLClassAxiom oWLClassAxiom : ontology.getGeneralClassAxioms()) {
            this.write("// General axiom\n");
            oWLClassAxiom.accept(this);
            this.write("\n\n");
        }
        for (OWLObjectPropertyChainSubPropertyAxiom oWLObjectPropertyChainSubPropertyAxiom : ontology.getPropertyChainSubPropertyAxioms()) {
            this.write("// Sub property chain axiom\n");
            oWLObjectPropertyChainSubPropertyAxiom.accept(this);
            this.write("\n\n");
        }
        this.write(")");
        this.write("\n// ");
        this.write(VersionInfo.getVersionInfo().getGeneratedByMessage());
    }

    public void writeDeclarations(OWLEntity entity) {
        for (OWLDeclarationAxiom ax : this.ontology.getDeclarationAxioms(entity)) {
            ax.accept(this);
        }
    }

    public void writeAnnotations(OWLEntity entity) {
        for (OWLAnnotationAxiom ax : entity.getAnnotationAxioms(this.ontology)) {
            ax.accept(this);
        }
    }

    public void write(OWLXMLVocabulary v, OWLObject o) {
        this.write(v);
        this.write("(");
        o.accept(this);
        this.write(")");
    }

    private void write(Collection<? extends OWLObject> objects) {
        if (objects.size() > 2) {
            int indent = this.getIndent();
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                it.next().accept(this);
                if (!it.hasNext()) continue;
                this.write("\n");
                this.writeIndent(indent);
            }
        } else if (objects.size() == 2) {
            OWLObject rhs;
            OWLObject lhs;
            Iterator<? extends OWLObject> it = objects.iterator();
            OWLObject objA = it.next();
            OWLObject objB = it.next();
            if (objA.equals(this.focusedObject)) {
                lhs = objA;
                rhs = objB;
            } else {
                lhs = objB;
                rhs = objA;
            }
            lhs.accept(this);
            this.writeSpace();
            rhs.accept(this);
        }
    }

    public void writeOpenBracket() {
        this.write("(");
    }

    public void writeCloseBracket() {
        this.write(")");
    }

    public void writeSpace() {
        this.write(" ");
    }

    public void writeAnnotations(OWLAxiom ax) {
        this.write(ax.getAnnotationAxioms(this.ontology));
        int indent = this.getIndent();
        for (OWLAxiomAnnotationAxiom annoAx : ax.getAnnotationAxioms(this.ontology)) {
            annoAx.getAnnotation().accept(this);
            this.write("\n");
            this.writeIndent(indent);
        }
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
        if (annotation.isLabel()) {
            this.write(OWLXMLVocabulary.LABEL);
            this.writeOpenBracket();
            ((OWLConstant)annotation.getAnnotationValue()).accept(this);
            this.writeCloseBracket();
        } else if (annotation.isComment()) {
            this.write(OWLXMLVocabulary.COMMENT);
            this.writeOpenBracket();
            ((OWLConstant)annotation.getAnnotationValue()).accept(this);
            this.writeCloseBracket();
        } else {
            this.write(OWLXMLVocabulary.ANNOTATION);
            this.writeOpenBracket();
            this.write(annotation.getAnnotationURI());
            this.writeSpace();
            ((OWLConstant)annotation.getAnnotationValue()).accept(this);
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
        this.write(OWLXMLVocabulary.ANNOTATION);
        this.writeOpenBracket();
        this.write(annotation.getAnnotationURI());
        this.writeSpace();
        ((OWLIndividual)annotation.getAnnotationValue()).accept(this);
        this.writeCloseBracket();
    }

    public void writeAxiomStart(OWLXMLVocabulary v, OWLAxiom axiom) {
        this.write(v);
        this.writeOpenBracket();
        this.writeAnnotations(axiom);
    }

    public void writeAxiomEnd() {
        this.write(")\n");
    }

    public void writePropertyCharacteristic(OWLXMLVocabulary v, OWLAxiom ax, OWLPropertyExpression prop) {
        this.writeAxiomStart(v, ax);
        prop.accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.ANTI_SYMMETRIC_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.CLASS_ASSERTION, axiom);
        axiom.getIndividual().accept(this);
        this.writeSpace();
        axiom.getDescription().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION, axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLConstant)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN, axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getDomain().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_RANGE, axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF, axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DECLARATION, axiom);
        this.writeEnitiesAsURIs = false;
        axiom.getEntity().accept(this);
        this.writeEnitiesAsURIs = true;
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS, axiom);
        this.write(axiom.getIndividuals());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_CLASSES, axiom);
        this.write(axiom.getDescriptions());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES, axiom);
        this.write(axiom.getProperties());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES, axiom);
        this.write(axiom.getProperties());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_UNION, axiom);
        axiom.getOWLClass().accept(this);
        this.writeSpace();
        this.write(axiom.getDescriptions());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ENTITY_ANNOTATION, axiom);
        this.writeEnitiesAsURIs = false;
        ((OWLEntity)axiom.getSubject()).accept(this);
        this.writeEnitiesAsURIs = true;
        this.writeSpace();
        axiom.getAnnotation().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_CLASSES, axiom);
        this.write(axiom.getDescriptions());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES, axiom);
        this.write(axiom.getProperties());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES, axiom);
        this.write(axiom.getProperties());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.IMPORTS, axiom);
        this.write("<");
        this.write(axiom.getImportedOntologyURI().toString());
        this.write(">");
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES, axiom);
        axiom.getFirstProperty().accept(this);
        this.writeSpace();
        axiom.getSecondProperty().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION, axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLConstant)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION, axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION, axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, axiom);
        this.write(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_CHAIN);
        this.writeOpenBracket();
        Iterator<OWLObjectPropertyExpression> it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(" ");
        }
        this.writeCloseBracket();
        this.writeSpace();
        axiom.getSuperProperty().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN, axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getDomain().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE, axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        ((OWLDescription)axiom.getRange()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SAME_INDIVIDUALS, axiom);
        this.write(axiom.getIndividuals());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_CLASS_OF, axiom);
        axiom.getSubClass().accept(this);
        this.writeSpace();
        axiom.getSuperClass().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLClass desc) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.CLASS);
            this.writeOpenBracket();
        }
        this.write(desc.getURI());
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLCardinalityRestriction restriction) {
        this.write(v);
        this.writeOpenBracket();
        this.write(Integer.toString(restriction.getCardinality()));
        this.writeSpace();
        restriction.getProperty().accept(this);
        if (restriction.isQualified()) {
            this.writeSpace();
            restriction.getFiller().accept(this);
        }
        this.writeCloseBracket();
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLQuantifiedRestriction restriction) {
        this.writeRestriction(v, (OWLPropertyExpression)restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLPropertyExpression prop, OWLObject filler) {
        this.write(v);
        this.writeOpenBracket();
        prop.accept(this);
        this.writeSpace();
        filler.accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_ALL_VALUES_FROM, desc);
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_EXACT_CARDINALITY, desc);
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MAX_CARDINALITY, desc);
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MIN_CARDINALITY, desc);
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_SOME_VALUES_FROM, desc);
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_HAS_VALUE, (OWLPropertyExpression)desc.getProperty(), (OWLObject)desc.getValue());
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM, desc);
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.write(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF, desc.getOperand());
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY, desc);
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.write(OWLXMLVocabulary.OBJECT_INTERSECTION_OF);
        this.writeOpenBracket();
        this.write(desc.getOperands());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY, desc);
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY, desc);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.write(OWLXMLVocabulary.OBJECT_ONE_OF);
        this.writeOpenBracket();
        this.write(desc.getIndividuals());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        this.write(OWLXMLVocabulary.OBJECT_EXISTS_SELF, (OWLObject)desc.getProperty());
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM, desc);
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.write(OWLXMLVocabulary.OBJECT_UNION_OF);
        this.writeOpenBracket();
        this.write(desc.getOperands());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_HAS_VALUE, (OWLPropertyExpression)desc.getProperty(), (OWLObject)desc.getValue());
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.write(OWLXMLVocabulary.DATA_COMPLEMENT_OF, node.getDataRange());
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.write(OWLXMLVocabulary.DATA_ONE_OF);
        this.write("(");
        this.write(node.getValues());
        this.write(")");
    }

    @Override
    public void visit(OWLDataType node) {
        this.write(node.getURI());
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
        this.write(OWLXMLVocabulary.DATATYPE_RESTRICTION);
        this.writeOpenBracket();
        node.getDataRange().accept(this);
        for (OWLDataRangeFacetRestriction restriction : node.getFacetRestrictions()) {
            this.writeSpace();
            restriction.accept(this);
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
        this.write(node.getFacet().getShortName());
        this.writeSpace();
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLTypedConstant node) {
        this.write("\"");
        this.write(EscapeUtils.escapeString(node.getLiteral()));
        this.write("\"");
        this.write("^^");
        this.write(node.getDataType().getURI());
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.write("\"");
        this.write(EscapeUtils.escapeString(node.getLiteral()));
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        }
    }

    @Override
    public void visit(OWLDataProperty property) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATA_PROPERTY);
            this.writeOpenBracket();
        }
        this.write(property.getURI());
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLObjectProperty property) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.OBJECT_PROPERTY);
            this.writeOpenBracket();
        }
        this.write(property.getURI());
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        this.write(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTY);
        this.writeOpenBracket();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLIndividual individual) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.INDIVIDUAL);
            this.writeOpenBracket();
        }
        this.write(individual.getURI());
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(SWRLRule rule) {
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLClassAtom node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    private Collection<OWLAxiom> sortAxioms(Set<? extends OWLAxiom> axioms) {
        ArrayList<OWLAxiom> list = new ArrayList<OWLAxiom>(axioms);
        Collections.sort(list, new OWLAxiomComparator());
        return list;
    }

    private class OWLAxiomComparator
    implements Comparator<OWLAxiom> {
        private OWLAxiomComparator() {
        }

        @Override
        public int compare(OWLAxiom o1, OWLAxiom o2) {
            AxiomTypeProvider provider = new AxiomTypeProvider();
            int index1 = provider.getAxiomType(o1).getIndex();
            int index2 = provider.getAxiomType(o2).getIndex();
            return index1 - index2;
        }
    }
}

