/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.owlxmlparser;

import java.net.URI;
import org.coode.owl.owlxmlparser.AbstractOWLElementHandler;
import org.coode.owl.owlxmlparser.OWLConstantElementHandler;
import org.coode.owl.owlxmlparser.OWLIndividualElementHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserException;
import org.coode.owl.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.vocab.OWLXMLVocabulary;

public class OWLAnnotationElementHandler
extends AbstractOWLElementHandler<OWLAnnotation> {
    private OWLAnnotation annotation;
    private URI uri;
    private String datatype;
    private OWLConstant constant;
    private OWLIndividual individual;
    private String annoURIAttName = OWLXMLVocabulary.ANNOTATION_URI.getShortName();

    public OWLAnnotationElementHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    public void startElement(String name) throws OWLXMLParserException {
        super.startElement(name);
        this.constant = null;
        this.individual = null;
    }

    @Override
    public void attribute(String localName, String value) throws OWLXMLParserException {
        if (localName.equals(this.annoURIAttName)) {
            this.uri = this.getURI(value);
        } else if (localName.equals("Datatype")) {
            this.datatype = value;
        }
    }

    @Override
    public void endElement() throws OWLXMLParserException {
        if (this.constant == null) {
            if (this.individual == null) {
                OWLXMLParserException ex = new OWLXMLParserException(this.getLineNumber(), "Expected constant or individual as annotation content");
                ex.setLineNumber(this.getLineNumber());
                throw ex;
            }
            this.annotation = this.getOWLDataFactory().getOWLObjectAnnotation(this.uri, this.individual);
        } else {
            this.annotation = this.getOWLDataFactory().getOWLConstantAnnotation(this.uri, this.constant);
        }
        this.getParentHandler().handleChild(this);
    }

    @Override
    public void handleChild(OWLIndividualElementHandler handler) throws OWLXMLParserException {
        this.individual = handler.getOWLObject();
    }

    @Override
    public void handleChild(OWLConstantElementHandler handler) throws OWLXMLParserException {
        this.constant = handler.getOWLObject();
    }

    @Override
    public OWLAnnotation getOWLObject() {
        return this.annotation;
    }

    @Override
    public boolean isTextContentPossible() {
        return false;
    }
}

