/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.owlxmlparser;

import org.coode.owl.owlxmlparser.AbstractOWLAxiomElementHandler;
import org.coode.owl.owlxmlparser.AbstractOWLDescriptionElementHandler;
import org.coode.owl.owlxmlparser.AbstractOWLObjectPropertyElementHandler;
import org.coode.owl.owlxmlparser.OWLAnnotationElementHandler;
import org.coode.owl.owlxmlparser.OWLDataPropertyElementHandler;
import org.coode.owl.owlxmlparser.OWLIndividualElementHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserException;
import org.coode.owl.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLObjectProperty;

public class OWLEntityAnnotationElementHandler
extends AbstractOWLAxiomElementHandler {
    private OWLEntity entity;
    private OWLAnnotation annotation;

    public OWLEntityAnnotationElementHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    public void handleChild(OWLAnnotationElementHandler handler) {
        this.annotation = handler.getOWLObject();
    }

    @Override
    public void handleChild(OWLIndividualElementHandler handler) {
        this.entity = handler.getOWLObject();
    }

    @Override
    public void handleChild(AbstractOWLDescriptionElementHandler handler) throws OWLXMLParserException {
        if (handler.getOWLObject().isAnonymous()) {
            throw new OWLXMLParserException(this.getLineNumber(), "Anonymous classes are not allowed in annotations");
        }
        this.entity = (OWLClass)handler.getOWLObject();
    }

    @Override
    public void handleChild(AbstractOWLObjectPropertyElementHandler handler) throws OWLXMLParserException {
        if (handler.getOWLObject().isAnonymous()) {
            throw new OWLXMLParserException(this.getLineNumber(), "Property expressions are not allowed in annotations");
        }
        this.entity = (OWLObjectProperty)handler.getOWLObject();
    }

    @Override
    public void handleChild(OWLDataPropertyElementHandler handler) {
        this.entity = (OWLDataProperty)handler.getOWLObject();
    }

    @Override
    protected OWLAxiom createAxiom() throws OWLXMLParserException {
        return this.getOWLDataFactory().getOWLEntityAnnotationAxiom(this.entity, this.annotation);
    }
}

