/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.owlxmlparser;

import org.coode.owl.owlxmlparser.AbstractOWLAxiomElementHandler;
import org.coode.owl.owlxmlparser.AbstractOWLDescriptionElementHandler;
import org.coode.owl.owlxmlparser.AbstractOWLObjectPropertyElementHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserElementNotFoundException;
import org.coode.owl.owlxmlparser.OWLXMLParserException;
import org.coode.owl.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;

public class OWLObjectPropertyDomainElementHandler
extends AbstractOWLAxiomElementHandler {
    private OWLDescription domain;
    private OWLObjectPropertyExpression property;

    public OWLObjectPropertyDomainElementHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    public void handleChild(AbstractOWLDescriptionElementHandler handler) {
        this.domain = handler.getOWLObject();
    }

    @Override
    public void handleChild(AbstractOWLObjectPropertyElementHandler handler) {
        this.property = handler.getOWLObject();
    }

    @Override
    protected OWLAxiom createAxiom() throws OWLXMLParserException {
        if (this.property == null) {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), "Expected object property element");
        }
        if (this.domain == null) {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), "Expected description element");
        }
        return this.getOWLDataFactory().getOWLObjectPropertyDomainAxiom(this.property, this.domain);
    }
}

