/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.owlxmlparser;

import java.util.List;
import org.coode.owl.owlxmlparser.AbstractOWLAxiomElementHandler;
import org.coode.owl.owlxmlparser.AbstractOWLObjectPropertyElementHandler;
import org.coode.owl.owlxmlparser.OWLSubObjectPropertyChainElementHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserElementNotFoundException;
import org.coode.owl.owlxmlparser.OWLXMLParserException;
import org.coode.owl.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;

public class OWLSubObjectPropertyOfAxiomElementHandler
extends AbstractOWLAxiomElementHandler {
    private OWLObjectPropertyExpression subProperty;
    private List<OWLObjectPropertyExpression> propertyList;
    private OWLObjectPropertyExpression superProperty;

    public OWLSubObjectPropertyOfAxiomElementHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    public void handleChild(AbstractOWLObjectPropertyElementHandler handler) throws OWLXMLParserException {
        if (this.subProperty == null && this.propertyList == null) {
            this.subProperty = handler.getOWLObject();
        } else if (this.superProperty == null) {
            this.superProperty = handler.getOWLObject();
        } else {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), "Expected two object property expression elements");
        }
    }

    @Override
    public void handleChild(OWLSubObjectPropertyChainElementHandler handler) {
        this.propertyList = handler.getOWLObject();
    }

    @Override
    protected OWLAxiom createAxiom() throws OWLXMLParserException {
        if (this.subProperty != null) {
            return this.getOWLDataFactory().getOWLSubObjectPropertyAxiom(this.subProperty, this.superProperty);
        }
        return this.getOWLDataFactory().getOWLObjectPropertyChainSubPropertyAxiom(this.propertyList, this.superProperty);
    }
}

