/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.owlxmlparser;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.coode.owl.owlxmlparser.OWLXMLParserConfigurationException;
import org.coode.owl.owlxmlparser.OWLXMLParserHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserSAXException;
import org.semanticweb.owl.io.AbstractOWLParser;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.OWLParserException;
import org.semanticweb.owl.io.OWLParserIOException;
import org.semanticweb.owl.io.OWLXMLOntologyFormat;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OWLXMLParser
extends AbstractOWLParser {
    @Override
    public OWLOntologyFormat parse(OWLOntologyInputSource inputSource, OWLOntology ontology) throws OWLParserException {
        try {
            System.setProperty("entityExpansionLimit", "100000000");
            OWLXMLOntologyFormat format = new OWLXMLOntologyFormat();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            InputSource isrc = this.getInputSource(inputSource);
            OWLXMLParserHandler handler = new OWLXMLParserHandler(this.getOWLOntologyManager(), ontology);
            parser.parse(isrc, (DefaultHandler)handler);
            Map<String, String> prefix2NamespaceMap = handler.getPrefix2NamespaceMap();
            for (String prefix : prefix2NamespaceMap.keySet()) {
                format.addPrefixNamespaceMapping(prefix, prefix2NamespaceMap.get(prefix));
            }
            return format;
        }
        catch (ParserConfigurationException e) {
            throw new OWLXMLParserConfigurationException(e);
        }
        catch (SAXException e) {
            throw new OWLXMLParserSAXException(-1, e);
        }
        catch (IOException e) {
            throw new OWLParserIOException(e);
        }
    }
}

