/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.AbstractDataRestrictionTranslator;
import org.coode.owl.rdfxml.parser.MalformedDescriptionException;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public abstract class AbstractDataCardinalityTranslator
extends AbstractDataRestrictionTranslator {
    public AbstractDataCardinalityTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    protected abstract URI getCardinalityTriplePredicate() throws OWLException;

    private int translateCardinality(URI mainNode) throws OWLException {
        OWLConstant cardiObject = this.getLiteralObject(mainNode, this.getCardinalityTriplePredicate(), true);
        if (cardiObject == null) {
            throw new MalformedDescriptionException(this.getCardinalityTriplePredicate() + " not present");
        }
        return Integer.parseInt(cardiObject.getLiteral());
    }

    private OWLDataRange translateFiller(URI mainNode) throws OWLException {
        URI onDataRangeObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getURI(), true);
        if (onDataRangeObject == null) {
            return this.getDataFactory().getTopDataType();
        }
        return this.getConsumer().translateDataRange(onDataRangeObject);
    }

    @Override
    protected OWLDescription translateRestriction(URI mainNode) throws OWLException {
        return this.createRestriction(this.translateOnProperty(mainNode), this.translateCardinality(mainNode), this.translateFiller(mainNode));
    }

    protected abstract OWLDescription createRestriction(OWLDataPropertyExpression var1, int var2, OWLDataRange var3) throws OWLException;
}

