/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.Set;
import java.util.logging.Logger;
import org.coode.owl.rdfxml.parser.AbstractDescriptionTranslator;
import org.coode.owl.rdfxml.parser.MalformedDescriptionException;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;

public abstract class AbstractNaryBooleanDescriptionTranslator
extends AbstractDescriptionTranslator {
    private Logger logger = Logger.getLogger(OWLRDFConsumer.class.getName());

    public AbstractNaryBooleanDescriptionTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public OWLDescription translate(URI mainNode) throws OWLException {
        URI object = this.getResourceObject(mainNode, this.getPredicateURI(), true);
        if (object == null) {
            throw new MalformedDescriptionException("Triple with " + this.getPredicateURI() + " not present");
        }
        Set<OWLDescription> operands = this.translateToDescriptionSet(object);
        if (operands.size() < 2) {
            this.logger.fine("Number of operands is less than 2");
            if (operands.size() == 1) {
                return operands.iterator().next();
            }
            this.logger.fine("Number of operands is zero! Translating as owl:Thing");
            return this.getDataFactory().getOWLThing();
        }
        return this.createDescription(operands);
    }

    protected abstract OWLDescription createDescription(Set<OWLDescription> var1) throws OWLException;

    protected abstract URI getPredicateURI() throws OWLException;
}

