/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.AbstractResourceTripleHandler;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class GTPAnnotationResourceTripleHandler
extends AbstractResourceTripleHandler {
    public GTPAnnotationResourceTripleHandler(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return false;
    }

    @Override
    public boolean canHandle(URI subject, URI predicate, URI object) throws OWLException {
        return this.getConsumer().isAnnotationProperty(predicate);
    }

    @Override
    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        OWLAnnotation<OWLIndividual> anno;
        OWLTypedConstant con;
        if (this.getConsumer().isOntology(subject)) {
            this.consumeTriple(subject, predicate, object);
            OWLOntology ontology = this.getConsumer().getOWLOntologyManager().getOntology(subject);
            OWLOntologyAnnotationAxiom ax = this.getDataFactory().getOWLOntologyAnnotationAxiom(ontology, this.getDataFactory().getOWLObjectAnnotation(predicate, this.getConsumer().getOWLIndividual(object)));
            this.addAxiom(ax);
            return;
        }
        if (this.getConsumer().isOntologyProperty(object)) {
            con = this.getDataFactory().getOWLTypedConstant(object.toString(), this.getDataFactory().getOWLDataType(XSDVocabulary.ANY_URI.getURI()));
            anno = this.getDataFactory().getOWLConstantAnnotation(predicate, con);
        } else if (this.getConsumer().isIndividual(object)) {
            OWLIndividual ind = this.getConsumer().getOWLIndividual(object);
            anno = this.getDataFactory().getOWLObjectAnnotation(predicate, ind);
        } else {
            con = this.getDataFactory().getOWLTypedConstant(object.toString(), this.getDataFactory().getOWLDataType(XSDVocabulary.ANY_URI.getURI()));
            anno = this.getDataFactory().getOWLConstantAnnotation(predicate, con);
        }
        OWLEntity entity = null;
        if (this.getConsumer().isClass(subject)) {
            entity = this.getDataFactory().getOWLClass(subject);
        } else if (this.getConsumer().isObjectPropertyOnly(subject)) {
            entity = this.getDataFactory().getOWLObjectProperty(subject);
        } else if (this.getConsumer().isDataPropertyOnly(subject)) {
            entity = this.getDataFactory().getOWLDataProperty(subject);
        } else if (this.getConsumer().isAnnotationProperty(subject)) {
            this.getConsumer().getOntologyFormat().addAnnotationURIAnnotation(subject, anno);
            this.consumeTriple(subject, predicate, object);
        } else {
            entity = this.getConsumer().getOWLIndividual(subject);
        }
        if (entity != null) {
            this.consumeTriple(subject, predicate, object);
            OWLEntityAnnotationAxiom decAx = this.getDataFactory().getOWLEntityAnnotationAxiom(entity, anno);
            this.addAxiom(decAx);
        }
    }
}

