/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.Set;
import java.util.logging.Logger;
import org.coode.owl.rdfxml.parser.AbstractDescriptionTranslator;
import org.coode.owl.rdfxml.parser.MalformedDescriptionException;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class OneOfTranslator
extends AbstractDescriptionTranslator {
    Logger logger = Logger.getLogger(OWLRDFConsumer.class.getName());

    public OneOfTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public OWLDescription translate(URI mainNode) throws OWLException {
        URI oneOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ONE_OF.getURI(), true);
        if (oneOfObject == null) {
            throw new MalformedDescriptionException((Object)((Object)OWLRDFVocabulary.OWL_ONE_OF) + " triple not present when translating oneOf");
        }
        Set<OWLIndividual> individuals = this.translateToIndividualSet(oneOfObject);
        for (OWLIndividual ind : individuals) {
            this.getConsumer().addIndividual(ind.getURI());
        }
        if (individuals.isEmpty()) {
            this.logger.info("Empty set in owl:oneOf class description - converting to owl:Nothing");
            return this.getDataFactory().getOWLNothing();
        }
        return this.getDataFactory().getOWLObjectOneOf(individuals);
    }
}

