/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import edu.unika.aifb.rdf.api.syntax.RDFParser;
import java.io.IOException;
import java.net.URI;
import org.coode.owl.rdfxml.parser.AnonymousNodeChecker;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.OWLRDFXMLParserSAXException;
import org.semanticweb.owl.io.AbstractOWLParser;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.OWLParserException;
import org.semanticweb.owl.io.OWLParserIOException;
import org.semanticweb.owl.io.RDFXMLOntologyFormat;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RDFXMLParser
extends AbstractOWLParser {
    private OWLOntologyManager owlOntologyManager;
    private OWLRDFConsumer consumer;

    @Override
    public OWLOntologyFormat parse(OWLOntologyInputSource inputSource, OWLOntology ontology) throws OWLParserException {
        try {
            final RDFXMLOntologyFormat format = new RDFXMLOntologyFormat();
            if (this.owlOntologyManager == null) {
                throw new OWLRuntimeException("Cannot parse because OWLOntologyManager is null!");
            }
            final RDFParser parser = new RDFParser(){

                @Override
                public void startPrefixMapping(String prefix, String uri) throws SAXException {
                    super.startPrefixMapping(prefix, uri);
                    format.addPrefixNamespaceMapping(prefix, uri);
                }

                @Override
                public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                    super.startElement(namespaceURI, localName, qName, atts);
                    String value = atts.getValue("http://www.w3.org/XML/1998/namespace", "base");
                    if (value != null) {
                        RDFXMLParser.this.consumer.setXMLBase(value);
                    }
                }
            };
            this.consumer = new OWLRDFConsumer(this.owlOntologyManager, ontology, new AnonymousNodeChecker(){

                @Override
                public boolean isAnonymousNode(URI uri) {
                    return parser.isAnonymousNodeURI(uri.toString());
                }

                @Override
                public boolean isAnonymousNode(String uri) {
                    return parser.isAnonymousNodeURI(uri);
                }
            });
            this.consumer.setOntologyFormat(format);
            InputSource is = this.getInputSource(inputSource);
            parser.parse(is, this.consumer);
            return format;
        }
        catch (SAXException e) {
            throw new OWLRDFXMLParserSAXException(e);
        }
        catch (IOException e) {
            throw new OWLParserIOException(e);
        }
    }

    @Override
    public void setOWLOntologyManager(OWLOntologyManager owlOntologyManager) {
        this.owlOntologyManager = owlOntologyManager;
    }
}

