/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.logging.Logger;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TPPropertyRangeHandler
extends TriplePredicateHandler {
    private static final Logger logger = Logger.getLogger(TPPropertyRangeHandler.class.getName());

    public TPPropertyRangeHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_RANGE.getURI());
    }

    @Override
    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        if (!this.isAnonymous(object)) {
            if (this.getConsumer().isObjectPropertyOnly(subject)) {
                return true;
            }
            if (this.getConsumer().isDataPropertyOnly(subject)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        if (this.getConsumer().isObjectPropertyOnly(subject)) {
            this.translateObjectPropertyRange(subject, object, predicate);
        } else if (this.getConsumer().isDataPropertyOnly(subject)) {
            this.addAxiom(this.getDataFactory().getOWLDataPropertyRangeAxiom(this.translateDataProperty(subject), this.translateDataRange(object)));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isDataRange(object)) {
            logger.fine("Assuming data property because range appears to be datatype: " + subject + " -> " + predicate + " -> " + object);
            this.addAxiom(this.getDataFactory().getOWLDataPropertyRangeAxiom(this.translateDataProperty(subject), this.translateDataRange(object)));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isClass(object)) {
            logger.fine("Assuming object property because range appears to be a class: " + subject + " -> " + predicate + " -> " + object);
            this.translateObjectPropertyRange(subject, object, predicate);
        } else {
            logger.fine("Unable to determine range type.  Assuming object property: " + subject + " -> " + predicate + " -> " + object);
            this.translateObjectPropertyRange(subject, object, predicate);
        }
    }

    private void translateObjectPropertyRange(URI subject, URI object, URI predicate) throws OWLException {
        this.addAxiom(this.getDataFactory().getOWLObjectPropertyRangeAxiom(this.translateObjectProperty(subject), this.translateDescription(object)));
        this.consumeTriple(subject, predicate, object);
    }
}

