/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TPSubClassOfHandler
extends TriplePredicateHandler {
    public static int potentiallyConsumedTiples = 0;

    public TPSubClassOfHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_SUBCLASS_OF.getURI());
    }

    @Override
    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        OWLDescription superClass;
        if (!this.getConsumer().isAnonymousNode(subject) && this.getConsumer().isAnonymousNode(object) && (superClass = this.getConsumer().getDescriptionIfTranslated(object)) != null) {
            ++potentiallyConsumedTiples;
            return true;
        }
        return !this.isSubjectOrObjectAnonymous(subject, object);
    }

    @Override
    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        OWLDescription subClass = this.translateDescription(subject);
        OWLDescription supClass = this.translateDescription(object);
        OWLSubClassAxiom ax = this.getDataFactory().getOWLSubClassAxiom(subClass, supClass);
        this.addAxiom(ax);
        this.consumeTriple(subject, predicate, object);
    }
}

