/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.List;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TPSubPropertyOfHandler
extends TriplePredicateHandler {
    public TPSubPropertyOfHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getURI());
    }

    @Override
    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return false;
    }

    @Override
    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        if (this.getConsumer().hasPredicate(subject, OWLRDFVocabulary.OWL_PROPERTY_CHAIN.getURI())) {
            URI chainList = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_PROPERTY_CHAIN.getURI(), true);
            List<OWLObjectPropertyExpression> properties = this.getConsumer().translateToObjectPropertyList(chainList);
            this.addAxiom(this.getDataFactory().getOWLObjectPropertyChainSubPropertyAxiom(properties, this.translateObjectProperty(object)));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isList(subject, false)) {
            List<OWLObjectPropertyExpression> properties = this.getConsumer().translateToObjectPropertyList(subject);
            this.addAxiom(this.getDataFactory().getOWLObjectPropertyChainSubPropertyAxiom(properties, this.translateObjectProperty(object)));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isObjectPropertyOnly(subject) || this.getConsumer().isObjectPropertyOnly(object)) {
            this.translateSubObjectProperty(subject, predicate, object);
        } else if (this.getConsumer().isDataPropertyOnly(subject) && this.getConsumer().isDataPropertyOnly(object)) {
            this.translateSubDataProperty(subject, predicate, object);
        } else {
            URI subPropRange = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDFS_RANGE.getURI(), false);
            if (subPropRange != null) {
                if (this.getConsumer().isDataRange(subPropRange)) {
                    this.translateSubDataProperty(subject, predicate, object);
                } else {
                    this.translateSubObjectProperty(subject, predicate, object);
                }
                return;
            }
            URI supPropRange = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDFS_RANGE.getURI(), false);
            if (supPropRange != null) {
                if (this.getConsumer().isDataRange(supPropRange)) {
                    this.translateSubDataProperty(subject, predicate, object);
                } else {
                    this.translateSubObjectProperty(subject, predicate, object);
                }
                return;
            }
            this.translateSubObjectProperty(subject, predicate, object);
        }
    }

    private void translateSubObjectProperty(URI subject, URI predicate, URI object) throws OWLException {
        this.addAxiom(this.getDataFactory().getOWLSubObjectPropertyAxiom(this.translateObjectProperty(subject), this.translateObjectProperty(object)));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateSubDataProperty(URI subject, URI predicate, URI object) throws OWLException {
        this.addAxiom(this.getDataFactory().getOWLSubDataPropertyAxiom(this.translateDataProperty(subject), this.translateDataProperty(object)));
        this.consumeTriple(subject, predicate, object);
    }
}

