/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.logging.Logger;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TPTypeHandler
extends TriplePredicateHandler {
    private static final Logger logger = Logger.getLogger(TPTypeHandler.class.getName());

    public TPTypeHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDF_TYPE.getURI());
    }

    @Override
    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return !this.isAnonymous(object) && (object.equals(OWLRDFVocabulary.OWL_THING.getURI()) || !OWLRDFVocabulary.BUILT_IN_VOCABULARY.contains(object));
    }

    @Override
    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        if (OWLRDFVocabulary.BUILT_IN_VOCABULARY.contains(object) && !object.equals(OWLRDFVocabulary.OWL_THING.getURI())) {
            logger.fine("Individual of builtin type " + object);
        }
        this.addAxiom(this.getDataFactory().getOWLClassAssertionAxiom(this.translateIndividual(subject), this.translateDescription(object)));
        this.consumeTriple(subject, predicate, object);
    }
}

