/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import org.coode.owl.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLNaryPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TypeAllDisjointPropertiesHandler
extends BuiltInTypeHandler {
    public TypeAllDisjointPropertiesHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getURI());
    }

    @Override
    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        OWLNaryPropertyAxiom<OWLObjectPropertyExpression> disjointPropertiesAxiom;
        this.consumeTriple(subject, predicate, object);
        URI listNode = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_MEMBERS.getURI(), true);
        if (this.getConsumer().isObjectPropertyOnly(this.getConsumer().getFirstResource(listNode, false))) {
            List<OWLObjectPropertyExpression> props = this.getConsumer().translateToObjectPropertyList(listNode);
            disjointPropertiesAxiom = this.getDataFactory().getOWLDisjointObjectPropertiesAxiom(new HashSet<OWLObjectPropertyExpression>(props));
        } else {
            List<OWLDataPropertyExpression> props = this.getConsumer().translateToDataPropertyList(listNode);
            disjointPropertiesAxiom = this.getDataFactory().getOWLDisjointDataPropertiesAxiom(new HashSet<OWLDataPropertyExpression>(props));
        }
        this.getConsumer().addAxiom(disjointPropertiesAxiom);
        this.getConsumer().addReifiedAxiom(subject, disjointPropertiesAxiom);
    }

    @Override
    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return false;
    }
}

