/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.OWLRDFXMLParserMalformedNodeException;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TypeNegativePropertyAssertionHandler
extends BuiltInTypeHandler {
    public TypeNegativePropertyAssertionHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getURI());
    }

    @Override
    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return false;
    }

    @Override
    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        OWLPropertyAssertionAxiom<OWLDataPropertyExpression, OWLConstant> ax;
        this.consumeTriple(subject, predicate, object);
        URI sourceIndividualURI = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getURI(), true);
        if (sourceIndividualURI == null) {
            throw new OWLRDFXMLParserMalformedNodeException("missing owl:sourceIndividual triple");
        }
        OWLIndividual sourceIndividual = this.translateIndividual(sourceIndividualURI);
        URI assertionPropertyURI = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getURI(), true);
        if (assertionPropertyURI == null) {
            throw new OWLRDFXMLParserMalformedNodeException("missing owl:assertionProperty triple");
        }
        URI targetIndividualURI = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL.getURI(), true);
        OWLConstant targetValue = this.getConsumer().getLiteralObject(subject, OWLRDFVocabulary.OWL_TARGET_VALUE.getURI(), true);
        if (targetIndividualURI != null) {
            if (targetValue != null) {
                throw new OWLRDFXMLParserMalformedNodeException("owl:targetIndividual and owl:targetValue triples with the same subject");
            }
            OWLObjectPropertyExpression assertionProperty = this.translateObjectProperty(assertionPropertyURI);
            OWLIndividual targetIndividual = this.translateIndividual(targetIndividualURI);
            ax = this.getDataFactory().getOWLNegativeObjectPropertyAssertionAxiom(sourceIndividual, assertionProperty, targetIndividual);
        } else {
            if (targetValue == null) {
                throw new OWLRDFXMLParserMalformedNodeException("missing owl:targetIndividual or owl:targetValue triple");
            }
            OWLDataPropertyExpression assertionProperty = this.translateDataProperty(assertionPropertyURI);
            ax = this.getDataFactory().getOWLNegativeDataPropertyAssertionAxiom(sourceIndividual, assertionProperty, targetValue);
        }
        this.addAxiom(ax);
        this.getConsumer().addReifiedAxiom(subject, ax);
    }
}

